/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.bootstrap;

import com.adobe.coldfusion.bootstrap.ConsoleLogRotationHandler;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Security;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Bootstrap {
    private static Log log = LogFactory.getLog(Bootstrap.class);
    private static String COLDFUSION_HOME = System.getProperty("coldfusion.home");
    private static String CATALINA_HOME = COLDFUSION_HOME + "/runtime/lib";
    public static final String EULA_ACCEPTED = "EULA_ACCEPTED";
    private ClassLoader classLoader = null;
    private Boolean stopping = false;
    private Boolean starting = false;
    private Boolean restarting = false;
    private Boolean status = false;
    private boolean validArgs = false;
    private boolean console = false;

    private Boolean isValidArgs() {
        return this.validArgs;
    }

    private void initClassLoaders() {
        String[] locations = new String[]{COLDFUSION_HOME + "/lib/cfusion-req.jar", COLDFUSION_HOME + "/bin/cf-startup.jar", CATALINA_HOME};
        try {
            this.classLoader = this.createClassLoaders(locations, null);
        }
        catch (Throwable t) {
            log.error((Object)"ClassLoader error", t);
            System.exit(1);
        }
    }

    public void init() throws Exception {
        String sRandomDRBGConfig = System.getProperty("securerandom.drbg.config");
        if (sRandomDRBGConfig != null) {
            Security.setProperty("securerandom.drbg.config", sRandomDRBGConfig);
        } else if (Boolean.getBoolean("coldfusion.enablefipscrypto")) {
            Security.setProperty("securerandom.drbg.config", "HMAC_DRBG,SHA-256,128,none");
        }
        this.initClassLoaders();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        Class<?> launcherClass = Thread.currentThread().getContextClassLoader().loadClass("com.adobe.coldfusion.launcher.Launcher");
        String methodName = null;
        Object launcherInstance = launcherClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        methodName = "setColdFusionHome";
        Class[] paramTypes = new Class[]{String.class};
        Method method = launcherInstance.getClass().getMethod(methodName, paramTypes);
        File fInstance_path = new File(COLDFUSION_HOME);
        COLDFUSION_HOME = fInstance_path.getCanonicalPath();
        method.invoke(launcherInstance, COLDFUSION_HOME);
        if (this.starting.booleanValue()) {
            if (!this.console) {
                ConsoleLogRotationHandler.handleConsoleLogRotation();
            }
            methodName = "run";
            method = launcherInstance.getClass().getMethod(methodName, new Class[0]);
            method.invoke(launcherInstance, new Object[0]);
        } else if (this.stopping.booleanValue()) {
            methodName = "stopServer";
            method = launcherInstance.getClass().getMethod(methodName, new Class[0]);
            method.invoke(launcherInstance, new Object[0]);
        } else if (this.restarting.booleanValue()) {
            methodName = "restartServer";
            method = launcherInstance.getClass().getMethod(methodName, new Class[0]);
            method.invoke(launcherInstance, new Object[0]);
            if (!this.console) {
                ConsoleLogRotationHandler.handleConsoleLogRotation();
            }
        } else if (this.status.booleanValue()) {
            methodName = "serverStatus";
            method = launcherInstance.getClass().getMethod(methodName, new Class[0]);
            method.invoke(launcherInstance, new Object[0]);
        }
    }

    private void parseArgs(String[] args) {
        for (String arg : args) {
            if (arg.equalsIgnoreCase("-start") || arg.equalsIgnoreCase("start")) {
                this.starting = true;
                this.stopping = false;
                this.validArgs = true;
                try {
                    this.portcheck(COLDFUSION_HOME + "/runtime/conf/server.xml");
                }
                catch (IOException | ParserConfigurationException | SAXException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            if (arg.equalsIgnoreCase("-stop") || arg.equalsIgnoreCase("stop")) {
                this.starting = false;
                this.stopping = true;
                this.validArgs = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-restart") || arg.equalsIgnoreCase("restart")) {
                this.starting = false;
                this.stopping = false;
                this.restarting = true;
                this.validArgs = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-status") || arg.equalsIgnoreCase("status")) {
                this.starting = false;
                this.stopping = false;
                this.restarting = false;
                this.status = true;
                this.validArgs = true;
                continue;
            }
            if (!arg.equalsIgnoreCase("-console") || !File.separator.equals("\\")) continue;
            this.console = true;
        }
    }

    public void printUsage() {
        System.out.println(this.getClass().getName() + " : -start/-stop/-status ");
    }

    public static void main(String[] args) {
        String lang;
        Properties props = new Properties();
        boolean eulaAccepted = false;
        File eulaAcceptFile = new File(COLDFUSION_HOME + "/lib/licenseinfo.properties");
        if (eulaAcceptFile != null && eulaAcceptFile.exists()) {
            try {
                props.load(new FileReader(eulaAcceptFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String eulaAcceptVal = props.getProperty(EULA_ACCEPTED);
            if (eulaAcceptVal != null && eulaAcceptVal.equalsIgnoreCase("true")) {
                eulaAccepted = true;
            }
        }
        if (!eulaAccepted) {
            boolean isWindows = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
            String cfHomeAbsPath = COLDFUSION_HOME;
            try {
                cfHomeAbsPath = new File(COLDFUSION_HOME).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String path = cfHomeAbsPath + "/bin";
            if (isWindows) {
                path = cfHomeAbsPath + "\\bin";
            }
            Locale locale = Locale.getDefault();
            ResourceBundle rb = ResourceBundle.getBundle("com.adobe.coldfusion.bootstrap.resource", locale);
            String pattern = rb.getString("eulamessage");
            String eulaMessage = MessageFormat.format(pattern, path);
            System.err.println(eulaMessage);
            System.exit(0);
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.parseArgs(args);
        if (!bootstrap.isValidArgs().booleanValue()) {
            bootstrap.printUsage();
        }
        if ((lang = System.getProperty("user.language")) != null && !lang.equals("en") && !lang.equals("ja")) {
            System.setProperty("user.language", "en");
        }
        try {
            bootstrap.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ClassLoader createClassLoaders(String[] locations, ClassLoader parent) throws Exception {
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        if (locations != null) {
            for (String location : locations) {
                String[] filenames;
                if (location.toLowerCase().endsWith(".jar")) {
                    File file = new File(location);
                    if (!(file = new File(file.getCanonicalPath())).exists() || !file.isFile() || !file.canRead()) continue;
                    URL url = file.toURI().toURL();
                    set.add(url);
                    continue;
                }
                File directory = new File(location);
                if (!(directory = new File(directory.getCanonicalPath())).exists() || !directory.isDirectory() || !directory.canRead()) continue;
                for (String filename : filenames = directory.list()) {
                    if (!filename.toLowerCase().endsWith(".jar")) continue;
                    File file = new File(directory, filename);
                    if (!(file = new File(file.getCanonicalPath())).exists() || !file.canRead()) continue;
                    URL url = file.toURI().toURL();
                    set.add(url);
                }
            }
        }
        URL[] array = set.toArray(new URL[set.size()]);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < array.length; ++i) {
                log.debug((Object)("  location " + i + " is " + array[i]));
            }
        }
        this.classLoader = new URLClassLoader(array);
        return this.classLoader;
    }

    private void portcheck(String serverXml) throws ParserConfigurationException, SAXException, IOException {
        File fXmlFile = new File(serverXml);
        String serverXmlAbs = fXmlFile.getCanonicalPath();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        NodeList connectorLists = doc.getElementsByTagName("Connector");
        for (int item = 0; item < connectorLists.getLength(); ++item) {
            int iPort;
            boolean isPortActive;
            Node nNode = connectorLists.item(item);
            Element eElement = (Element)nNode;
            String port = eElement.getAttribute("port");
            if (port == null || port.equals("") || !(isPortActive = this.isPortActive(iPort = Integer.parseInt(port)))) continue;
            System.err.println(System.getProperty("line.separator") + "Some other server/application is using the port " + port + System.getProperty("line.separator") + "Change the server connector port in the file " + serverXmlAbs + " and start the server." + System.getProperty("line.separator") + "Exiting ....." + System.getProperty("line.separator") + "Ex: <Connector port=\"8502\"" + System.getProperty("line.separator"));
            System.exit(2);
        }
    }

    private boolean isPortActive(int port) {
        boolean IsActive;
        Socket s = null;
        try {
            s = new Socket("127.0.0.1", port);
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IsActive = true;
        }
        catch (Exception ex) {
            IsActive = false;
        }
        return IsActive;
    }
}

