/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.lambda;

import com.adobe.coldfusion.lambda.Arguments;
import com.adobe.coldfusion.lambda.ZipUtil;

public class Launcher {
    private static final String DIRECTORY = "-directory";
    private static final String SN = "-sn";
    private static final String PSN = "-previoussn";
    private static final String ACCEPT_EULA = "-acceptEULA";

    public static void main(String[] args) {
        Arguments cmdLineArgs = Launcher.extractArgs(args);
        ZipUtil.createArchive(cmdLineArgs);
    }

    private static Arguments extractArgs(String[] args) {
        Arguments arguments = new Arguments();
        boolean ignore = false;
        if (args.length == 0) {
            return arguments;
        }
        for (int i = 0; i < args.length; ++i) {
            if (ignore) {
                ignore = false;
                continue;
            }
            if (args[i].equalsIgnoreCase(DIRECTORY) && i + 1 < args.length && args[i + 1].trim().length() > 0 && !Launcher.isArgumentName(args[i + 1])) {
                ignore = true;
                arguments.setZipDir(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase(SN) && i + 1 < args.length && args[i + 1].trim().length() > 0 && !Launcher.isArgumentName(args[i + 1])) {
                ignore = true;
                arguments.setSn(args[i + 1]);
            }
            if (args[i].equalsIgnoreCase(PSN) && i + 1 < args.length && args[i + 1].trim().length() > 0 && !Launcher.isArgumentName(args[i + 1])) {
                ignore = true;
                arguments.setPrevious_sn(args[i + 1]);
            }
            if (!args[i].equalsIgnoreCase(ACCEPT_EULA) || i + 1 >= args.length || args[i + 1].trim().length() <= 0 || Launcher.isArgumentName(args[i + 1])) continue;
            ignore = true;
            String value = args[i + 1];
            arguments.setEulaAccepted(value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes"));
        }
        return arguments;
    }

    private static boolean isArgumentName(String arg) {
        return arg.equals(DIRECTORY) || arg.equals(SN) || arg.equals(PSN) || arg.equals(ACCEPT_EULA);
    }
}

