/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.entman;

import com.adobe.coldfusion.entman.JettyConfXmlHandler;
import com.adobe.coldfusion.launcher.ParserUtils;
import com.adobe.coldfusion.launcher.ServerConfigParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.catalina.startup.ExpandWar;
import org.apache.jasper.JasperException;
import org.apache.jasper.xmlparser.TreeNode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProcessServer {
    private static final String NEO_SECURITY_XML = "neo-security.xml";
    private static final String staticpassword = "***************";
    private static final String applicationhome = "{application.home}";
    protected File configDir;
    protected String baseDir;
    protected String serverName;
    protected String displayName;
    protected static final String hfUpdatesDir = "hf-updates";
    private static final String hfUpdatesFile = "updates.xml";
    private static final String hfInstallVarFile = "installvariables.properties";
    private static final String hfLogFile = "hotfix_filelist.log";
    private static final String webinf = "wwwroot" + File.separator + "WEB-INF";
    protected String serverDir = null;
    protected TreeNode treeNode = null;
    private Log logger = LogFactory.getLog(this.getClass());
    private TreeNode tempnode = null;
    protected static final String[] baseDirectories = new String[]{"conf", "lib", "bin", "manager"};
    protected static final String[] cfusionDirectories = new String[]{"MonitoringServer", "charting", "color_profiles", "CustomTags", "bin", "registry", "db" + File.separator + "slserver54", "gateway", "lib", "wwwroot" + File.separator + "CFIDE", "wwwroot" + File.separator + "restplay", "Mail", "wwwroot" + File.separator + "cf_scripts", "cfx", "cache", "jintegra", "stubs", "gql", "maven", "hf-updates"};
    protected static final String[] excludeFiles = new String[]{"bin" + File.separator + "felix-cache", "bin" + File.separator + "cfinstall.bat", "bin" + File.separator + "cfinstall.sh", "bin" + File.separator + "cfuninstall.bat", "bin" + File.separator + "cfuninstall.sh", "lib" + File.separator + "bundles", "lib" + File.separator + "ccs" + File.separator + "status", "lib" + File.separator + "ccs" + File.separator + "nodes.properties", "lib" + File.separator + "ngl-preconditioning-data.json", "wwwroot" + File.separator + "CFIDE" + File.separator + "gettingstarted", "wwwroot" + File.separator + "CFIDE" + File.separator + "administrator" + File.separator + "entman"};
    protected static final String[] neoXmlFiles = new String[]{"neo-metric.xml", "neo-websocket.xml"};
    protected static final String neoMonitorXmlFile = "neo-monitoring.xml";
    protected static final String commonsdaemonnative = "commons-daemon-native.tar.gz";
    private static final int timeOut = Integer.getInteger("instance.check.timeout", 1000);

    protected TreeNode getRootNode() {
        if (this.treeNode != null) {
            return this.treeNode;
        }
        ParserUtils utils = new ParserUtils(false);
        URI uri = this.getConfigFile().toURI();
        InputSource is = new InputSource(uri.toString());
        try {
            this.treeNode = utils.parseXMLDocument(uri.toString(), is);
        }
        catch (Throwable t) {
            this.logger.error((Object)("Error parsing config file: " + this.getConfigFile().getAbsolutePath()), t);
        }
        return this.treeNode;
    }

    public String getServicePrefix() {
        if (this.getRootNode() != null) {
            TreeNode rootNode = this.getRootNode();
            Iterator serversIt = rootNode.findChildren("server");
            while (serversIt.hasNext()) {
                TreeNode serviceName;
                TreeNode server = (TreeNode)serversIt.next();
                if (!server.findChild("name").getBody().equals("cfusion") || (serviceName = server.findChild("serviceName")) == null || serviceName.getBody() == null || serviceName.getBody().trim().length() <= 0) continue;
                return serviceName.getBody();
            }
        }
        return "ColdFusion 2025 Application Server";
    }

    public static String getConfigFileName() {
        return "instances.xml";
    }

    public String getServerDir() {
        return this.serverDir;
    }

    public void setServerDir(String serverDir) {
        this.serverDir = serverDir;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setConfigDir(String configDir) {
        this.configDir = new File(configDir);
    }

    private File getConfigFile() {
        return new File(this.configDir, "instances.xml");
    }

    private boolean isSecure(String directory, String port) {
        String serverConfig = directory + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
        ServerConfigParser parser = new ServerConfigParser(serverConfig);
        try {
            parser.parse();
        }
        catch (JasperException e) {
            return false;
        }
        boolean secure = parser.isSecure(port);
        parser.close();
        return secure;
    }

    public String getInternalPort(String serverName) {
        String port = "";
        TreeNode treeNode = this.getServerNode(serverName);
        if (treeNode != null) {
            String directory = treeNode.findChild("directory").getBody();
            port = this.getPort(directory, true);
        }
        return port;
    }

    public String getServerPort(String serverName) {
        String port = "";
        TreeNode treeNode = this.getServerNode(serverName);
        if (treeNode != null) {
            String directory = treeNode.findChild("directory").getBody();
            port = this.getPort(directory, !this.isServerRemote(serverName));
        }
        return port;
    }

    public String getPort(String directory, boolean internal) {
        String serverConfig = directory + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
        ServerConfigParser parser = new ServerConfigParser(serverConfig);
        try {
            parser.parse();
        }
        catch (JasperException e) {
            return "";
        }
        String port = parser.getConnectorPort(internal);
        parser.close();
        return port;
    }

    public String getLoadBalancingFactor(String serverName) {
        TreeNode serverNode = this.getServerNode(serverName);
        TreeNode lbFactorNode = serverNode.findChild("lbfactor");
        if (lbFactorNode != null) {
            return lbFactorNode.getBody();
        }
        return "1";
    }

    private void store() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.getConfigFile());
            writer.write(this.getRootNode().toString());
        }
        catch (Throwable t) {
            this.logger.error((Object)("Error storing " + ProcessServer.getConfigFileName() + ":"), t);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setLoadBalancingFactor(String serverName, String lbFactor) {
        TreeNode serverNode = this.getServerNode(serverName);
        TreeNode lbFactorNode = serverNode.findChild("lbfactor");
        if (lbFactorNode == null) {
            lbFactorNode = new TreeNode("lbfactor", serverNode);
        }
        lbFactorNode.setBody(lbFactor);
        this.store();
    }

    public ArrayList<String> getServers() {
        ArrayList<String> serversList = new ArrayList<String>();
        try {
            TreeNode node = this.getRootNode();
            Iterator servers = node.findChildren("server");
            while (servers.hasNext()) {
                TreeNode server = (TreeNode)servers.next();
                String name = server.findChild("name").getBody();
                serversList.add(name);
            }
        }
        catch (Throwable e) {
            this.logger.info((Object)"Error retrieving servers", e);
        }
        return serversList;
    }

    public boolean isServerRemote(String serverName) {
        String remote;
        TreeNode node = this.getServerNode(serverName);
        if (node != null && (remote = node.findAttribute("remote")) != null) {
            return Boolean.parseBoolean(remote);
        }
        return false;
    }

    public Map<String, String> getRemoteServerCredentials(String serverName) {
        HashMap<String, String> list = new HashMap<String, String>();
        TreeNode node = this.getRootNode();
        Iterator servers = node.findChildren("server");
        while (servers.hasNext()) {
            TreeNode server = (TreeNode)servers.next();
            if (server.findAttribute("remote") == null || !server.findAttribute("remote").equalsIgnoreCase("true") || !server.findChild("name").getBody().equalsIgnoreCase(serverName)) continue;
            list.put("adminusername", server.findChild("adminusername").getBody());
            list.put("adminpassword", server.findChild("adminpassword").getBody());
        }
        return list;
    }

    public Map<String, String> listRemoteServer(String serverName) {
        HashMap<String, String> list = new HashMap<String, String>();
        TreeNode node = this.getRootNode();
        Iterator servers = node.findChildren("server");
        while (servers.hasNext()) {
            TreeNode server = (TreeNode)servers.next();
            if (server.findAttribute("remote") == null || !server.findAttribute("remote").equalsIgnoreCase("true") || !server.findChild("name").getBody().equalsIgnoreCase(serverName)) continue;
            list.put("name", server.findChild("name").getBody());
            list.put("remote", "true");
            list.put("host", server.findChild("host").getBody());
            list.put("jvmroute", server.findChild("jvmroute").getBody());
            list.put("remoteport", server.findChild("port").getBody());
            list.put("httpport", server.findChild("httpport").getBody());
            list.put("adminport", server.findChild("adminport").getBody());
            list.put("adminusername", server.findChild("adminusername").getBody());
            list.put("https", server.findChild("https").getBody());
            if (server.findChild("adminpassword").getBody() != null) {
                list.put("adminpassword", staticpassword);
            } else {
                list.put("adminusername", server.findChild("adminpassword").getBody());
            }
            list.put("lbfactor", server.findChild("lbfactor").getBody());
            TreeNode secretKeyNode = null;
            secretKeyNode = server.findChild("secretKey");
            if (secretKeyNode != null) {
                list.put("secretkey", secretKeyNode.getBody());
            }
            TreeNode ajpSharedSecret = null;
            ajpSharedSecret = server.findChild("ajpSharedSecret");
            if (ajpSharedSecret == null) continue;
            list.put("ajpsecretkey", ajpSharedSecret.getBody());
        }
        return list;
    }

    public ArrayList<Map<String, String>> doList() throws JasperException {
        ArrayList<Map<String, String>> serversList = new ArrayList<Map<String, String>>();
        TreeNode node = this.getRootNode();
        Iterator servers = node.findChildren("server");
        while (servers.hasNext()) {
            TreeNode server = (TreeNode)servers.next();
            String remote = server.findAttribute("remote");
            boolean isRemote = false;
            if (remote != null) {
                isRemote = Boolean.parseBoolean(remote);
            }
            HashMap<String, String> list = new HashMap<String, String>();
            list.put("name", server.findChild("name").getBody());
            if (!isRemote) {
                list.put("remote", "false");
                String directory = server.findChild("directory").getBody();
                list.put("directory", directory);
                String port = this.getPort(directory, true);
                list.put("httpport", port);
                list.put("remoteport", this.getPort(directory, false));
                if (this.isSecure(directory, port)) {
                    list.put("https", "true");
                } else {
                    list.put("https", "false");
                }
            } else {
                list.put("remote", "true");
                list.put("host", server.findChild("host").getBody());
                list.put("jvmroute", server.findChild("jvmroute").getBody());
                list.put("remoteport", server.findChild("port").getBody());
                list.put("httpport", server.findChild("httpport").getBody());
                list.put("adminport", server.findChild("adminport").getBody());
                list.put("adminusername", server.findChild("adminusername").getBody());
                list.put("adminpassword", server.findChild("adminpassword").getBody());
                list.put("https", server.findChild("https").getBody());
                list.put("ajpSharedSecret", server.findChild("ajpSharedSecret").getBody());
            }
            serversList.add(list);
        }
        return serversList;
    }

    private TreeNode getServerNode(String serverName) {
        TreeNode node = this.getRootNode();
        Iterator servers = node.findChildren("server");
        while (servers.hasNext()) {
            TreeNode server = (TreeNode)servers.next();
            if (!server.findChild("name").getBody().equalsIgnoreCase(serverName)) continue;
            return server;
        }
        return null;
    }

    private static String getJavaExeFromPath(String path, String javaExe) {
        File fileJre = new File(path, "jre" + File.separator + "bin" + File.separator + javaExe);
        File file = new File(path, "bin" + File.separator + javaExe);
        if (fileJre.exists()) {
            return fileJre.getAbsolutePath();
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return javaExe;
    }

    private static String getJavaExe(String path) {
        String javaExe = "java";
        if (File.separatorChar == '\\') {
            javaExe = "javaw.exe";
        }
        if (path != null) {
            return ProcessServer.getJavaExeFromPath(path, javaExe);
        }
        String javaHome = System.getenv("JAVA_HOME");
        return ProcessServer.getJavaExeFromPath(javaHome, javaExe);
    }

    public boolean stopServer(String serverName) {
        TreeNode server = this.getServerNode(serverName);
        if (server != null) {
            String directory = server.findChild("directory").getBody();
            String jvmConfig = directory + File.separator + "bin" + File.separator + "jvm.config";
            try {
                String executablePath = directory + File.separator + "bin";
                String executable = executablePath + File.separator + "coldfusion";
                if (File.separatorChar == '\\') {
                    executable = executable + ".exe";
                    processBuilder = new ProcessBuilder(executable, "stop");
                    processBuilder.directory(new File(executablePath));
                    processBuilder.start();
                } else {
                    processBuilder = new ProcessBuilder(LinuxCommandUtils.getStopCommand(jvmConfig, directory));
                    processBuilder.directory(new File(executablePath));
                    Process p = processBuilder.start();
                    p.getErrorStream();
                }
                for (int waitCount = 0; waitCount <= 10 && !this.isServerShut(serverName); ++waitCount) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)"Error stopping instance", t);
                return false;
            }
        }
        return true;
    }

    public boolean restartServer(String serverName) {
        boolean status = this.stopServer(serverName);
        if (!status) {
            return status;
        }
        for (int waitCount = 0; waitCount <= 10 && !this.isServerShut(serverName); ++waitCount) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.startServer(serverName);
    }

    public boolean startServer(String serverName) {
        TreeNode server = this.getServerNode(serverName);
        if (server != null) {
            String directory = server.findChild("directory").getBody();
            try {
                String executablePath = directory + File.separator + "bin";
                String executable = executablePath + File.separator + "coldfusion";
                if (File.separatorChar == '\\') {
                    executable = executable + ".exe";
                    processBuilder = new ProcessBuilder(executable, "start");
                    processBuilder.directory(new File(executablePath));
                    processBuilder.start();
                } else {
                    String jvmConfig = directory + File.separator + "bin" + File.separator + "jvm.config";
                    processBuilder = new ProcessBuilder(LinuxCommandUtils.getStartCommand(jvmConfig, directory));
                    processBuilder.directory(new File(executablePath));
                    processBuilder.start();
                }
                int count = 0;
                while (!this.isServerActive(serverName) && count++ < 5) {
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)"Error starting instance", t);
                return false;
            }
            return true;
        }
        return false;
    }

    public void setPort(String serverName, String port, boolean internal) {
        TreeNode node = this.getServerNode(serverName);
        if (node != null && port != null && !port.equalsIgnoreCase("")) {
            String directory = node.findChild("directory").getBody();
            ServerConfigParser config = new ServerConfigParser(directory + "/runtime/conf/server.xml");
            try {
                config.parse();
                config.setConnectorPort(port, internal);
                config.store();
                config.close();
            }
            catch (Throwable t) {
                this.logger.error((Object)"Error retrieving port ", t);
            }
        }
    }

    public boolean isServerActive(String host, String port) {
        String adminUrl = "http://" + host + ":" + port + "/CFIDE/administrator/index.cfm";
        boolean success = this.checkUrl(adminUrl);
        if (!success) {
            adminUrl = "https://" + host + ":" + port + "/CFIDE/administrator/index.cfm";
            success = this.checkUrl(adminUrl);
        }
        return success;
    }

    public boolean isServerShut(String serverName) {
        boolean serverShut = false;
        TreeNode server = this.getServerNode(serverName);
        if (server != null) {
            String directory = server.findChild("directory").getBody();
            String httpPort = this.getPort(directory, true);
            String jwsPort = this.getPort(directory, false);
            if (!httpPort.equalsIgnoreCase("") && ProcessServer.isPortAvailable(Integer.parseInt(httpPort)) && !jwsPort.equalsIgnoreCase("") && ProcessServer.isPortAvailable(Integer.parseInt(jwsPort))) {
                serverShut = true;
            }
        }
        return serverShut;
    }

    public boolean isServerActive(String serverName) {
        boolean serverActive = false;
        TreeNode server = this.getServerNode(serverName);
        if (server != null) {
            String directory = server.findChild("directory").getBody();
            String httpPort = this.getPort(directory, true);
            String jwsPort = this.getPort(directory, false);
            String protocol = "http";
            if (this.isSecure(directory, httpPort)) {
                protocol = "https";
            }
            String adminUrl = protocol + "://localhost:" + httpPort + "/CFIDE/administrator/index.cfm";
            if (!httpPort.equalsIgnoreCase("") && !ProcessServer.isPortAvailable(Integer.parseInt(httpPort))) {
                serverActive = this.checkUrl(adminUrl);
            } else if (!jwsPort.equalsIgnoreCase("") && !ProcessServer.isPortAvailable(Integer.parseInt(jwsPort))) {
                serverActive = true;
            }
        }
        return serverActive;
    }

    public boolean isHttpsEnabled(String serverName) {
        String httpPort;
        String directory;
        boolean httpsEnabled = false;
        TreeNode server = this.getServerNode(serverName);
        if (server != null && this.isSecure(directory = server.findChild("directory").getBody(), httpPort = this.getPort(directory, true))) {
            httpsEnabled = true;
        }
        return httpsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUrl(String url) {
        HttpURLConnection connection = null;
        boolean success = false;
        try {
            URL server = new URL(url);
            connection = (HttpURLConnection)server.openConnection();
            connection.setConnectTimeout(timeOut);
            connection.setReadTimeout(timeOut);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                success = true;
            }
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return success;
    }

    protected String getBaseServerPath() throws JasperException {
        return ((TreeNode)this.getRootNode().findChildren("server").next()).findChild("directory").getBody();
    }

    protected String getBaseServerName() throws JasperException {
        return ((TreeNode)this.getRootNode().findChildren("server").next()).findChild("name").getBody();
    }

    protected String[] getAllServerPaths() throws JasperException {
        ArrayList<String> servers = new ArrayList<String>();
        TreeNode treeNode = this.getRootNode();
        Iterator nodes = treeNode.findChildren("server");
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            if (node.findAttribute("remote") != null && node.findAttribute("remote").equalsIgnoreCase("true")) continue;
            servers.add(node.findChild("directory").getBody());
        }
        return servers.toArray(new String[servers.size()]);
    }

    public void deleteServer() throws JasperException, IOException {
        if (!this.isServerRemote(this.serverName)) {
            String basePath = new File(this.getBaseServerPath() + File.separator + "..").getAbsolutePath();
            String newServerDir = basePath + File.separator + this.serverName;
            ExpandWar.delete((File)new File(newServerDir));
        }
        this.deleteConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultConfigFile(File configFile) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(configFile);
            writer.write("<servers>\n</servers>");
        }
        catch (Throwable e) {
            this.logger.error((Object)"Error adding remote server", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void addRemoteServer(String serverName, String hostName, String jvmRoute, String remotePort, String httpport, String adminport, String adminusername, String adminpassword, String lbFactor, String https, String secretKey, String ajpSharedSecret) throws NoSuchAlgorithmException {
        TreeNode node;
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.createDefaultConfigFile(configFile);
        }
        if ((node = this.getRootNode()) != null) {
            TreeNode serverNode = new TreeNode("server", node);
            serverNode.addAttribute("remote", "true");
            new TreeNode("name", serverNode).setBody(serverName);
            new TreeNode("host", serverNode).setBody(hostName);
            new TreeNode("jvmroute", serverNode).setBody(jvmRoute);
            new TreeNode("port", serverNode).setBody(remotePort);
            new TreeNode("httpport", serverNode).setBody(httpport);
            new TreeNode("lbfactor", serverNode).setBody(lbFactor);
            new TreeNode("adminport", serverNode).setBody(adminport);
            new TreeNode("adminusername", serverNode).setBody(adminusername);
            new TreeNode("https", serverNode).setBody(https);
            new TreeNode("ajpSharedSecret", serverNode).setBody(ajpSharedSecret);
            if (secretKey == null) {
                secretKey = "";
            }
            new TreeNode("secretKey", serverNode).setBody(secretKey);
            if (this.tempnode != null && adminpassword.length() > 0) {
                if (!adminpassword.equals(staticpassword)) {
                    new TreeNode("adminpassword", serverNode).setBody(this.hash(adminpassword, "SHA-256"));
                } else {
                    new TreeNode("adminpassword", serverNode).setBody(this.tempnode.findChild("adminpassword").getBody());
                }
                this.tempnode = null;
            } else if (adminpassword.length() > 0) {
                new TreeNode("adminpassword", serverNode).setBody(this.hash(adminpassword, "SHA-256"));
            } else {
                new TreeNode("adminpassword", serverNode).setBody(adminpassword);
            }
            this.store();
        }
    }

    private String hash(String input, String algorithm) throws NoSuchAlgorithmException {
        byte[] byteinput = null;
        byteinput = input.getBytes();
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.reset();
        digest.update(byteinput);
        byteinput = digest.digest();
        return this.stringify(byteinput);
    }

    private String stringify(byte[] buf) {
        StringBuffer sb = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            int h = (buf[i] & 0xF0) >> 4;
            int l = buf[i] & 0xF;
            sb.append((char)(h > 9 ? 65 + h - 10 : 48 + h));
            sb.append((char)(l > 9 ? 65 + l - 10 : 48 + l));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer() throws JasperException, IOException {
        int i;
        int i2;
        String basePath = new File(this.getBaseServerPath() + File.separator + "..").getCanonicalPath();
        String baseServerPath = new File(this.getBaseServerPath()).getCanonicalPath();
        Object newServerBasePath = this.serverDir == null ? basePath + File.separator + this.serverName : new File(this.serverDir).getCanonicalPath();
        String newServerRuntimeDir = (String)newServerBasePath + File.separator + "runtime";
        String baseServerRuntimeDir = baseServerPath + File.separator + "runtime";
        if (new File(baseServerPath + File.separator + hfUpdatesDir).exists()) {
            this.updateHFVarInst();
        }
        File newServerFile = new File(newServerRuntimeDir);
        newServerFile.mkdirs();
        for (i2 = 0; i2 < baseDirectories.length; ++i2) {
            ExpandWar.copy((File)new File(baseServerRuntimeDir, baseDirectories[i2]), (File)new File(newServerFile, baseDirectories[i2]));
        }
        new File((String)newServerBasePath + File.separator + "wwwroot").mkdir();
        new File((String)newServerBasePath + File.separator + "db").mkdir();
        for (i2 = 0; i2 < cfusionDirectories.length; ++i2) {
            File src = new File(baseServerPath, cfusionDirectories[i2]);
            if (!src.canRead()) continue;
            File dest = new File((String)newServerBasePath, cfusionDirectories[i2]);
            ExpandWar.copy((File)src, (File)dest);
        }
        new File((String)newServerBasePath, webinf).mkdir();
        File[] webinfolders = new File(baseServerPath, webinf).listFiles();
        for (i = 0; i < webinfolders.length; ++i) {
            File src;
            if (webinfolders[i].getName().contains("cfclasses") || !(src = new File(baseServerPath, webinf + File.separator + webinfolders[i].getName())).canRead()) continue;
            String[] dest = new File((String)newServerBasePath, webinf + File.separator + webinfolders[i].getName());
            ExpandWar.copy((File)src, (File)dest);
        }
        for (i = 0; i < excludeFiles.length; ++i) {
            File dir = new File((String)newServerBasePath, excludeFiles[i]);
            if (!dir.exists()) continue;
            ExpandWar.delete((File)dir);
        }
        new File((String)newServerBasePath, "wwwroot" + File.separator + "WEB-INF" + File.separator + "cfclasses").mkdir();
        new File((String)newServerBasePath, "logs").mkdir();
        this.updateCCSConfig((String)newServerBasePath + File.separator + "lib");
        this.updatePorts();
        try {
            this.updateSMJettyPort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateJvmConfig();
        this.updateNeoXmls();
        this.updateNeoMonitoringXml();
        this.updateLog4jProperties(baseServerPath, (String)newServerBasePath);
        this.updateSandboxes((String)newServerBasePath + File.separator + "lib", baseServerPath, (String)newServerBasePath);
        this.updateAdminCookieId((String)newServerBasePath + File.separator + "lib");
        if (new File(baseServerPath + File.separator + hfUpdatesDir).exists()) {
            String[] hfnames;
            this.updateHotFixFiles();
            File file = new File((String)newServerBasePath + File.separator + hfUpdatesDir);
            for (String hfname : hfnames = file.list()) {
                if (!new File((String)newServerBasePath + File.separator + hfUpdatesDir + File.separator + hfname).isDirectory()) continue;
                ProcessServer.updateScripts((String)newServerBasePath + File.separator + hfUpdatesDir + File.separator + hfname + File.separator + "backup" + File.separator + "bin", baseServerPath, (String)newServerBasePath);
                ProcessServer.updateScripts((String)newServerBasePath + File.separator + hfUpdatesDir + File.separator + hfname + File.separator + "uninstall", baseServerPath, (String)newServerBasePath);
                ProcessServer.updateScripts((String)newServerBasePath + File.separator + hfUpdatesDir + File.separator + hfname + File.separator + "uninstall", "\\\\" + new File(baseServerPath).getName(), "\\\\" + new File((String)newServerBasePath).getName());
            }
        }
        ProcessServer.updateScripts((String)newServerBasePath + File.separator + "bin", baseServerPath, (String)newServerBasePath);
        ProcessServer.updateScripts((String)newServerBasePath + File.separator + "runtime" + File.separator + "bin", baseServerPath, (String)newServerBasePath);
        this.updateServerAJPSecret(newServerRuntimeDir + File.separator + "conf" + File.separator + "server.xml");
        this.disableCluster(newServerRuntimeDir + File.separator + "conf" + File.separator + "server.xml");
        this.disableClusterInContextXml(newServerRuntimeDir + File.separator + "conf" + File.separator + "context.xml");
        if (File.separatorChar != '\\') {
            this.addExecutePermission((String)newServerBasePath + File.separator + "bin");
            this.addExecutePermission(newServerRuntimeDir + File.separator + "bin");
        }
        this.updateConfig();
        File gzipfile = new File(newServerRuntimeDir + File.separator + "bin", commonsdaemonnative);
        gzipfile.delete();
        File infile = new File(baseServerRuntimeDir + File.separator + "bin", commonsdaemonnative);
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        byte[] buffer = new byte[8192];
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(infile));
            out = new BufferedOutputStream(new FileOutputStream(new File(newServerRuntimeDir + File.separator + "bin", commonsdaemonnative)));
            while ((read = in.read(buffer, 0, 8192)) != -1) {
                ((BufferedOutputStream)out).write(buffer, 0, read);
            }
            ((BufferedOutputStream)out).flush();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private Document updatePortValueInXml(Document document, String attributeName, int portValue) {
        NodeList varNodeList = document.getElementsByTagName("var");
        for (int s = 0; s < varNodeList.getLength(); ++s) {
            Node firstNode = varNodeList.item(s);
            Element firstElement = (Element)firstNode;
            String attributeField = firstElement.getAttribute("name");
            if (!attributeField.equalsIgnoreCase(attributeName)) continue;
            NodeList stringNodeList = firstElement.getElementsByTagName("string");
            firstElement = (Element)stringNodeList.item(0);
            firstElement.setTextContent(String.valueOf(portValue));
            break;
        }
        return document;
    }

    private Document updateStatPort(DocumentBuilderFactory factory, String neoMetricFileName) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        String[] servers = this.getAllServerPaths();
        ArrayList<Integer> allStatPorts = new ArrayList<Integer>();
        for (String server : servers) {
            String neoMetricXml = new File(server).getCanonicalPath() + File.separator + "lib" + File.separator + neoMetricFileName;
            Document doc = builder.parse(neoMetricXml);
            NodeList varNodeList = doc.getElementsByTagName("var");
            for (int s = 0; s < varNodeList.getLength(); ++s) {
                Node firstNode = varNodeList.item(s);
                Element firstElement = (Element)firstNode;
                String attributeName = firstElement.getAttribute("name");
                if (!attributeName.equalsIgnoreCase("cfstatport")) continue;
                NodeList stringNodeList = firstElement.getElementsByTagName("string");
                firstElement = (Element)stringNodeList.item(0);
                allStatPorts.add(Integer.parseInt(firstElement.getTextContent()));
            }
        }
        int statPort = 7989;
        while (allStatPorts.contains(statPort) || !ProcessServer.isPortAvailable(statPort)) {
            ++statPort;
        }
        String currentNeoMetricPath = this.getServerDir() + File.separator + "lib" + File.separator + neoMetricFileName;
        Document doc = builder.parse(currentNeoMetricPath);
        return this.updatePortValueInXml(doc, "cfstatport", statPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCCSConfig(String lib) {
        String ccsConfigPath = lib + File.separator + "ccs" + File.separator + "ccs.properties";
        FilterInputStream ds = null;
        Properties _props = new Properties();
        try {
            ds = new DataInputStream(new FileInputStream(ccsConfigPath));
            _props.load(ds);
            _props.put("ccssecretkey", "");
            _props.put("enabled", "false");
            _props.put("hostname", "");
            _props.put("hostport", "");
        }
        catch (Throwable e) {
            this.logger.error((Object)("Error parsing config file: " + ccsConfigPath), e);
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try (FileOutputStream stream = new FileOutputStream(new File(ccsConfigPath));){
            _props.store(stream, null);
        }
        catch (Throwable e) {
            this.logger.error((Object)("Error saving config file: " + ccsConfigPath), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerAJPSecret(String file) {
        try (ServerConfigParser parser = new ServerConfigParser(file);){
            parser.parse();
            parser.setAJPSecret(true);
            parser.store();
        }
    }

    private void updateLog4jProperties(String oldPath, String newPath) throws JasperException, IOException {
        String newServerConfigFile = newPath + File.separator + "lib" + File.separator + "log4j.properties";
        File logFile = new File(newServerConfigFile);
        ProcessServer.replace(logFile, oldPath, newPath);
    }

    private void updateSandboxes(String path, String oldPath, String newPath) {
        File file = new File(path, NEO_SECURITY_XML);
        if (file != null && file.exists()) {
            ProcessServer.replace(file, oldPath, newPath);
        }
    }

    private void updateAdminCookieId(String path) {
        try {
            String toReplace = "<var name='cfadmin\\.cookieidentifier'><string>\\d*</string></var>";
            ProcessServer.replace(new File(path, NEO_SECURITY_XML), toReplace, "", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void disableCluster(String path) {
        try {
            ServerConfigParser serverConfigParser = new ServerConfigParser(path);
            serverConfigParser.parse();
            serverConfigParser.removeClusterNode();
            serverConfigParser.store();
            serverConfigParser.close();
        }
        catch (Throwable e) {
            this.logger.error((Object)"Unable to disable cluster in new server instance", e);
        }
    }

    private void disableClusterInContextXml(String contextxml) {
        Vector<String> filedata = new Vector<String>(50, 25);
        try (BufferedReader reader = new BufferedReader(new FileReader(contextxml));){
            Object line = null;
            while ((line = reader.readLine()) != null) {
                if (((String)line).toLowerCase().contains("<manager")) {
                    if (((String)line).toLowerCase().contains("pathname")) {
                        if (((String)line).trim().startsWith("<!--")) {
                            line = ((String)line).substring(4, ((String)line).indexOf("-->"));
                        }
                    } else if (((String)line).contains("className") && ((String)line).contains("notifyListenersOnReplication") && !((String)line).trim().startsWith("<!--")) {
                        line = "<!--" + ((String)line).substring(((String)line).indexOf(60)) + "-->";
                    }
                }
                filedata.add((String)line);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(contextxml)));){
            for (int i = 0; i < filedata.size(); ++i) {
                writer.println((String)filedata.elementAt(i));
            }
            writer.flush();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    protected static void replace(File file, String oldPath, String newPath) {
        ProcessServer.replace(file, oldPath, newPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void replace(File file, String oldPath, String newPath, boolean escape) {
        BufferedReader reader = null;
        Object text = "";
        String newline = System.getProperty("line.separator");
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                text = (String)text + line + newline;
            }
            if (File.separatorChar == '\\' && escape) {
                text = ((String)text).replaceAll(oldPath.replaceAll("\\\\", "\\\\\\\\"), newPath.replaceAll("\\\\", "\\\\\\\\"));
                text = ((String)text).replaceAll(oldPath.replaceAll("\\\\", "/"), newPath.replaceAll("\\\\", "/"));
            } else {
                text = ((String)text).replaceAll(oldPath, newPath);
            }
        }
        catch (IOException line) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException line) {}
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.write((String)text);
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isServerExists(String serverName) {
        TreeNode node = null;
        node = this.getRootNode();
        if (node != null) {
            Iterator servers = node.findChildren("server");
            while (servers.hasNext()) {
                TreeNode server = (TreeNode)servers.next();
                String name = server.findChild("name").getBody();
                if (!name.equalsIgnoreCase(serverName)) continue;
                return true;
            }
        }
        return false;
    }

    protected static void updateScripts(String path, String oldPath, String newPath) {
        List<String> excludeList = Arrays.asList("exe", "pmc", "config", "jar", "dll", "zip", "so", "bin", "tar", "iap_xml", "hprof", "mdmp");
        File filePath = new File(path);
        File[] files = filePath.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (excludeList.contains(fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()))) continue;
                ProcessServer.replace(file, oldPath, newPath);
            }
        }
    }

    protected void addExecutePermission(String path) {
        File[] files;
        File filePath = new File(path);
        for (File file : files = filePath.listFiles()) {
            file.setExecutable(true, true);
        }
    }

    public static boolean isPortAvailable(final int portNum) {
        if (System.getSecurityManager() == null) {
            return ProcessServer.isPortFreeHelper(portNum);
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ProcessServer.isPortFreeHelper(portNum) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortFreeHelper(int port) {
        boolean available = false;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            available = true;
        }
        catch (IOException e) {
            available = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return available;
    }

    protected static boolean isShutdownPortAvailable(final int portNum) {
        if (System.getSecurityManager() == null) {
            return ProcessServer.isShutdownPortFreeHelper(portNum);
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ProcessServer.isShutdownPortFreeHelper(portNum) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isShutdownPortFreeHelper(int port) {
        boolean available = false;
        ServerSocket socket = null;
        String address = "localhost";
        try {
            socket = new ServerSocket(port, 1, InetAddress.getByName(address));
            available = true;
        }
        catch (IOException e) {
            available = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return available;
    }

    private void updatePorts() throws JasperException, IOException {
        String[] servers = this.getAllServerPaths();
        ArrayList<String> shutdownPorts = new ArrayList<String>();
        ArrayList<String> jwsConnectorPorts = new ArrayList<String>();
        ArrayList<String> ajpConnectorPorts = new ArrayList<String>();
        ArrayList<String> redirectPorts = new ArrayList<String>();
        ArrayList<String> receiverPorts = new ArrayList<String>();
        ArrayList<String> allPorts = new ArrayList<String>();
        for (String server : servers) {
            String configFile = new File(server).getCanonicalPath() + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
            ServerConfigParser parser = new ServerConfigParser(configFile);
            parser.parse();
            shutdownPorts.add(parser.getShutDownPort());
            jwsConnectorPorts.add(parser.getConnectorPort(true));
            ajpConnectorPorts.add(parser.getConnectorPort());
            redirectPorts.add(parser.getRedirectPort());
            receiverPorts.add(parser.getReceiverPort());
        }
        allPorts.addAll(shutdownPorts);
        allPorts.addAll(jwsConnectorPorts);
        allPorts.addAll(ajpConnectorPorts);
        allPorts.addAll(redirectPorts);
        allPorts.addAll(receiverPorts);
        int shutdownPort = 8007;
        while (allPorts.contains(Integer.toString(shutdownPort)) || !ProcessServer.isShutdownPortAvailable(shutdownPort)) {
            ++shutdownPort;
        }
        allPorts.add(String.valueOf(shutdownPort));
        int internalConnectorPort = 8500;
        while (allPorts.contains(Integer.toString(internalConnectorPort)) || !ProcessServer.isPortAvailable(internalConnectorPort)) {
            ++internalConnectorPort;
        }
        allPorts.add(String.valueOf(internalConnectorPort));
        int ajpPort = 8012;
        while (allPorts.contains(Integer.toString(ajpPort)) || !ProcessServer.isPortAvailable(ajpPort)) {
            ++ajpPort;
        }
        allPorts.add(String.valueOf(ajpPort));
        int redirectport = 8445;
        while (allPorts.contains(Integer.toString(redirectport)) || !ProcessServer.isPortAvailable(redirectport)) {
            ++redirectport;
        }
        allPorts.add(String.valueOf(redirectport));
        int receiverport = 4001;
        while (allPorts.contains(Integer.toString(receiverport)) || !ProcessServer.isPortAvailable(receiverport)) {
            ++receiverport;
        }
        String newServerConfigFile = new File(this.serverDir + File.separator + "..").getCanonicalPath() + File.separator + this.serverName + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
        this.updateServerXmlPorts(newServerConfigFile, redirectport, internalConnectorPort, ajpPort, shutdownPort, receiverport);
        String hfDir = new File(this.serverDir + File.separator + "..").getCanonicalPath() + File.separator + this.serverName + File.separator + hfUpdatesDir;
        File hfUpdatesDirFile = new File(hfDir);
        if (hfUpdatesDirFile.exists() && hfUpdatesDirFile.isDirectory()) {
            File[] hfFolders;
            for (File hfFolder : hfFolders = hfUpdatesDirFile.listFiles()) {
                if (!hfFolder.isDirectory() || !hfFolder.getName().startsWith("hf")) continue;
                String backupServerXml = hfFolder.getAbsolutePath() + File.separator + "backup" + File.separator + "runtime" + File.separator + "conf" + File.separator + "server.xml";
                String backupContextXml = hfFolder.getAbsolutePath() + File.separator + "backup" + File.separator + "runtime" + File.separator + "conf" + File.separator + "context.xml";
                if (!new File(backupServerXml).exists()) continue;
                this.updateServerXmlPorts(backupServerXml, redirectport, internalConnectorPort, ajpPort, shutdownPort, receiverport);
                this.disableCluster(backupServerXml);
                this.disableClusterInContextXml(backupContextXml);
            }
        }
        this.updateNeoXml(internalConnectorPort);
    }

    private void updateServerXmlPorts(String file, int redirectport, int internalConnectorPort, int ajpPort, int shutdownPort, int receiverport) throws JasperException, IOException {
        ServerConfigParser parserNew = new ServerConfigParser(file);
        parserNew.parse();
        parserNew.setRedirectPort(Integer.toString(redirectport));
        parserNew.setConnectorPort(Integer.toString(internalConnectorPort), true);
        parserNew.setConnectorPort(Integer.toString(ajpPort), false);
        parserNew.setShutdownPort(Integer.toString(shutdownPort));
        parserNew.setReceiverPort(Integer.toString(receiverport));
        parserNew.addJvmRoute(this.serverName);
        parserNew.store();
        this.updateNeoXml(internalConnectorPort);
    }

    private void updateSMJettyPort() throws JasperException, IOException {
        String[] servers = this.getAllServerPaths();
        ArrayList<Integer> allPorts = new ArrayList<Integer>();
        for (String server : servers) {
            JettyConfXmlHandler xmlHandler;
            String basePath = new File(server + File.separator + ".." + File.separator + "..").getCanonicalPath();
            File jettyFile = new File(basePath + File.separatorChar + "lib" + File.separatorChar + "jetty.xml");
            if (!jettyFile.exists() || !jettyFile.isFile() || (xmlHandler = JettyConfXmlHandler.getInstance(jettyFile)) == null) continue;
            int serverPort = new Integer(xmlHandler.getPortValue());
            allPorts.add(serverPort);
        }
        this._updateSMJettyPort(allPorts);
    }

    private void _updateSMJettyPort(List<Integer> allPorts) {
        File jettyFile = new File(this.getServerDir() + File.separatorChar + "lib" + File.separatorChar + "jetty.xml");
        JettyConfXmlHandler xmlHandler = JettyConfXmlHandler.getInstance(jettyFile);
        if (xmlHandler != null) {
            int serverMonitorPort = 5500;
            while (allPorts.contains(serverMonitorPort) || !ProcessServer.isPortAvailable(serverMonitorPort)) {
                ++serverMonitorPort;
            }
            xmlHandler.updatePort("" + serverMonitorPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNeoMonitoringXml() {
        String neomonitorpath = this.getServerDir() + File.separator + "lib" + File.separator + neoMonitorXmlFile;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        FileOutputStream file = null;
        FilterOutputStream out = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            Document document = builder.parse(neomonitorpath);
            NodeList nodeLst = document.getElementsByTagName("var");
            int nodeListLength = nodeLst.getLength();
            for (int s = 0; s < nodeListLength; ++s) {
                NodeList nl;
                Node fstNode = nodeLst.item(s);
                Element fstElmnt = (Element)fstNode;
                String attname = fstElmnt.getAttribute("name");
                if (attname.equalsIgnoreCase("displayname")) {
                    nl = fstElmnt.getElementsByTagName("string");
                    fstElmnt = (Element)nl.item(0);
                    fstElmnt.setTextContent(this.displayName != null && !this.displayName.isEmpty() ? this.displayName : this.serverName);
                    continue;
                }
                if (attname.equalsIgnoreCase("elasticsearchhost")) {
                    nl = fstElmnt.getElementsByTagName("string");
                    fstElmnt = (Element)nl.item(0);
                    fstElmnt.setTextContent("");
                    continue;
                }
                if (attname.equalsIgnoreCase("uuid")) {
                    nl = fstElmnt.getElementsByTagName("string");
                    fstElmnt = (Element)nl.item(0);
                    fstElmnt.setTextContent("");
                    continue;
                }
                if (!attname.equalsIgnoreCase("pmtdashboardurl")) continue;
                nl = fstElmnt.getElementsByTagName("string");
                fstElmnt = (Element)nl.item(0);
                fstElmnt.setTextContent("");
            }
            StreamResult result = new StreamResult(new StringWriter());
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            file = new FileOutputStream(neomonitorpath, false);
            out = new DataOutputStream(file);
            ((DataOutputStream)out).writeBytes(xmlString);
            ((DataOutputStream)out).flush();
        }
        catch (Throwable t) {
            this.logger.error((Object)("Error parsing config file: " + neomonitorpath), t);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException builder) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNeoXml(int connectorport) throws IOException {
        Document document;
        String neometricpath = this.getServerDir() + File.separator + "lib" + File.separator + neoXmlFiles[0];
        String neowebsocketpath = this.getServerDir() + File.separator + "lib" + File.separator + neoXmlFiles[1];
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        FileOutputStream file1 = null;
        FilterOutputStream out = null;
        FilterOutputStream out1 = null;
        try {
            document = this.updateStatPort(factory, neoXmlFiles[0]);
        }
        catch (Throwable e) {
            this.logger.error((Object)("Error parsing config file: " + neometricpath), e);
            throw new RuntimeException(e);
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            document = this.updatePortValueInXml(document, "cfconnectorport", connectorport);
            StreamResult result = new StreamResult(new StringWriter());
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            FileOutputStream file = new FileOutputStream(neometricpath, false);
            out = new DataOutputStream(file);
            ((DataOutputStream)out).writeBytes(xmlString);
            ((DataOutputStream)out).flush();
            document = builder.parse(neowebsocketpath);
            String[] servers = this.getAllServerPaths();
            ArrayList<String> wsPorts = new ArrayList<String>();
            ArrayList<String> wsSSLPorts = new ArrayList<String>();
            ArrayList<String> proxyConnectPorts = new ArrayList<String>();
            ArrayList<String> allPorts = new ArrayList<String>();
            for (String server : servers) {
                String configFile = new File(server).getCanonicalPath() + File.separator + "lib" + File.separator + "neo-websocket.xml";
                Document doc = builder.parse(configFile);
                NodeList nodeList = doc.getElementsByTagName("var");
                for (int s = 0; s < nodeList.getLength(); ++s) {
                    Node fstNode = nodeList.item(s);
                    Element fstElmnt = (Element)fstNode;
                    String attname = fstElmnt.getAttribute("name");
                    if (attname.equalsIgnoreCase("port")) {
                        wsPorts.add(this.getString(fstElmnt));
                        continue;
                    }
                    if (attname.equalsIgnoreCase("sslport")) {
                        wsSSLPorts.add(this.getString(fstElmnt));
                        continue;
                    }
                    if (!attname.equalsIgnoreCase("proxyConnectport")) continue;
                    proxyConnectPorts.add(this.getString(fstElmnt));
                }
            }
            allPorts.addAll(wsPorts);
            allPorts.addAll(wsSSLPorts);
            allPorts.addAll(proxyConnectPorts);
            NodeList nodeLst = document.getElementsByTagName("var");
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                NodeList nl;
                Node fstNode = nodeLst.item(s);
                Element fstElmnt = (Element)fstNode;
                String attname = fstElmnt.getAttribute("name");
                if (attname.equalsIgnoreCase("flashFallBack")) {
                    nl = fstElmnt.getElementsByTagName("boolean");
                    fstElmnt = (Element)nl.item(0);
                    fstElmnt.setAttribute("value", "true");
                    continue;
                }
                if (!attname.equalsIgnoreCase("port") && !attname.equalsIgnoreCase("flashPolicyPort") && !attname.equalsIgnoreCase("sslport") && !attname.equalsIgnoreCase("proxyConnectport")) continue;
                nl = fstElmnt.getElementsByTagName("string");
                fstElmnt = (Element)nl.item(0);
                int port = Integer.parseInt(fstElmnt.getTextContent());
                while (!(attname.equalsIgnoreCase("flashPolicyPort") || !allPorts.contains(Integer.toString(port)) && ProcessServer.isPortAvailable(port))) {
                    ++port;
                }
                fstElmnt.setTextContent(String.valueOf(port));
            }
            StreamResult result1 = new StreamResult(new StringWriter());
            source = new DOMSource(document);
            transformer.transform(source, result1);
            xmlString = result1.getWriter().toString();
            file1 = new FileOutputStream(neowebsocketpath, false);
            out1 = new DataOutputStream(file1);
            ((DataOutputStream)out1).writeBytes(xmlString);
            ((DataOutputStream)out1).flush();
        }
        catch (Throwable t) {
            this.logger.error((Object)("Error parsing config file: " + neometricpath), t);
            this.logger.error((Object)("Error parsing config file: " + neowebsocketpath), t);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (out1 != null) {
                    out1.close();
                }
            }
            catch (IOException builder) {}
        }
    }

    private String getString(Element fstElmnt) {
        NodeList nl = fstElmnt.getElementsByTagName("string");
        fstElmnt = (Element)nl.item(0);
        return fstElmnt.getTextContent();
    }

    private void updateNeoXmls() throws IOException, JasperException {
        Object newcfRoot = this.getServerDir() + "/";
        newcfRoot = ((String)newcfRoot).replace("\\", "/");
        Object basecfRoot = this.getBaseServerPath() + "/";
        basecfRoot = ((String)basecfRoot).replace("\\", "/");
        String neoxmlspath = (String)newcfRoot + "lib" + File.separator;
        FilenameFilter xmlfilesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.lastIndexOf(".xml") + 4 == name.length() && name.indexOf("neo") == 0;
            }
        };
        File f = new File(neoxmlspath);
        File[] neoFiles = f.listFiles(xmlfilesFilter);
        for (int i = 0; i < neoFiles.length; ++i) {
            this.updateFile(neoFiles[i], (String)basecfRoot, (String)newcfRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFile(File neoXMLFile, String cfRootOld, String cfRootNew) {
        FileReader confReader = null;
        BufferedReader confbuff = null;
        OutputStreamWriter fileWriteConf = null;
        BufferedWriter outconf = null;
        try {
            String line;
            confReader = new FileReader(neoXMLFile);
            confbuff = new BufferedReader(confReader);
            StringBuffer confsb = new StringBuffer();
            while ((line = confbuff.readLine()) != null) {
                confsb.append(line + "\n");
            }
            String configUpdated = confsb.toString();
            String cfRootOldWindows = cfRootOld.replace("/", "\\");
            if (configUpdated.contains(cfRootOld) || configUpdated.contains(cfRootOldWindows)) {
                if ((configUpdated = configUpdated.replace(cfRootOld, cfRootNew)).contains(cfRootOldWindows)) {
                    configUpdated = configUpdated.replace(cfRootOldWindows, cfRootNew.replace("/", "\\"));
                }
                fileWriteConf = new FileWriter(neoXMLFile);
                outconf = new BufferedWriter(fileWriteConf);
                outconf.write(configUpdated);
                outconf.flush();
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        finally {
            try {
                if (confReader != null) {
                    confReader.close();
                }
                if (confbuff != null) {
                    confbuff.close();
                }
                if (fileWriteConf != null) {
                    fileWriteConf.close();
                }
                if (outconf != null) {
                    outconf.close();
                }
            }
            catch (IOException e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    protected void deleteConfig() throws IOException, JasperException {
        Iterator nodes = this.getRootNode().findChildren("server");
        boolean found = false;
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            if (!node.findChild("name").getBody().equalsIgnoreCase(this.serverName)) continue;
            this.tempnode = node;
            this.getRootNode().removeNode(node);
            found = true;
            break;
        }
        if (found) {
            FileWriter writer = new FileWriter(this.getConfigFile());
            writer.write(this.getRootNode().toString());
            writer.close();
        }
    }

    protected void updateConfig() throws JasperException, IOException {
        this.deleteConfig();
        String path = new File(this.getServerDir() + File.separator + ".." + File.separator + this.serverName).getCanonicalPath();
        TreeNode serverNode = new TreeNode("server", this.getRootNode());
        TreeNode nameNode = new TreeNode("name", serverNode);
        nameNode.setBody(this.serverName);
        TreeNode directoryNode = new TreeNode("directory", serverNode);
        directoryNode.setBody(path);
        TreeNode secretKeyNode = new TreeNode("secretKey", serverNode);
        secretKeyNode.setBody(UUID.randomUUID().toString());
        FileWriter writer = new FileWriter(this.getConfigFile());
        writer.write(this.getRootNode().toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateHotFixFiles() throws JasperException {
        String basePath = "";
        try {
            basePath = new File(this.getBaseServerPath() + File.separator + "..").getCanonicalPath();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        BufferedReader hfUpdatesReader = null;
        String baseservername = this.getBaseServerName();
        Object orgFileCont = "";
        Object newServerBasePath = this.serverDir == null ? basePath + File.separator + this.serverName : this.serverDir;
        ArrayList<String> hotFixesList = this.getHotFixesList();
        String hfRootpath = (String)newServerBasePath + File.separator + hfUpdatesDir;
        if (new File(hfRootpath).exists()) {
            try {
                hfUpdatesReader = new BufferedReader(new FileReader(new File(hfRootpath + File.separator + hfUpdatesFile)));
                String line = null;
                while ((line = hfUpdatesReader.readLine()) != null) {
                    orgFileCont = (String)orgFileCont + line + "\n\r";
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (hfUpdatesReader != null) {
                    try {
                        hfUpdatesReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            PrintWriter hfUpdatesWriter = null;
            BufferedReader hfLogsReader = null;
            Object hfLogFilePath = "";
            File fhfLogFilePath = null;
            Object hfInstallVarsFilePath = "";
            Iterator<String> iterator = hotFixesList.iterator();
            while (iterator.hasNext()) {
                Object orgLogFileCont = "";
                try {
                    hfUpdatesWriter = new PrintWriter(new FileWriter(hfRootpath + File.separator + hfUpdatesFile));
                    if (File.separatorChar == '\\') {
                        hfUpdatesWriter.println(((String)orgFileCont).replaceAll("\\\\" + baseservername + "\\\\", "\\\\" + this.serverName + "\\\\"));
                    } else {
                        hfUpdatesWriter.println(((String)orgFileCont).replaceAll("/" + baseservername + "/", "/" + this.serverName + "/"));
                    }
                    hfUpdatesWriter.flush();
                    String curntHFRootPath = hfRootpath + File.separator + iterator.next();
                    hfLogFilePath = curntHFRootPath + File.separator + hfLogFile;
                    hfInstallVarsFilePath = curntHFRootPath + File.separator + "uninstall" + File.separator + hfInstallVarFile;
                    fhfLogFilePath = new File((String)hfLogFilePath);
                    if (fhfLogFilePath.exists()) {
                        hfLogsReader = new BufferedReader(new FileReader(fhfLogFilePath));
                        String logLine = null;
                        while ((logLine = hfLogsReader.readLine()) != null) {
                            orgLogFileCont = (String)orgLogFileCont + logLine + "\r\n";
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (hfLogsReader != null) {
                        try {
                            hfLogsReader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (hfUpdatesWriter != null) {
                        hfUpdatesWriter.close();
                    }
                }
                try (PrintWriter hfLogsWriter = null;){
                    if (fhfLogFilePath != null & fhfLogFilePath.exists()) {
                        hfLogsWriter = new PrintWriter(new FileWriter((String)hfLogFilePath));
                        if (File.separatorChar == '\\') {
                            hfLogsWriter.println(((String)orgLogFileCont).replaceAll("\\\\" + baseservername + "\\\\", "\\\\" + this.serverName + "\\\\"));
                        } else {
                            hfLogsWriter.println(((String)orgLogFileCont).replaceAll("/" + baseservername + "/", "/" + this.serverName + "/"));
                        }
                        hfLogsWriter.flush();
                    }
                }
                if (!new File((String)hfInstallVarsFilePath).exists()) continue;
                OutputStreamWriter writer = null;
                Properties props = new Properties();
                try {
                    props.load(new FileInputStream((String)hfInstallVarsFilePath));
                    props.setProperty("INSTANCE_LIST", this.serverName);
                    props.setProperty("CF_INSTANCE_NAME", this.serverName);
                    props.setProperty("STARTSTOP_SERVER_LIST", this.serverName);
                    writer = new FileWriter((String)hfInstallVarsFilePath);
                    props.store(writer, "Updated while creating new instance " + this.serverName);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (writer == null) continue;
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHFVarInst() throws JasperException {
        ArrayList<String> hotFixesList = this.getHotFixesList();
        String hfRootpath = this.getBaseServerPath() + File.separator + hfUpdatesDir;
        Iterator<String> iterator = hotFixesList.iterator();
        while (iterator.hasNext()) {
            String curntHFRootPath = hfRootpath + File.separator + iterator.next();
            String hfInstallVarsFilePath = curntHFRootPath + File.separator + "uninstall" + File.separator + hfInstallVarFile;
            if (!new File(hfInstallVarsFilePath).exists()) continue;
            OutputStreamWriter writer = null;
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(hfInstallVarsFilePath));
                String hfAppliedInstList = props.getProperty("INSTANCE_LIST");
                props.setProperty("INSTANCE_LIST", hfAppliedInstList + "," + this.serverName);
                props.setProperty("INSTALLER_TITLE", "Adobe\u00c3\u0083\u00c2\u0082\u00c3\u0082\u00c2\u00ae ColdFusion\u00c3\u0083\u00c2\u0082\u00c3\u0082\u00c2\u00ae 2018 $HOTFIX_UI_NAME$");
                writer = new FileWriter(hfInstallVarsFilePath);
                props.store(writer, "Updated while creating new instance " + this.serverName);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (writer == null) continue;
                try {
                    writer.close();
                    props.clear();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ArrayList<String> getHotFixesList() {
        ArrayList<String> updatesList = new ArrayList<String>();
        try {
            TreeNode node = null;
            ParserUtils utils = new ParserUtils(false);
            File updatesFile = new File(this.getBaseServerPath() + File.separator + hfUpdatesDir, hfUpdatesFile);
            URI uri = updatesFile.toURI();
            InputSource is = new InputSource(uri.toString());
            try {
                node = utils.parseXMLDocument(uri.toString(), is);
            }
            catch (Throwable t) {
                this.logger.error((Object)("Error parsing config file: " + updatesFile.getAbsolutePath()), t);
            }
            if (node == null) {
                return new ArrayList<String>();
            }
            Iterator updates = node.findChildren("item");
            while (updates.hasNext()) {
                TreeNode update = (TreeNode)updates.next();
                String name = update.findChild("cfhf_id").getBody();
                updatesList.add(name);
            }
        }
        catch (Throwable e) {
            this.logger.info((Object)"Error retrieving updates", e);
        }
        return updatesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateJvmConfig() throws JasperException, IOException {
        String jvmConfig = new File(this.getBaseServerPath()).getCanonicalPath() + File.separator + "bin" + File.separator + "jvm.config";
        Properties props = new Properties();
        props.load(new FileInputStream(jvmConfig));
        String java_home = props.getProperty("java.home");
        String basePath = new File(this.getBaseServerPath() + File.separator + "..").getCanonicalPath();
        String newJvmConfigPath = this.getServerDir() + File.separator + "bin" + File.separator + "jvm.config";
        String baseservername = this.getBaseServerName();
        String java_args = props.getProperty("java.args").replace(baseservername, this.serverName);
        String java_classpath = props.getProperty("java.class.path").replace(baseservername, this.serverName);
        String java_libPath = props.getProperty("java.library.path").replace(baseservername, this.serverName);
        String new_java_args = "";
        StringTokenizer st = new StringTokenizer(java_args, " ");
        Object address = "";
        String port = "";
        int debugport = 5010;
        while (st.hasMoreElements()) {
            int indexi;
            String elem = (String)st.nextElement();
            if ((elem = elem.trim()).indexOf("-Dapim.home") != -1) {
                elem = "";
            }
            if (elem.indexOf("-Xrunjdwp:transport") != -1 && (indexi = elem.indexOf("address=")) != -1) {
                for (int indexj = indexi + 8; indexj < elem.length() && elem.charAt(indexj) != ','; ++indexj) {
                    address = (String)address + elem.charAt(indexj);
                }
                port = this.parsePortFromAddress((String)address);
                try {
                    debugport = Integer.parseInt(port) + this.getCurrentInstanceCount();
                }
                catch (NumberFormatException nfe) {
                    this.logger.error((Object)("The debug address argument " + (String)address + " in jvm.config is invalid. Ensure the debug argument in jvm.config is a valid [<ip>:]<port> format."));
                    this.logger.error((Object)nfe);
                    throw new InvalidJVMConfigException((String)address);
                }
                if (!port.isEmpty()) {
                    elem = elem.replaceFirst(port, Integer.toString(debugport));
                } else {
                    debugport += this.getCurrentInstanceCount();
                }
            }
            new_java_args = new_java_args.concat(elem);
            new_java_args = new_java_args.concat(" ");
        }
        File file = new File(this.getServerDir() + File.separator + hfUpdatesDir);
        String[] hfnames = file.list();
        if (hfnames != null) {
            for (String hfname : hfnames) {
                if (!new File(this.getServerDir() + File.separator + hfUpdatesDir + File.separator + hfname).isDirectory()) continue;
                PrintWriter hfJvmBackupWriter = null;
                String hfjvmBackupFilePath = this.getServerDir() + File.separator + hfUpdatesDir + File.separator + hfname + File.separator + "backup" + File.separator + "bin" + File.separator + "jvm.config";
                BufferedReader hfJvmHFBackuReader = null;
                File fhfjvmBackupFilePath = new File(hfjvmBackupFilePath);
                try {
                    if (!(fhfjvmBackupFilePath != null & fhfjvmBackupFilePath.exists())) continue;
                    Object orgLogFileCont = "";
                    if (fhfjvmBackupFilePath.exists()) {
                        hfJvmHFBackuReader = new BufferedReader(new FileReader(fhfjvmBackupFilePath));
                        String logLine = null;
                        while ((logLine = hfJvmHFBackuReader.readLine()) != null) {
                            orgLogFileCont = (String)orgLogFileCont + logLine + System.getProperty("line.separator");
                        }
                    }
                    hfJvmBackupWriter = new PrintWriter(new FileWriter(hfjvmBackupFilePath));
                    hfJvmBackupWriter.println(((String)orgLogFileCont).replaceFirst(port, Integer.toString(debugport)));
                    hfJvmBackupWriter.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (hfJvmBackupWriter != null) {
                        hfJvmBackupWriter.close();
                    }
                    if (hfJvmHFBackuReader != null) {
                        hfJvmHFBackuReader.close();
                    }
                }
            }
        }
        if (new_java_args.length() > 0) {
            java_args = new_java_args;
        }
        props.setProperty("java.home", java_home.replace('\\', '/'));
        props.setProperty("application.home", this.getServerDir().replace('\\', '/'));
        props.setProperty("java.args", java_args.replace('\\', '/'));
        props.setProperty("java.class.path", java_classpath.replace('\\', '/'));
        props.setProperty("java.library.path", java_libPath.replace('\\', '/'));
        try (FileWriter writer = null;){
            writer = new FileWriter(newJvmConfigPath);
            writer.write("#\n# VM configuration\n#\n# Where to find JVM, if {java.home}/jre exists then that JVM is used\n# if not then it must be the path to the JRE itself\n");
            writer.write("\n");
            writer.write("java.home=" + props.getProperty("java.home") + "\n");
            writer.write("\n");
            writer.write("#\n# If no java.home is specified a VM is located by looking in these places in this\n# order:\n#\n#  1) ../runtime/jre\n#  2) registry (windows only)\n#  3) JAVA_HOME env var plus jre (ie $JAVA_HOME/jre)\n#  4) java.exe in path\n#\n");
            writer.write("\n");
            writer.write("application.home=" + props.getProperty("application.home") + "\n");
            writer.write("\n");
            writer.write("# Arguments to VM\n");
            writer.write("java.args=" + props.getProperty("java.args") + "\n");
            writer.write("\n");
            writer.write("java.class.path=" + props.getProperty("java.class.path") + "\n");
            writer.write("\n");
            writer.write("# Comma separated list of shared library path\n");
            writer.write("java.library.path=" + props.getProperty("java.library.path") + "\n");
        }
    }

    private String parsePortFromAddress(String address) {
        String port = "";
        if (address != null && !address.isEmpty()) {
            int posColon = address.lastIndexOf(58);
            port = posColon >= 0 ? address.substring(posColon + 1) : address;
        }
        return port;
    }

    protected int getCurrentInstanceCount() {
        return this.getLocalInstances().size();
    }

    protected ArrayList getLocalInstances() {
        ArrayList<TreeNode> serversList = new ArrayList<TreeNode>();
        TreeNode node = this.getRootNode();
        Iterator servers = node.findChildren("server");
        while (servers.hasNext()) {
            TreeNode server = (TreeNode)servers.next();
            String remote = server.findAttribute("remote");
            boolean isRemote = false;
            if (remote != null) {
                isRemote = Boolean.parseBoolean(remote);
            }
            if (isRemote) continue;
            serversList.add(server);
        }
        return serversList;
    }

    public String getInstanceName() {
        String instance_path = System.getProperty("coldfusion.home");
        File fInstance_path = new File(instance_path);
        try {
            instance_path = fInstance_path.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int lastindex = instance_path.lastIndexOf("/");
        if (-1 == lastindex) {
            lastindex = instance_path.lastIndexOf("\\");
        }
        String instance_name = instance_path.substring(lastindex + 1);
        return instance_name;
    }

    public static class LinuxCommandUtils {
        private static String OS = null;
        private static final String CLASSPATH_FLAG = "-classpath";
        private static final String MAIN_CLASS = "com.adobe.coldfusion.bootstrap.Bootstrap";
        private static final String START_COMMAND = "-start";
        private static final String STOP_COMMAND = "-stop";
        private static final String BACKGROUND = "&";

        public static List<String> getStartCommand(String jvmConfig, String directory) throws Throwable {
            return LinuxCommandUtils.getCommand(jvmConfig, directory, START_COMMAND);
        }

        /*
         * WARNING - void declaration
         */
        public static List<String> getCommand(String jvmConfig, String directory, String command) throws Throwable {
            String[] args;
            Properties properties = new Properties();
            ArrayList<String> commandList = new ArrayList<String>();
            properties.load(new FileInputStream(jvmConfig));
            String java_home = properties.getProperty("java.home");
            String java_classPath = properties.getProperty("java.class.path");
            java_classPath = java_classPath.replace(ProcessServer.applicationhome, directory);
            String[] classpaths = java_classPath.split(",");
            Object classpath = "";
            classpath = (String)classpath + directory + File.separator + "runtime" + File.separator + "bin" + File.separator + "tomcat-juli.jar" + File.pathSeparator + directory + File.separator + "bin" + File.separator + "cf-bootstrap.jar" + File.pathSeparator;
            for (String string : classpaths) {
                void var12_15;
                if (string.endsWith(".jar")) {
                    classpath = (String)classpath + string + File.pathSeparator;
                    continue;
                }
                if (!string.endsWith(File.separator)) {
                    String string2 = string + File.separator;
                }
                classpath = (String)classpath + (String)var12_15 + "*" + File.pathSeparator;
            }
            String javaExe = ProcessServer.getJavaExe(java_home);
            commandList.add(javaExe);
            commandList.add(CLASSPATH_FLAG);
            commandList.add((String)classpath);
            String java_args = properties.getProperty("java.args");
            java_args = java_args.replace(ProcessServer.applicationhome, directory);
            for (String arg : args = java_args.split(" ")) {
                arg = arg.trim();
                commandList.add(arg);
            }
            commandList.add(MAIN_CLASS);
            commandList.add(command);
            commandList.add(BACKGROUND);
            return commandList;
        }

        /*
         * WARNING - void declaration
         */
        public static List<String> getStopCommand(String jvmConfig, String directory) throws Throwable {
            Properties properties = new Properties();
            ArrayList<String> commandList = new ArrayList<String>();
            properties.load(new FileInputStream(jvmConfig));
            String java_home = properties.getProperty("java.home");
            String java_classPath = properties.getProperty("java.class.path");
            java_classPath = java_classPath.replace(ProcessServer.applicationhome, directory);
            String[] classpaths = java_classPath.split(",");
            Object classpath = "";
            classpath = (String)classpath + directory + File.separator + "runtime" + File.separator + "bin" + File.separator + "tomcat-juli.jar" + File.pathSeparator + directory + File.separator + "bin" + File.separator + "cf-bootstrap.jar" + File.pathSeparator;
            for (String string : classpaths) {
                void var11_14;
                if (string.endsWith(".jar")) {
                    classpath = (String)classpath + string + File.pathSeparator;
                    continue;
                }
                if (!string.endsWith(File.separator)) {
                    String string2 = string + File.separator;
                }
                classpath = (String)classpath + (String)var11_14 + "*" + File.pathSeparator;
            }
            String javaExe = ProcessServer.getJavaExe(java_home);
            commandList.add(javaExe);
            commandList.add(CLASSPATH_FLAG);
            commandList.add((String)classpath);
            String java_args = properties.getProperty("java.args");
            java_args = java_args.replace(ProcessServer.applicationhome, directory);
            StringTokenizer tk = new StringTokenizer(java_args, " \t\n\r");
            while (tk.hasMoreTokens()) {
                String string = tk.nextToken();
                if (string.length() == 0 || string.toLowerCase().startsWith("-xdebug") || string.toLowerCase().startsWith("-xrunjdwp")) continue;
                commandList.add(string);
            }
            commandList.add(MAIN_CLASS);
            commandList.add(STOP_COMMAND);
            return commandList;
        }

        static {
            OS = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("os.name");
                }
            });
        }
    }

    public static class InvalidJVMConfigException
    extends IllegalArgumentException {
        public String address;

        public InvalidJVMConfigException(String address) {
            this.address = address;
        }
    }
}

