/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.util.FileUtils;

public class AntClassLoader2
extends AntClassLoader {
    private FileUtils fileUtils = FileUtils.newFileUtils();
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    protected Class defineClassFromData(File container, byte[] classData, String className) throws IOException {
        this.definePackage(container, className);
        return this.defineClass(className, classData, 0, classData.length, (class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = AntClassLoader2.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project).getProtectionDomain());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Manifest getJarManifest(File container) throws IOException {
        Manifest manifest;
        if (container.isDirectory()) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(container);
            manifest = jarFile.getManifest();
            Object var5_4 = null;
            if (jarFile == null) return manifest;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (jarFile == null) throw throwable;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
        return manifest;
    }

    protected void definePackage(File container, String className) throws IOException {
        int classIndex = className.lastIndexOf(46);
        if (classIndex == -1) {
            return;
        }
        String packageName = className.substring(0, classIndex);
        if (this.getPackage(packageName) != null) {
            return;
        }
        Manifest manifest = this.getJarManifest(container);
        if (manifest == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        } else {
            this.definePackage(container, packageName, manifest);
        }
    }

    protected void definePackage(File container, String packageName, Manifest manifest) {
        Attributes mainAttributes;
        String sectionName = packageName.replace('.', '/') + "/";
        String specificationTitle = null;
        String specificationVendor = null;
        String specificationVersion = null;
        String implementationTitle = null;
        String implementationVendor = null;
        String implementationVersion = null;
        String sealedString = null;
        URL sealBase = null;
        Attributes sectionAttributes = manifest.getAttributes(sectionName);
        if (sectionAttributes != null) {
            specificationTitle = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specificationVendor = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            specificationVersion = sectionAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            implementationTitle = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implementationVendor = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            implementationVersion = sectionAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            sealedString = sectionAttributes.getValue(Attributes.Name.SEALED);
        }
        if ((mainAttributes = manifest.getMainAttributes()) != null) {
            if (specificationTitle == null) {
                specificationTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specificationVendor == null) {
                specificationVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (specificationVersion == null) {
                specificationVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (implementationTitle == null) {
                implementationTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implementationVendor == null) {
                implementationVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (implementationVersion == null) {
                implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (sealedString == null) {
                sealedString = mainAttributes.getValue(Attributes.Name.SEALED);
            }
        }
        if (sealedString != null && sealedString.equalsIgnoreCase("true")) {
            try {
                sealBase = new URL("file:" + container.getPath());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.definePackage(packageName, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addPathFile(File pathComponent) throws IOException {
        String classpath;
        block19: {
            Object var8_6;
            InputStream manifestStream;
            ZipFile jarFile;
            block18: {
                block16: {
                    block17: {
                        super.addPathFile(pathComponent);
                        if (pathComponent.isDirectory()) {
                            return;
                        }
                        classpath = null;
                        jarFile = null;
                        manifestStream = null;
                        try {
                            try {
                                jarFile = new ZipFile(pathComponent);
                                manifestStream = jarFile.getInputStream(new ZipEntry("META-INF/MANIFEST.MF"));
                                if (manifestStream == null) {
                                    Object var8_5 = null;
                                    if (manifestStream == null) break block16;
                                    break block17;
                                }
                                InputStreamReader manifestReader = new InputStreamReader(manifestStream, "UTF-8");
                                org.apache.tools.ant.taskdefs.Manifest manifest = new org.apache.tools.ant.taskdefs.Manifest(manifestReader);
                                classpath = manifest.getMainSection().getAttributeValue("Class-Path");
                                break block18;
                            }
                            catch (ManifestException e) {
                                var8_6 = null;
                                if (manifestStream != null) {
                                    manifestStream.close();
                                }
                                if (jarFile != null) {
                                    jarFile.close();
                                }
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_7 = null;
                            if (manifestStream != null) {
                                manifestStream.close();
                            }
                            if (jarFile != null) {
                                jarFile.close();
                            }
                            throw throwable;
                        }
                    }
                    manifestStream.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
                return;
            }
            var8_6 = null;
            if (manifestStream != null) {
                manifestStream.close();
            }
            if (jarFile != null) {
                jarFile.close();
            }
        }
        if (classpath != null) {
            URL baseURL = this.fileUtils.getFileURL(pathComponent);
            StringTokenizer st = new StringTokenizer(classpath);
            while (st.hasMoreTokens()) {
                String classpathElement = st.nextToken();
                URL libraryURL = new URL(baseURL, classpathElement);
                if (!libraryURL.getProtocol().equals("file")) {
                    this.log("Skipping jar library " + classpathElement + " since only relative URLs are supported by this" + " loader", 3);
                    continue;
                }
                File libraryFile = new File(libraryURL.getFile());
                if (!libraryFile.exists() || this.isInPath(libraryFile)) continue;
                this.addPathFile(libraryFile);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

