/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private String manifestEncoding;
    private File manifestFile;
    private boolean index = false;
    private boolean createEmpty = false;
    private Vector rootEntries;

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
        this.rootEntries = new Vector();
    }

    public void setWhenempty(Zip.WhenEmpty we) {
        this.log("JARs are never empty, they contain at least a manifest file", 1);
    }

    public void setJarfile(File jarFile) {
        this.setDestFile(jarFile);
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    public void setManifestEncoding(String manifestEncoding) {
        this.manifestEncoding = manifestEncoding;
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            this.configuredManifest.merge(newManifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File manifestFile) {
        if (!manifestFile.exists()) {
            throw new BuildException("Manifest file: " + manifestFile + " does not exist.", this.getLocation());
        }
        this.manifestFile = manifestFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifest(File manifestFile) {
        Manifest newManifest = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            try {
                fis = new FileInputStream(manifestFile);
                isr = this.manifestEncoding == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, this.manifestEncoding);
                newManifest = this.getManifest(isr);
            }
            catch (UnsupportedEncodingException e) {
                throw new BuildException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new BuildException("Unable to read manifest file: " + manifestFile + " (" + e.getMessage() + ")", e);
            }
            Object var8_5 = null;
            if (isr == null) return newManifest;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (isr == null) throw throwable;
            try {
                isr.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        isr.close();
        return newManifest;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifestFromJar(File jarFile) throws IOException {
        block7: {
            zf = null;
            try {
                zf = new ZipFile(jarFile);
                e = zf.entries();
                do {
                    if (e.hasMoreElements()) continue;
                    var4_4 = null;
                    break block7;
                } while (!(ze = e.nextElement()).getName().equalsIgnoreCase("META-INF/MANIFEST.MF"));
                isr = new InputStreamReader(zf.getInputStream(ze), "UTF-8");
                var6_6 = this.getManifest(isr);
                var8_7 = null;
                if (zf == null) return var6_6;
            }
            catch (Throwable var7_13) {
                var8_9 = null;
                if (zf == null) throw var7_13;
                try {
                    zf.close();
                    throw var7_13;
                }
                catch (IOException e) {
                    throw var7_13;
                }
            }
            ** try [egrp 1[TRYBLOCK] [1 : 106->113)] { 
lbl27:
            // 1 sources

            zf.close();
            return var6_6;
lbl29:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var6_6;
        }
        var8_8 = null;
        if (zf == null) return var4_4;
        ** try [egrp 1[TRYBLOCK] [1 : 106->113)] { 
lbl36:
        // 1 sources

        zf.close();
        return var4_4;
lbl38:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var4_4;
    }

    private Manifest getManifest(Reader r) {
        Manifest newManifest = null;
        try {
            newManifest = new Manifest(r);
        }
        catch (ManifestException e) {
            this.log("Manifest is invalid: " + e.getMessage(), 0);
            throw new BuildException("Invalid Manifest: " + this.manifestFile, e, this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException("Unable to read manifest file (" + e.getMessage() + ")", e);
        }
        return newManifest;
    }

    public void setFilesetmanifest(FilesetManifestConfig config) {
        this.filesetManifestConfig = config;
        this.mergeManifestsMain = "merge".equals(config.getValue());
        if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.doubleFilePass = true;
        }
    }

    public void addMetainf(ZipFileSet fs) {
        fs.setPrefix("META-INF/");
        super.addFileset(fs);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (!this.skipWriting) {
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
        }
    }

    private Manifest createManifest() throws BuildException {
        try {
            Manifest finalManifest = Manifest.getDefaultManifest();
            if (this.manifest == null && this.manifestFile != null) {
                this.manifest = this.getManifest(this.manifestFile);
            }
            if (this.isInUpdateMode()) {
                finalManifest.merge(this.originalManifest);
            }
            finalManifest.merge(this.filesetManifest);
            finalManifest.merge(this.configuredManifest);
            finalManifest.merge(this.manifest, !this.mergeManifestsMain);
            return finalManifest;
        }
        catch (ManifestException e) {
            this.log("Manifest is invalid: " + e.getMessage(), 0);
            throw new BuildException("Invalid Manifest", e, this.getLocation());
        }
    }

    private void writeManifest(ZipOutputStream zOut, Manifest manifest) throws IOException {
        Enumeration e = manifest.getWarnings();
        while (e.hasMoreElements()) {
            this.log("Manifest warning: " + (String)e.nextElement(), 1);
        }
        this.zipDir(null, zOut, "META-INF/", 16877);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        manifest.write(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, MANIFEST_NAME, System.currentTimeMillis(), null, 33188);
        super.initZipOutputStream(zOut);
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    private void createIndexList(ZipOutputStream zOut) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.zipFile.getName());
        Enumeration<Object> e = this.addedDirs.keys();
        while (e.hasMoreElements()) {
            String dir = (String)e.nextElement();
            int pos = (dir = dir.replace('\\', '/')).lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            if (dir.startsWith("META-INF")) continue;
            writer.println(dir);
        }
        e = this.rootEntries.elements();
        while (e.hasMoreElements()) {
            writer.println(e.nextElement());
        }
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, INDEX_NAME, System.currentTimeMillis(), null, 33188);
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (MANIFEST_NAME.equalsIgnoreCase(vPath)) {
            if (!this.doubleFilePass || this.doubleFilePass && this.skipWriting) {
                this.filesetManifest(fromArchive, is);
            }
        } else if (INDEX_NAME.equalsIgnoreCase(vPath) && this.index) {
            this.log("Warning: selected " + this.archiveType + " files include a META-INF/INDEX.LIST which will" + " be replaced by a newly generated one.", 1);
        } else {
            if (this.index && vPath.indexOf("/") == -1) {
                this.rootEntries.addElement(vPath);
            }
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
        }
    }

    private void filesetManifest(File file, InputStream is) throws IOException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.log("Found manifest " + file, 3);
            try {
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    this.manifest = this.getManifest(isr);
                }
                this.manifest = this.getManifest(file);
            }
            catch (UnsupportedEncodingException e) {
                throw new BuildException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.log("Found manifest to merge in file " + file, 3);
            try {
                Manifest newManifest = null;
                if (is != null) {
                    InputStreamReader isr = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    newManifest = this.getManifest(isr);
                } else {
                    newManifest = this.getManifest(file);
                }
                if (this.filesetManifest == null) {
                    this.filesetManifest = newManifest;
                } else {
                    this.filesetManifest.merge(newManifest);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new BuildException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
            catch (ManifestException e) {
                this.log("Manifest in file " + file + " is invalid: " + e.getMessage(), 0);
                throw new BuildException("Invalid Manifest", e, this.getLocation());
            }
        }
    }

    protected Zip.ArchiveState getResourcesToAdd(FileSet[] filesets, File zipFile, boolean needsUpdate) throws BuildException {
        if (zipFile.exists()) {
            try {
                this.originalManifest = this.getManifestFromJar(zipFile);
                if (this.originalManifest == null) {
                    this.log("Updating jar since the current jar has no manifest", 3);
                    needsUpdate = true;
                } else {
                    Manifest mf = this.createManifest();
                    if (!mf.equals(this.originalManifest)) {
                        this.log("Updating jar since jar manifest has changed", 3);
                        needsUpdate = true;
                    }
                }
            }
            catch (Throwable t) {
                this.log("error while reading original manifest: " + t.getMessage(), 1);
                needsUpdate = true;
            }
        } else {
            needsUpdate = true;
        }
        this.createEmpty = needsUpdate;
        return super.getResourcesToAdd(filesets, zipFile, needsUpdate);
    }

    /*
     * Loose catch block
     */
    protected boolean createEmptyZip(File zipFile) throws BuildException {
        block12: {
            if (!this.createEmpty) {
                return true;
            }
            ZipOutputStream zOut = null;
            this.log("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
            zOut = new ZipOutputStream(new FileOutputStream(this.getDestFile()));
            zOut.setEncoding(this.getEncoding());
            if (this.isCompress()) {
                zOut.setMethod(8);
            } else {
                zOut.setMethod(0);
            }
            this.initZipOutputStream(zOut);
            this.finalizeZipOutputStream(zOut);
            Object var5_3 = null;
            try {
                if (zOut != null) {
                    zOut.close();
                }
                break block12;
            }
            catch (IOException ex) {
                // empty catch block
            }
            {
                break block12;
                catch (IOException ioe) {
                    throw new BuildException("Could not create almost empty JAR archive (" + ioe.getMessage() + ")", ioe, this.getLocation());
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (zOut != null) {
                        zOut.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.createEmpty = false;
                throw throwable;
            }
        }
        this.createEmpty = false;
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        if (!this.doubleFilePass || this.doubleFilePass && !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    public void reset() {
        super.reset();
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

