/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PathConvert
extends Task {
    private Path path = null;
    private Reference refid = null;
    private String targetOS = null;
    private boolean targetWindows = false;
    private boolean onWindows = false;
    private boolean setonempty = true;
    private String property = null;
    private Vector prefixMap = new Vector();
    private String pathSep = null;
    private String dirSep = null;

    public PathConvert() {
        this.onWindows = Os.isFamily("dos");
    }

    public Path createPath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path.createPath();
    }

    public MapEntry createMap() {
        MapEntry entry = new MapEntry();
        this.prefixMap.addElement(entry);
        return entry;
    }

    public void setTargetos(String target) {
        TargetOs to = new TargetOs();
        to.setValue(target);
        this.setTargetos(to);
    }

    public void setTargetos(TargetOs target) {
        this.targetOS = target.getValue();
        this.targetWindows = !this.targetOS.equals("unix") && !this.targetOS.equals("tandem");
    }

    public void setSetonempty(boolean setonempty) {
        this.setonempty = setonempty;
    }

    public void setProperty(String p) {
        this.property = p;
    }

    public void setRefid(Reference r) {
        if (this.path != null) {
            throw this.noChildrenAllowed();
        }
        this.refid = r;
    }

    public void setPathSep(String sep) {
        this.pathSep = sep;
    }

    public void setDirSep(String sep) {
        this.dirSep = sep;
    }

    public boolean isReference() {
        return this.refid != null;
    }

    public void execute() throws BuildException {
        Path savedPath = this.path;
        String savedPathSep = this.pathSep;
        String savedDirSep = this.dirSep;
        try {
            if (this.isReference()) {
                this.path = new Path(this.getProject()).createPath();
                Object obj = this.refid.getReferencedObject(this.getProject());
                if (obj instanceof Path) {
                    this.path.setRefid(this.refid);
                } else if (obj instanceof FileSet) {
                    FileSet fs = (FileSet)obj;
                    this.path.addFileset(fs);
                } else if (obj instanceof DirSet) {
                    DirSet ds = (DirSet)obj;
                    this.path.addDirset(ds);
                } else if (obj instanceof FileList) {
                    FileList fl = (FileList)obj;
                    this.path.addFilelist(fl);
                } else {
                    throw new BuildException("'refid' does not refer to a path, fileset, dirset, or filelist.");
                }
            }
            this.validateSetup();
            String fromDirSep = this.onWindows ? "\\" : "/";
            StringBuffer rslt = new StringBuffer(100);
            String[] elems = this.path.list();
            int i = 0;
            while (i < elems.length) {
                String elem = elems[i];
                elem = this.mapElement(elem);
                if (i != 0) {
                    rslt.append(this.pathSep);
                }
                StringTokenizer stDirectory = new StringTokenizer(elem, fromDirSep, true);
                String token = null;
                while (stDirectory.hasMoreTokens()) {
                    token = stDirectory.nextToken();
                    if (fromDirSep.equals(token)) {
                        rslt.append(this.dirSep);
                        continue;
                    }
                    rslt.append(token);
                }
                ++i;
            }
            String value = rslt.toString();
            if (this.setonempty) {
                this.log("Set property " + this.property + " = " + value, 3);
                this.getProject().setNewProperty(this.property, value);
            } else if (rslt.length() > 0) {
                this.log("Set property " + this.property + " = " + value, 3);
                this.getProject().setNewProperty(this.property, value);
            }
            Object var12_11 = null;
            this.path = savedPath;
            this.dirSep = savedDirSep;
            this.pathSep = savedPathSep;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.path = savedPath;
            this.dirSep = savedDirSep;
            this.pathSep = savedPathSep;
            throw throwable;
        }
    }

    private String mapElement(String elem) {
        int size = this.prefixMap.size();
        if (size != 0) {
            int i = 0;
            while (i < size) {
                MapEntry entry = (MapEntry)this.prefixMap.elementAt(i);
                String newElem = entry.apply(elem);
                if (newElem != elem) {
                    elem = newElem;
                    break;
                }
                ++i;
            }
        }
        return elem;
    }

    private void validateSetup() throws BuildException {
        if (this.path == null) {
            throw new BuildException("You must specify a path to convert");
        }
        if (this.property == null) {
            throw new BuildException("You must specify a property");
        }
        if (this.targetOS == null && this.pathSep == null && this.dirSep == null) {
            throw new BuildException("You must specify at least one of targetOS, dirSep, or pathSep");
        }
        String dsep = File.separator;
        String psep = File.pathSeparator;
        if (this.targetOS != null) {
            psep = this.targetWindows ? ";" : ":";
            String string = dsep = this.targetWindows ? "\\" : "/";
        }
        if (this.pathSep != null) {
            psep = this.pathSep;
        }
        if (this.dirSep != null) {
            dsep = this.dirSep;
        }
        this.pathSep = psep;
        this.dirSep = dsep;
    }

    private BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested <path> elements when using the refid attribute.");
    }

    public static class TargetOs
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"windows", "unix", "netware", "os/2", "tandem"};
        }
    }

    public class MapEntry {
        private String from = null;
        private String to = null;

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String apply(String elem) {
            String cmpFrom;
            if (this.from == null || this.to == null) {
                throw new BuildException("Both 'from' and 'to' must be set in a map entry");
            }
            String cmpElem = PathConvert.this.onWindows ? elem.toLowerCase() : elem;
            String string = cmpFrom = PathConvert.this.onWindows ? this.from.toLowerCase() : this.from;
            if (cmpElem.startsWith(cmpFrom)) {
                int len = this.from.length();
                elem = len >= elem.length() ? this.to : this.to + elem.substring(len);
            }
            return elem;
        }
    }
}

