/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogParser;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogWriter;
import org.apache.tools.ant.taskdefs.cvslib.CvsUser;
import org.apache.tools.ant.taskdefs.cvslib.RedirectingStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class ChangeLogTask
extends Task {
    private File m_usersFile;
    private Vector m_cvsUsers = new Vector();
    private File m_dir;
    private File m_destfile;
    private Date m_start;
    private Date m_stop;
    private final Vector m_filesets = new Vector();

    public void setDir(File dir) {
        this.m_dir = dir;
    }

    public void setDestfile(File destfile) {
        this.m_destfile = destfile;
    }

    public void setUsersfile(File usersFile) {
        this.m_usersFile = usersFile;
    }

    public void addUser(CvsUser user) {
        this.m_cvsUsers.addElement(user);
    }

    public void setStart(Date start) {
        this.m_start = start;
    }

    public void setEnd(Date stop) {
        this.m_stop = stop;
    }

    public void setDaysinpast(int days) {
        long time = System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L;
        this.setStart(new Date(time));
    }

    public void addFileset(FileSet fileSet) {
        this.m_filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        File savedDir = this.m_dir;
        try {
            this.validate();
            Properties userList = new Properties();
            this.loadUserlist(userList);
            Enumeration e = this.m_cvsUsers.elements();
            while (e.hasMoreElements()) {
                CvsUser user = (CvsUser)e.nextElement();
                user.validate();
                ((Hashtable)userList).put(user.getUserID(), user.getDisplayname());
            }
            Commandline command = new Commandline();
            command.setExecutable("cvs");
            command.createArgument().setValue("log");
            if (null != this.m_start) {
                SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
                String dateRange = ">=" + outputDate.format(this.m_start);
                command.createArgument().setValue("-d");
                command.createArgument().setValue(dateRange);
            }
            if (!this.m_filesets.isEmpty()) {
                Enumeration e2 = this.m_filesets.elements();
                while (e2.hasMoreElements()) {
                    FileSet fileSet = (FileSet)e2.nextElement();
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                    String[] files = scanner.getIncludedFiles();
                    int i = 0;
                    while (i < files.length) {
                        command.createArgument().setValue(files[i]);
                        ++i;
                    }
                }
            }
            ChangeLogParser parser = new ChangeLogParser();
            RedirectingStreamHandler handler = new RedirectingStreamHandler(parser);
            this.log(command.describeCommand(), 3);
            Execute exe = new Execute(handler);
            exe.setWorkingDirectory(this.m_dir);
            exe.setCommandline(command.getCommandline());
            exe.setAntRun(this.getProject());
            try {
                int resultCode = exe.execute();
                if (Execute.isFailure(resultCode)) {
                    throw new BuildException("Error running cvs log");
                }
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString());
            }
            String errors = handler.getErrors();
            if (null != errors) {
                this.log(errors, 0);
            }
            CVSEntry[] entrySet = parser.getEntrySetAsArray();
            CVSEntry[] filteredEntrySet = this.filterEntrySet(entrySet);
            this.replaceAuthorIdWithName(userList, filteredEntrySet);
            this.writeChangeLog(filteredEntrySet);
            Object var12_15 = null;
            this.m_dir = savedDir;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.m_dir = savedDir;
            throw throwable;
        }
    }

    private void validate() throws BuildException {
        if (null == this.m_dir) {
            this.m_dir = this.getProject().getBaseDir();
        }
        if (null == this.m_destfile) {
            String message = "Destfile must be set.";
            throw new BuildException("Destfile must be set.");
        }
        if (!this.m_dir.exists()) {
            String message = "Cannot find base dir " + this.m_dir.getAbsolutePath();
            throw new BuildException(message);
        }
        if (null != this.m_usersFile && !this.m_usersFile.exists()) {
            String message = "Cannot find user lookup list " + this.m_usersFile.getAbsolutePath();
            throw new BuildException(message);
        }
    }

    private void loadUserlist(Properties userList) throws BuildException {
        if (null != this.m_usersFile) {
            try {
                userList.load(new FileInputStream(this.m_usersFile));
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
    }

    private CVSEntry[] filterEntrySet(CVSEntry[] entrySet) {
        Vector<CVSEntry> results = new Vector<CVSEntry>();
        int i = 0;
        while (i < entrySet.length) {
            CVSEntry cvsEntry = entrySet[i];
            Date date = cvsEntry.getDate();
            if (!(null != this.m_start && this.m_start.after(date) || null != this.m_stop && this.m_stop.before(date))) {
                results.addElement(cvsEntry);
            }
            ++i;
        }
        Object[] resultArray = new CVSEntry[results.size()];
        results.copyInto(resultArray);
        return resultArray;
    }

    private void replaceAuthorIdWithName(Properties userList, CVSEntry[] entrySet) {
        int i = 0;
        while (i < entrySet.length) {
            CVSEntry entry = entrySet[i];
            if (((Hashtable)userList).containsKey(entry.getAuthor())) {
                entry.setAuthor(userList.getProperty(entry.getAuthor()));
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeChangeLog(CVSEntry[] entrySet) throws BuildException {
        FileOutputStream output = null;
        output = new FileOutputStream(this.m_destfile);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
        ChangeLogWriter serializer = new ChangeLogWriter();
        serializer.printChangeLog(writer, entrySet);
        Object var6_7 = null;
        if (null == output) return;
        try {
            output.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (UnsupportedEncodingException uee) {
                this.getProject().log(uee.toString(), 0);
                Object var6_8 = null;
                if (null == output) return;
                try {
                    output.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (null == output) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

