/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.taskdefs.cvslib.CvsTagEntry;
import org.apache.tools.ant.util.FileUtils;

public class CvsTagDiff
extends AbstractCvsTask {
    static final String FILE_STRING = "File ";
    static final String TO_STRING = " to ";
    static final String FILE_IS_NEW = " is new;";
    static final String REVISION = "revision ";
    static final String FILE_HAS_CHANGED = " changed from revision ";
    static final String FILE_WAS_REMOVED = " is removed";
    private String mypackage;
    private String mystartTag;
    private String myendTag;
    private String mystartDate;
    private String myendDate;
    private File mydestfile;
    private FileUtils myfileUtils = FileUtils.newFileUtils();

    public void setPackage(String p) {
        this.mypackage = p;
    }

    public void setStartTag(String s) {
        this.mystartTag = s;
    }

    public void setStartDate(String s) {
        this.mystartDate = s;
    }

    public void setEndTag(String s) {
        this.myendTag = s;
    }

    public void setEndDate(String s) {
        this.myendDate = s;
    }

    public void setDestFile(File f) {
        this.mydestfile = f;
    }

    public void execute() throws BuildException {
        block8: {
            this.validate();
            this.addCommandArgument("rdiff");
            this.addCommandArgument("-s");
            if (this.mystartTag != null) {
                this.addCommandArgument("-r");
                this.addCommandArgument(this.mystartTag);
            } else {
                this.addCommandArgument("-D");
                this.addCommandArgument(this.mystartDate);
            }
            if (this.myendTag != null) {
                this.addCommandArgument("-r");
                this.addCommandArgument(this.myendTag);
            } else {
                this.addCommandArgument("-D");
                this.addCommandArgument(this.myendDate);
            }
            StringTokenizer myTokenizer = new StringTokenizer(this.mypackage);
            while (myTokenizer.hasMoreTokens()) {
                this.addCommandArgument(myTokenizer.nextToken());
            }
            this.setCommand("");
            File tmpFile = null;
            try {
                tmpFile = this.myfileUtils.createTempFile("cvstagdiff", ".log", null);
                tmpFile.deleteOnExit();
                this.setOutput(tmpFile);
                super.execute();
                CvsTagEntry[] entries = this.parseRDiff(tmpFile);
                this.writeTagDiff(entries);
                Object var5_4 = null;
                if (tmpFile == null) break block8;
                tmpFile.delete();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CvsTagEntry[] parseRDiff(File tmpFile) throws BuildException {
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(tmpFile));
                String toBeRemoved = FILE_STRING + this.mypackage + "/";
                int headerLength = toBeRemoved.length();
                Vector<CvsTagEntry> entries = new Vector<CvsTagEntry>();
                String line = reader.readLine();
                CvsTagEntry entry = null;
                while (true) {
                    if (null == line) break;
                    if (line.length() > headerLength) {
                        String filename;
                        int index = (line = line.startsWith(toBeRemoved) ? line.substring(headerLength) : line.substring(FILE_STRING.length())).indexOf(FILE_IS_NEW);
                        if (index != -1) {
                            filename = line.substring(0, index);
                            String rev = null;
                            int indexrev = -1;
                            indexrev = line.indexOf(REVISION, index);
                            if (indexrev != -1) {
                                rev = line.substring(indexrev + REVISION.length());
                            }
                            entry = new CvsTagEntry(filename, rev);
                            entries.addElement(entry);
                            this.log(entry.toString(), 3);
                        } else {
                            index = line.indexOf(FILE_HAS_CHANGED);
                            if (index != -1) {
                                filename = line.substring(0, index);
                                int revSeparator = line.indexOf(TO_STRING, index);
                                String prevRevision = line.substring(index + FILE_HAS_CHANGED.length(), revSeparator);
                                String revision = line.substring(revSeparator + TO_STRING.length());
                                entry = new CvsTagEntry(filename, revision, prevRevision);
                                entries.addElement(entry);
                                this.log(entry.toString(), 3);
                            } else {
                                index = line.indexOf(FILE_WAS_REMOVED);
                                if (index != -1) {
                                    filename = line.substring(0, index);
                                    String rev = null;
                                    int indexrev = -1;
                                    indexrev = line.indexOf(REVISION, index);
                                    if (indexrev != -1) {
                                        rev = line.substring(indexrev + REVISION.length());
                                    }
                                    entry = new CvsTagEntry(filename, null, rev);
                                    entries.addElement(entry);
                                    this.log(entry.toString(), 3);
                                }
                            }
                        }
                    }
                    line = reader.readLine();
                }
                Object[] array = new CvsTagEntry[entries.size()];
                entries.copyInto(array);
                Object[] objectArray = array;
                Object var14_19 = null;
                if (reader == null) return objectArray;
                try {
                    reader.close();
                    return objectArray;
                }
                catch (IOException e) {
                    this.log(e.toString(), 0);
                }
                return objectArray;
            }
            catch (IOException e) {
                throw new BuildException("Error in parsing", e);
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (reader == null) throw throwable;
            try {}
            catch (IOException e) {
                this.log(e.toString(), 0);
                throw throwable;
            }
            reader.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeTagDiff(CvsTagEntry[] entries) throws BuildException {
        FileOutputStream output = null;
        output = new FileOutputStream(this.mydestfile);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<tagdiff ");
        if (this.mystartTag != null) {
            writer.print("startTag=\"" + this.mystartTag + "\" ");
        } else {
            writer.print("startDate=\"" + this.mystartDate + "\" ");
        }
        if (this.myendTag != null) {
            writer.print("endTag=\"" + this.myendTag + "\" ");
        } else {
            writer.print("endDate=\"" + this.myendDate + "\" ");
        }
        writer.print("cvsroot=\"" + this.getCvsRoot() + "\" ");
        writer.print("package=\"" + this.mypackage + "\" ");
        writer.println(">");
        int i = 0;
        int c = entries.length;
        while (i < c) {
            this.writeTagEntry(writer, entries[i]);
            ++i;
        }
        writer.println("</tagdiff>");
        writer.flush();
        writer.close();
        Object var7_8 = null;
        if (null == output) return;
        try {
            output.close();
            return;
        }
        catch (IOException ioe) {
            this.log(ioe.toString(), 0);
        }
        return;
        {
            catch (UnsupportedEncodingException uee) {
                this.log(uee.toString(), 0);
                Object var7_9 = null;
                if (null == output) return;
                try {
                    output.close();
                    return;
                }
                catch (IOException ioe) {
                    this.log(ioe.toString(), 0);
                }
                return;
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (null == output) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException ioe) {
                this.log(ioe.toString(), 0);
            }
            throw throwable;
        }
    }

    private void writeTagEntry(PrintWriter writer, CvsTagEntry entry) {
        writer.println("\t<entry>");
        writer.println("\t\t<file>");
        writer.println("\t\t\t<name>" + entry.getFile() + "</name>");
        if (entry.getRevision() != null) {
            writer.println("\t\t\t<revision>" + entry.getRevision() + "</revision>");
        }
        if (entry.getPreviousRevision() != null) {
            writer.println("\t\t\t<prevrevision>" + entry.getPreviousRevision() + "</prevrevision>");
        }
        writer.println("\t\t</file>");
        writer.println("\t</entry>");
    }

    private void validate() throws BuildException {
        if (null == this.mypackage) {
            throw new BuildException("Package/module must be set.");
        }
        if (null == this.mydestfile) {
            throw new BuildException("Destfile must be set.");
        }
        if (null == this.mystartTag && null == this.mystartDate) {
            throw new BuildException("Start tag or start date must be set.");
        }
        if (null != this.mystartTag && null != this.mystartDate) {
            throw new BuildException("Only one of start tag and start date must be set.");
        }
        if (null == this.myendTag && null == this.myendDate) {
            throw new BuildException("End tag or end date must be set.");
        }
        if (null != this.myendTag && null != this.myendDate) {
            throw new BuildException("Only one of end tag and end date must be set.");
        }
    }
}

