/*
 * Decompiled with CFR 0.152.
 */
package com.jnbridge.org.apache.bcel.classfile;

import com.jnbridge.org.apache.bcel.classfile.Attribute;
import com.jnbridge.org.apache.bcel.classfile.ConstantPool;
import com.jnbridge.org.apache.bcel.classfile.ParameterAnnotation;
import com.jnbridge.org.apache.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class RuntimeVisibleParameterAnnotations
extends Attribute {
    private int num_parameters;
    private ParameterAnnotation[] parameter_annotations;

    public RuntimeVisibleParameterAnnotations(RuntimeVisibleParameterAnnotations e) {
        this(e.getNameIndex(), e.getLength(), e.getNumParameters(), e.getParameterAnnotations(), e.getConstantPool());
    }

    public RuntimeVisibleParameterAnnotations(int name_index, int length, int num_parameters, ParameterAnnotation[] parameter_annotations, ConstantPool constant_pool) {
        super((byte)16, name_index, length, constant_pool);
        this.setNumParameters(num_parameters);
        this.setParameterAnnotations(parameter_annotations);
    }

    RuntimeVisibleParameterAnnotations(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, -1, null, constant_pool);
        this.num_parameters = file.readUnsignedShort();
        this.parameter_annotations = new ParameterAnnotation[this.num_parameters];
        int i = 0;
        while (i < this.num_parameters) {
            this.parameter_annotations[i] = new ParameterAnnotation(file, constant_pool);
            ++i;
        }
    }

    public void accept(Visitor v) {
        v.visitRuntimeVisibleParameterAnnotations(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.num_parameters);
        int i = 0;
        while (i < this.num_parameters) {
            this.parameter_annotations[i].dump(file);
            ++i;
        }
    }

    public final int getNumParameters() {
        return this.num_parameters;
    }

    public final void setNumParameters(int num_parameters) {
        this.num_parameters = num_parameters;
    }

    public final ParameterAnnotation[] getParameterAnnotations() {
        return this.parameter_annotations;
    }

    public final void setParameterAnnotations(ParameterAnnotation[] parameter_annotations) {
        this.parameter_annotations = parameter_annotations;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RuntimeVisibleParameterAnnotations: num_annotations = " + this.num_parameters + "\n");
        int i = 0;
        while (i < this.num_parameters) {
            buf.append("RuntimeVisibleParameterAnnotations: annotations[" + i + "] = " + this.parameter_annotations[i] + "\n");
            ++i;
        }
        return buf.toString();
    }

    public Attribute copy(ConstantPool constant_pool) {
        RuntimeVisibleParameterAnnotations c = (RuntimeVisibleParameterAnnotations)this.clone();
        c.num_parameters = this.num_parameters;
        c.parameter_annotations = new ParameterAnnotation[this.num_parameters];
        int i = 0;
        while (i < this.num_parameters) {
            c.parameter_annotations[i] = this.parameter_annotations[i].copy();
            ++i;
        }
        c.constant_pool = constant_pool;
        return c;
    }
}

