/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.Visitor;

public final class AnnotationDefault
extends Attribute {
    private ElementValue default_value;

    public AnnotationDefault(AnnotationDefault e) {
        this(e.getNameIndex(), e.getLength(), e.getDefaultValue(), e.getConstantPool());
    }

    public AnnotationDefault(int name_index, int length, ElementValue default_value, ConstantPool constant_pool) {
        super((byte)18, name_index, length, constant_pool);
        this.setDefaultValue(default_value);
    }

    AnnotationDefault(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (ElementValue)null, constant_pool);
        this.default_value = new ElementValue(file, constant_pool);
    }

    public void accept(Visitor v) {
        v.visitAnnotationDefault(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        this.default_value.dump(file);
    }

    public final ElementValue getDefaultValue() {
        return this.default_value;
    }

    public final void setDefaultValue(ElementValue default_value) {
        this.default_value = default_value;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("default_value = " + this.default_value + "\n");
        return buf.toString();
    }

    public Attribute copy(ConstantPool constant_pool) {
        AnnotationDefault c = (AnnotationDefault)this.clone();
        c.default_value = this.default_value.copy();
        c.constant_pool = constant_pool;
        return c;
    }
}

