/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public final class ElementValuePair
implements Constants,
Cloneable,
Node,
Serializable {
    private int element_name_index;
    private ElementValue value;
    private ConstantPool constant_pool;

    public ElementValuePair(ElementValuePair c) {
        this(c.getElementNameIndex(), c.getValue(), c.getConstantPool());
    }

    ElementValuePair(DataInputStream file, ConstantPool constant_pool) throws IOException {
        this.element_name_index = file.readUnsignedShort();
        this.value = new ElementValue(file, constant_pool);
    }

    public ElementValuePair(int element_name_index, ElementValue value, ConstantPool constant_pool) {
        this.element_name_index = element_name_index;
        this.value = value;
        this.constant_pool = constant_pool;
    }

    public void accept(Visitor v) {
        v.visitElementValuePair(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.element_name_index);
        this.value.dump(file);
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final int getElementNameIndex() {
        return this.element_name_index;
    }

    public final ElementValue getValue() {
        return this.value;
    }

    public final void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final void setElementNameIndex(int element_name_index) {
        this.element_name_index = element_name_index;
    }

    public final void setValue(ElementValue value) {
        this.value = value;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ElementValuePair: element_name_index = " + this.element_name_index + "\n");
        buf.append("ElementValuePair: value = " + this.value + "\n");
        return buf.toString();
    }

    public ElementValuePair copy(ConstantPool constant_pool) {
        try {
            ElementValuePair c = (ElementValuePair)this.clone();
            c.element_name_index = this.element_name_index;
            c.value = this.value.copy();
            c.constant_pool = constant_pool;
            return c;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

