/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class EnclosingMethod
extends Attribute {
    private int class_index;
    private int method_index;

    public EnclosingMethod(EnclosingMethod e) {
        this(e.getNameIndex(), e.getLength(), e.getClassIndex(), e.getMethodIndex(), e.getConstantPool());
    }

    public EnclosingMethod(int name_index, int length, int class_index, int method_index, ConstantPool constant_pool) {
        super((byte)12, name_index, length, constant_pool);
        this.setClassIndex(class_index);
        this.setMethodIndex(method_index);
    }

    EnclosingMethod(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, -1, -1, constant_pool);
        this.class_index = file.readUnsignedShort();
        this.method_index = file.readUnsignedShort();
    }

    public void accept(Visitor v) {
        v.visitEnclosingMethod(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.class_index);
        file.writeShort(this.method_index);
    }

    public final int getClassIndex() {
        return this.class_index;
    }

    public final void setClassIndex(int class_index) {
        this.class_index = class_index;
    }

    public final int getMethodIndex() {
        return this.method_index;
    }

    public final void setMethodIndex(int method_index) {
        this.method_index = method_index;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("class_index = " + this.class_index + "\n");
        buf.append("method_index = " + this.method_index + "\n");
        return buf.toString();
    }

    public Attribute copy(ConstantPool constant_pool) {
        EnclosingMethod c = (EnclosingMethod)this.clone();
        c.class_index = this.class_index;
        c.method_index = this.method_index;
        c.constant_pool = constant_pool;
        return c;
    }
}

