/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariableType;
import org.apache.bcel.classfile.Visitor;

public class LocalVariableTypeTable
extends Attribute {
    private int local_variable_type_table_length;
    private LocalVariableType[] local_variable_type_table;

    public LocalVariableTypeTable(LocalVariableTypeTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTypeTable(), c.getConstantPool());
    }

    public LocalVariableTypeTable(int name_index, int length, LocalVariableType[] local_variable_type_table, ConstantPool constant_pool) {
        super((byte)13, name_index, length, constant_pool);
        this.setLocalVariableTypeTable(local_variable_type_table);
    }

    LocalVariableTypeTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LocalVariableType[])null, constant_pool);
        this.local_variable_type_table_length = file.readUnsignedShort();
        this.local_variable_type_table = new LocalVariableType[this.local_variable_type_table_length];
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            this.local_variable_type_table[i] = new LocalVariableType(file, constant_pool);
            ++i;
        }
    }

    public void accept(Visitor v) {
        v.visitLocalVariableTypeTable(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.local_variable_type_table_length);
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            this.local_variable_type_table[i].dump(file);
            ++i;
        }
    }

    public final LocalVariableType[] getLocalVariableTypeTable() {
        return this.local_variable_type_table;
    }

    public final LocalVariableType getLocalVariableType(int index) {
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            if (this.local_variable_type_table[i].getIndex() == index) {
                return this.local_variable_type_table[i];
            }
            ++i;
        }
        return null;
    }

    public final void setLocalVariableTypeTable(LocalVariableType[] local_variable_type_table) {
        this.local_variable_type_table = local_variable_type_table;
        this.local_variable_type_table_length = local_variable_type_table == null ? 0 : local_variable_type_table.length;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer("");
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            buf.append(this.local_variable_type_table[i].toString());
            if (i < this.local_variable_type_table_length - 1) {
                buf.append('\n');
            }
            ++i;
        }
        return buf.toString();
    }

    public Attribute copy(ConstantPool constant_pool) {
        LocalVariableTypeTable c = (LocalVariableTypeTable)this.clone();
        c.local_variable_type_table = new LocalVariableType[this.local_variable_type_table_length];
        int i = 0;
        while (i < this.local_variable_type_table_length) {
            c.local_variable_type_table[i] = this.local_variable_type_table[i].copy();
            ++i;
        }
        c.constant_pool = constant_pool;
        return c;
    }

    public final int getTableLength() {
        return this.local_variable_type_table_length;
    }
}

