/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Annotation;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class RuntimeVisibleAnnotations
extends Attribute {
    private int num_annotations;
    private Annotation[] annotations;

    public RuntimeVisibleAnnotations(RuntimeVisibleAnnotations e) {
        this(e.getNameIndex(), e.getLength(), e.getNumAnnotations(), e.getAnnotations(), e.getConstantPool());
    }

    public RuntimeVisibleAnnotations(int name_index, int length, int num_annotations, Annotation[] annotations, ConstantPool constant_pool) {
        super((byte)14, name_index, length, constant_pool);
        this.setNumAnnotations(num_annotations);
        this.setAnnotations(annotations);
    }

    RuntimeVisibleAnnotations(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, -1, null, constant_pool);
        this.num_annotations = file.readUnsignedShort();
        this.annotations = new Annotation[this.num_annotations];
        int i = 0;
        while (i < this.num_annotations) {
            this.annotations[i] = new Annotation(file, constant_pool);
            ++i;
        }
    }

    public void accept(Visitor v) {
        v.visitRuntimeVisibleAnnotations(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.num_annotations);
        int i = 0;
        while (i < this.num_annotations) {
            this.annotations[i].dump(file);
            ++i;
        }
    }

    public final int getNumAnnotations() {
        return this.num_annotations;
    }

    public final void setNumAnnotations(int num_annotations) {
        this.num_annotations = num_annotations;
    }

    public final Annotation[] getAnnotations() {
        return this.annotations;
    }

    public final void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("num_annotations = " + this.num_annotations + "\n");
        int i = 0;
        while (i < this.num_annotations) {
            buf.append("annotations[" + i + "] = " + this.annotations[i] + "\n");
            ++i;
        }
        return buf.toString();
    }

    public Attribute copy(ConstantPool constant_pool) {
        RuntimeVisibleAnnotations c = (RuntimeVisibleAnnotations)this.clone();
        c.num_annotations = this.num_annotations;
        c.annotations = new Annotation[this.num_annotations];
        int i = 0;
        while (i < this.num_annotations) {
            c.annotations[i] = this.annotations[i].copy();
            ++i;
        }
        c.constant_pool = constant_pool;
        return c;
    }
}

