/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Service;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIInterface;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.POPGenerationInfo;
import com.rsa.certj.spi.pki.POPValidationInfo;
import com.rsa.certj.spi.pki.ProtectInfo;
import com.rsa.jsafe.JSAFE_PrivateKey;

public final class PKIService
extends Service {
    public PKIService(CertJ certJ) {
        super(certJ);
    }

    public PKIResponseMessage readCertificationResponseMessage(byte[] response, ProtectInfo protectInfo) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pki = this.getProvider();
        if (response == null) {
            throw new InvalidParameterException("PKIService.readCertificationResponseMessage: response cannot be null.");
        }
        try {
            return pki.readCertificationResponseMessage(response, protectInfo);
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("PKIService.readCertificationResponseMessage: Does not support this service.");
        }
    }

    public byte[] writeCertificationRequestMessage(PKIRequestMessage request, ProtectInfo protectInfo) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pki = this.getProvider();
        if (request == null) {
            throw new InvalidParameterException("PKIService.writeCertificationRequestMessage: request cannot be null.");
        }
        try {
            return pki.writeCertificationRequestMessage(request, protectInfo);
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("PKIService.writeCertificationRequestMessage: Does not support this service.");
        }
    }

    public PKIResponseMessage requestCertification(PKIRequestMessage request, ProtectInfo protectInfo, DatabaseService db) throws InvalidParameterException, NoServiceException, PKIException {
        return this.sendRequest(request, protectInfo, db);
    }

    public PKIResponseMessage sendRequest(PKIRequestMessage request, ProtectInfo protectInfo, DatabaseService db) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pki = this.getProvider();
        if (request == null) {
            throw new InvalidParameterException("PKIService.sendRequest: request cannot be null.");
        }
        try {
            return pki.sendRequest(request, protectInfo, db);
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("PKIService.sendRequest: does not support this service.");
        }
    }

    public PKIResult sendMessage(byte[] request) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pki = this.getProvider();
        if (request == null) {
            throw new InvalidParameterException("PKIService.sendMessage: request cannot be null.");
        }
        try {
            return pki.sendMessage(request);
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("PKIService.sendMessage: Does not support this service.");
        }
    }

    public void generateProofOfPossession(PKIRequestMessage request, JSAFE_PrivateKey privateKey, POPGenerationInfo popGenerationInfo) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pki = this.getProvider();
        if (request == null) {
            throw new InvalidParameterException("PKIService.generateProofOfPossession: request cannot be null.");
        }
        try {
            pki.generateProofOfPossession(request, privateKey, popGenerationInfo);
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("PKIService.generateProofOfPossession: Does not support this service.");
        }
    }

    public boolean validateProofOfPossession(PKIMessage message, POPValidationInfo popValidationInfo) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pki = this.getProvider();
        if (message == null) {
            throw new InvalidParameterException("PKIService.validateProofOfPossession: message cannot be null.");
        }
        try {
            return pki.validateProofOfPossession(message, popValidationInfo);
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("PKIService.validateProofOfPossession: Does not support this service.");
        }
    }

    public void provideProofOfPossession(PKIRequestMessage request, int popType, byte[] pop) throws InvalidParameterException, NoServiceException, PKIException {
        PKIInterface pki = this.getProvider();
        if (request == null) {
            throw new InvalidParameterException("PKIService.provideProofOfPossession: request cannot be null.");
        }
        try {
            pki.provideProofOfPossession(request, popType, pop);
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("PKIService.provideProofOfPossession: Does not support this service.");
        }
    }

    private PKIInterface getProvider() throws NoServiceException {
        if (this.getProviderCount() == 0) {
            throw new NoServiceException("PKIService.getProvider: no PKI provider bound to this object.");
        }
        return (PKIInterface)((Object)this.getProviderAt(0));
    }
}

