/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.PKIService;
import com.rsa.certj.ProviderImplementation;
import java.util.Vector;

public class Service {
    private Vector<ProviderImplementation> providers = new Vector();

    public static Service getInstance(CertJ certJ, int type) {
        switch (type) {
            case 0: 
            case 2: 
            case 3: {
                return new Service(certJ);
            }
            case 4: {
                return new PKIService(certJ);
            }
            case 1: {
                return new DatabaseService(certJ);
            }
        }
        return new Service(certJ);
    }

    protected Service(CertJ certJ) {
    }

    public String[] listProviderNames() {
        int count = this.providers.size();
        String[] names = new String[count];
        int i = 0;
        for (ProviderImplementation provider : this.providers) {
            names[i++] = provider.getName();
        }
        return names;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().toString());
        buffer.append('[');
        boolean first = true;
        for (ProviderImplementation provider : this.providers) {
            if (!first) {
                buffer.append(',');
            } else {
                first = false;
            }
            buffer.append(provider.getName());
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void unbind() {
    }

    protected int getProviderCount() {
        return this.providers.size();
    }

    protected ProviderImplementation getProviderAt(int index) {
        if (index < 0 || index >= this.providers.size()) {
            return null;
        }
        return this.providers.elementAt(index);
    }

    protected void addProvider(ProviderImplementation implementor) {
        this.providers.addElement(implementor);
    }
}

