/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.cert.AlternativeAttributeName;
import com.rsa.certj.cert.NameAttributeID;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.NameMatcher;
import com.rsa.certj.internal.ConvertUtil;
import com.rsa.jsafe.CryptoJ;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class AttributeValueAssertion
implements Cloneable,
Serializable {
    public static final int UNKNOWN_ATTRIBUTE_TYPE = -1;
    public static final int BOUND_UNLIMITED = -1;
    public static final int UNSUPPORTED_ASN1_TYPE = -1;
    public static final int COMMON_NAME = 0;
    public static final byte[] COMMON_NAME_OID = new byte[]{85, 4, 3};
    public static final int UB_COMMON_NAME = 64;
    private static final int UB_INTERNAL = 500;
    public static final int COUNTRY_NAME = 1;
    public static final byte[] COUNTRY_NAME_OID = new byte[]{85, 4, 6};
    public static final int COUNTRY_NAME_LENGTH = 2;
    public static final int LOCALITY_NAME = 2;
    public static final byte[] LOCALITY_NAME_OID = new byte[]{85, 4, 7};
    public static final int UB_LOCALITY_NAME = 128;
    public static final int STATE_NAME = 3;
    public static final byte[] STATE_NAME_OID = new byte[]{85, 4, 8};
    public static final int UB_STATE_NAME = 128;
    public static final int ORGANIZATION_NAME = 4;
    public static final byte[] ORGANIZATION_NAME_OID = new byte[]{85, 4, 10};
    public static final int UB_ORGANIZATION_NAME = 64;
    public static final int ORGANIZATIONAL_UNIT_NAME = 5;
    public static final byte[] ORGANIZATIONAL_UNIT_NAME_OID = new byte[]{85, 4, 11};
    public static final int UB_ORGANIZATIONAL_UNIT_NAME = 128;
    public static final int TELEPHONE_NUMBER = 6;
    public static final byte[] TELEPHONE_NUMBER_OID = new byte[]{85, 4, 20};
    public static final int UB_TELEPHONE_NUMBER = 32;
    public static final int EMAIL_ADDRESS = 7;
    public static final byte[] EMAIL_ADDRESS_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 1};
    public static final int UB_EMAIL_ADDRESS = 64;
    public static final int TITLE = 8;
    public static final byte[] TITLE_OID = new byte[]{85, 4, 12};
    public static final int UB_TITLE = 64;
    public static final int STREET_ADDRESS = 9;
    public static final byte[] STREET_ADDRESS_OID = new byte[]{85, 4, 9};
    public static final int UB_STREET_ADDRESS = 128;
    public static final int BUSINESS_CATEGORY = 10;
    public static final byte[] BUSINESS_CATEGORY_OID = new byte[]{85, 4, 15};
    public static final int UB_BUSINESS_CATEGORY = 128;
    public static final int POSTAL_CODE = 11;
    public static final byte[] POSTAL_CODE_OID = new byte[]{85, 4, 17};
    public static final int UB_POSTAL_CODE = 40;
    public static final int SURNAME = 12;
    public static final byte[] SURNAME_OID = new byte[]{85, 4, 4};
    public static final int UB_SURNAME = 32768;
    public static final int GIVEN_NAME = 13;
    public static final byte[] GIVEN_NAME_OID = new byte[]{85, 4, 42};
    public static final int UB_GIVEN_NAME = 32768;
    public static final int SERIAL_NUMBER = 14;
    public static final byte[] SERIAL_NUMBER_OID = new byte[]{85, 4, 5};
    public static final int UB_SERIAL_NUMBER = 64;
    public static final int INITIALS = 15;
    public static final byte[] INITIALS_OID = new byte[]{85, 4, 43};
    public static final int UB_INITIALS = 32768;
    public static final int GENERATION_QUALIFIER = 16;
    public static final byte[] GENERATION_QUALIFIER_OID = new byte[]{85, 4, 44};
    public static final int UB_GENERATION_QUALIFIER = 32768;
    public static final int NAME = 17;
    public static final byte[] NAME_OID = new byte[]{85, 4, 41};
    public static final int UB_NAME = 32768;
    public static final int DN_QUALIFIER = 18;
    public static final byte[] DN_QUALIFIER_OID = new byte[]{85, 4, 46};
    public static final int UB_DN_QUALIFIER = -1;
    public static final int DOMAIN_COMPONENT = 19;
    public static final byte[] DOMAIN_COMPONENT_OID = new byte[]{9, -110, 38, -119, -109, -14, 44, 100, 1, 25};
    public static final int UB_DOMAIN_COMPONENT = 64;
    public static final int POSTAL_ADDRESS = 20;
    public static final byte[] POSTAL_ADDRESS_OID = new byte[]{85, 4, 16};
    public static final int UB_POSTAL_ADDRESS = -1;
    public static final int PSEUDONYM = 21;
    public static final byte[] PSEUDONYM_OID = new byte[]{85, 4, 65};
    public static final int UB_PSEUDONYM = -1;
    public static final int DATE_OF_BIRTH = 22;
    public static final byte[] DATE_OF_BIRTH_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 1};
    public static final int UB_DATE_OF_BIRTH = -1;
    public static final int PLACE_OF_BIRTH = 23;
    public static final byte[] PLACE_OF_BIRTH_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 2};
    public static final int UB_PLACE_OF_BIRTH = 32768;
    public static final int GENDER = 24;
    public static final byte[] GENDER_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 3};
    public static final int UB_GENDER = 1;
    public static final int COUNTRY_OF_CITIZENSHIP = 25;
    public static final byte[] COUNTRY_OF_CITIZENSHIP_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 4};
    public static final int UB_COUNTRY_OF_CITIZENSHIP = 2;
    public static final int COUNTRY_OF_RESIDENCE = 26;
    public static final byte[] COUNTRY_OF_RESIDENCE_OID = new byte[]{43, 6, 1, 5, 5, 7, 9, 5};
    public static final int UB_COUNTRY_OF_RESIDENCE = 2;
    public static final int JURIS_OF_INCORP_LOCALITY_NAME = 27;
    public static final byte[] JURIS_OF_INCORP_LOCALITY_NAME_OID = new byte[]{43, 6, 1, 4, 1, -126, 55, 60, 2, 1, 1};
    public static final int UB_JURIS_OF_INCORP_LOCALITY_NAME = 128;
    public static final int JURIS_OF_INCORP_STATE_NAME = 28;
    public static final byte[] JURIS_OF_INCORP_STATE_NAME_OID = new byte[]{43, 6, 1, 4, 1, -126, 55, 60, 2, 1, 2};
    public static final int UB_JURIS_OF_INCORP_STATE_NAME = 128;
    public static final int JURIS_OF_INCORP_COUNTRY_NAME = 29;
    public static final byte[] JURIS_OF_INCORP_COUNTRY_NAME_OID = new byte[]{43, 6, 1, 4, 1, -126, 55, 60, 2, 1, 3};
    public static final int UB_JURIS_OF_INCORP_COUNTRY_NAME = 128;
    public static final int USER_ID = 30;
    public static final byte[] USER_ID_OID = new byte[]{9, -110, 38, -119, -109, -14, 44, 100, 1, 1};
    public static final int UB_USER_ID = 128;
    protected static final NameAttributeID[] ALL_NAME_ATTRIBUTE_IDS = new NameAttributeID[]{new NameAttributeID(COMMON_NAME_OID, "CN"), new NameAttributeID(COUNTRY_NAME_OID, "C"), new NameAttributeID(LOCALITY_NAME_OID, "L"), new NameAttributeID(STATE_NAME_OID, "ST"), new NameAttributeID(ORGANIZATION_NAME_OID, "O"), new NameAttributeID(ORGANIZATIONAL_UNIT_NAME_OID, "OU"), new NameAttributeID(TELEPHONE_NUMBER_OID, "TEL"), new NameAttributeID(EMAIL_ADDRESS_OID, "E"), new NameAttributeID(TITLE_OID, "TITLE"), new NameAttributeID(STREET_ADDRESS_OID, "STREET"), new NameAttributeID(BUSINESS_CATEGORY_OID, "BC"), new NameAttributeID(POSTAL_CODE_OID, "postalCode"), new NameAttributeID(SURNAME_OID, "SN"), new NameAttributeID(GIVEN_NAME_OID, "givenName"), new NameAttributeID(SERIAL_NUMBER_OID, "serialNumber"), new NameAttributeID(INITIALS_OID, "initials"), new NameAttributeID(GENERATION_QUALIFIER_OID, "generationQualifier"), new NameAttributeID(NAME_OID, "name"), new NameAttributeID(DN_QUALIFIER_OID, "dnQualifier"), new NameAttributeID(DOMAIN_COMPONENT_OID, "dc"), new NameAttributeID(POSTAL_ADDRESS_OID, "postalAddress"), new NameAttributeID(PSEUDONYM_OID, "pseudonym"), new NameAttributeID(DATE_OF_BIRTH_OID, "dateOfBirth"), new NameAttributeID(PLACE_OF_BIRTH_OID, "placeOfBirth"), new NameAttributeID(GENDER_OID, "gender"), new NameAttributeID(COUNTRY_OF_CITIZENSHIP_OID, "citizenship"), new NameAttributeID(COUNTRY_OF_RESIDENCE_OID, "residence"), new NameAttributeID(JURIS_OF_INCORP_LOCALITY_NAME_OID, "jurusdictionOfIncorporationLocalityName"), new NameAttributeID(JURIS_OF_INCORP_STATE_NAME_OID, "jurusdictionOfIncorporationStateOrProvinceName"), new NameAttributeID(JURIS_OF_INCORP_COUNTRY_NAME_OID, "jurusdictionOfIncorporationCountryName"), new NameAttributeID(USER_ID_OID, "uid")};
    protected static AlternativeAttributeName[] alternativeAttributeNames = new AlternativeAttributeName[]{new AlternativeAttributeName(7, "email"), new AlternativeAttributeName(7, "mail"), new AlternativeAttributeName(7, "EmailAddress"), new AlternativeAttributeName(7, "Ea")};
    private int attributeType;
    private byte[] attributeOID;
    private byte[] valueDER;
    private int valueOffset;
    private int valueLen;
    private int valueType = -1;
    private String valueString;
    private static final char UNKNOWN_CHAR = '?';
    protected ASN1Template asn1Template;

    protected AttributeValueAssertion() {
    }

    public AttributeValueAssertion(String avaString, int encoding) throws NameException {
        if (avaString == null) {
            throw new NameException("AVA string is null");
        }
        String[] typeAndValue = avaString.split("=", 2);
        if (typeAndValue.length != 2) {
            throw new NameException("AVA representation is invalid, should be 'type=value'");
        }
        String atrType = typeAndValue[0].trim();
        String atrValue = typeAndValue[1];
        int attributeIndex = AttributeValueAssertion.findAttributeType(atrType);
        if (attributeIndex == -1) {
            byte[] oid;
            try {
                oid = CertJUtils.oidStringToBytes(atrType);
            }
            catch (IllegalArgumentException ex) {
                throw new NameException("Invalid OID: should be the dotted-decimal encoding with at least 2 components.");
            }
            byte[] ber = this.berStringToBytes(atrValue);
            this.createAVA(oid, ber);
        } else {
            String avaNameString = this.encodeStringAsType(atrValue, encoding);
            this.attributeType = attributeIndex;
            this.valueType = encoding == 0 ? AttributeValueAssertion.getDefaultValueType(attributeIndex) : encoding;
            this.verifyAttribute(this.attributeType, this.valueType, avaNameString);
            if (!this.supportedASN1Type(this.valueType)) {
                throw new NameException("Unsupported ASN1 type. Use another constructor that takes the DER form.");
            }
            this.valueString = avaNameString;
        }
    }

    private String encodeStringAsType(String fromString, int encoding) throws NameException {
        byte[] encoded = null;
        try {
            switch (encoding) {
                case 5632: {
                    encoded = fromString.getBytes("US-ASCII");
                    return new String(encoded, "US-ASCII");
                }
                case 4864: {
                    encoded = fromString.getBytes("US-ASCII");
                    for (int i = 0; i < encoded.length; ++i) {
                        if (encoded[i] >= 97 || encoded[i] <= 122 || encoded[i] >= 65 || encoded[i] <= 90 || encoded[i] >= 48 || encoded[i] <= 57 || encoded[i] == 32 || encoded[i] == 39 || encoded[i] == 40 || encoded[i] == 41 || encoded[i] == 43 || encoded[i] == 44 || encoded[i] == 45 || encoded[i] == 46 || encoded[i] == 47 || encoded[i] == 58 || encoded[i] == 61 || encoded[i] == 63) continue;
                        encoded[i] = 63;
                    }
                    return new String(encoded, "US-ASCII");
                }
                case 5120: {
                    encoded = fromString.getBytes("ISO-8859-1");
                    return new String(encoded, "ISO-8859-1");
                }
            }
            return fromString;
        }
        catch (UnsupportedEncodingException e) {
            throw new NameException("Cannot convert to chosen string encoding type");
        }
    }

    private byte[] berStringToBytes(String ber) {
        String value = ber.startsWith("#") ? ber.substring(1) : ber;
        int berLength = value.length();
        byte[] result = berLength % 2 == 0 ? new byte[berLength / 2] : new byte[berLength / 2 + 1];
        int i = result.length - 1;
        int j = berLength;
        while (i >= 0) {
            result[i] = j == 1 ? (byte)Integer.parseInt(value.substring(j - 1, j), 16) : (j == berLength ? (byte)Integer.parseInt(value.substring(j - 2), 16) : (byte)Integer.parseInt(value.substring(j - 2, j), 16));
            --i;
            j -= 2;
        }
        return result;
    }

    public AttributeValueAssertion(int attributeType, byte[] attributeOID, byte[] ber, int offset, int length) throws NameException {
        this.attributeType = attributeType;
        if (attributeType < -1 || attributeType >= ALL_NAME_ATTRIBUTE_IDS.length) {
            this.attributeType = -1;
        }
        if (ber == null || length == 0) {
            throw new NameException("BER encoding is null.");
        }
        this.valueDER = ber;
        this.valueOffset = offset;
        this.valueLen = length;
        if (this.attributeType == -1) {
            if (attributeOID == null) {
                throw new NameException("AVA type is missing.");
            }
            this.attributeOID = attributeOID;
            try {
                this.decodeDirectoryString(this.valueDER, this.valueOffset, -1);
            }
            catch (NameException nameException) {
                this.valueString = null;
            }
            return;
        }
        this.decodeString(ber, offset);
    }

    public AttributeValueAssertion(int attributeType, byte[] attributeOID, int valueType, String valueString) throws NameException {
        this.attributeType = attributeType;
        if (attributeType < -1 || attributeType >= ALL_NAME_ATTRIBUTE_IDS.length) {
            this.attributeType = -1;
        }
        if (valueType == 0) {
            valueType = AttributeValueAssertion.getDefaultValueType(attributeType);
        }
        if (attributeType == 14 && valueType == 1280 && valueString == null) {
            valueType = 4864;
            valueString = this.getDRBGDefaultString();
        }
        this.valueType = valueType;
        if (this.attributeType == -1) {
            if (attributeOID == null) {
                throw new NameException("AVA type is missing.");
            }
            this.attributeOID = attributeOID;
        } else {
            this.verifyAttribute(this.attributeType, this.valueType, valueString);
        }
        if (!this.supportedASN1Type(this.valueType)) {
            throw new NameException("Unsupported ASN1 type. Use another constructor that takes the DER form.");
        }
        if (valueString == null) {
            throw new NameException("AVA value is missing.");
        }
        this.valueString = valueString;
    }

    private String getDRBGDefaultString() {
        SecureRandom rand = CryptoJ.getDefaultRandom();
        byte[] randBytes = new byte[32];
        rand.nextBytes(randBytes);
        return ConvertUtil.byteArrayToHexString(randBytes);
    }

    public AttributeValueAssertion(byte[] attributeOID, byte[] ber) throws NameException {
        this.createAVA(attributeOID, ber);
    }

    public void createAVA(byte[] attributeOID, byte[] ber) throws NameException {
        if (attributeOID == null || ber == null) {
            throw new NameException("AVA data is missing.");
        }
        this.attributeType = AttributeValueAssertion.findOID(attributeOID, 0, attributeOID.length);
        this.attributeOID = attributeOID;
        this.valueDER = ber;
        this.valueOffset = 0;
        this.valueLen = ber.length;
        try {
            this.decodeDirectoryString(this.valueDER, this.valueOffset, -1);
        }
        catch (NameException nameException) {
            this.valueString = null;
        }
    }

    public int getAttributeType() {
        return this.attributeType;
    }

    public int getValueType() {
        return this.valueType;
    }

    private static int getDefaultValueType(int attributeType) throws NameException {
        if (attributeType == -1) {
            throw new NameException("ASN.1 type is missing.");
        }
        switch (attributeType) {
            case 1: 
            case 6: 
            case 14: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 29: {
                return 4864;
            }
            case 7: 
            case 19: {
                return 5632;
            }
            case 22: {
                return 6144;
            }
        }
        return 3072;
    }

    public void setAttributeValue(String value) {
        if (value != null) {
            this.valueString = value;
        }
    }

    public void setAttributeValue(byte[] ber, int offset, int length) throws NameException {
        if (ber == null || length == 0) {
            throw new NameException("BER encoding is null.");
        }
        this.valueDER = ber;
        this.valueOffset = offset;
        this.valueLen = length;
        if (this.attributeType == -1) {
            return;
        }
        this.decodeString(ber, offset);
    }

    private void decodeString(byte[] ber, int offset) throws NameException {
        if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
            this.decodeStringStrict(ber, offset);
        } else {
            this.decodeStringInternal(ber, offset);
        }
    }

    private void decodeStringInternal(byte[] ber, int offset) throws NameException {
        switch (this.attributeType) {
            case 0: {
                this.decodeDirectoryString(ber, offset, Math.max(64, 500));
                break;
            }
            case 1: {
                this.decodeDirectoryString(ber, offset, 500);
                this.valueType = 4864;
                break;
            }
            case 29: {
                this.decodeDirectoryString(ber, offset, 500);
                this.valueType = 4864;
                break;
            }
            case 2: {
                this.decodeDirectoryString(ber, offset, Math.max(128, 500));
                break;
            }
            case 27: {
                this.decodeDirectoryString(ber, offset, Math.max(128, 500));
                break;
            }
            case 3: {
                this.decodeDirectoryString(ber, offset, Math.max(128, 500));
                break;
            }
            case 28: {
                this.decodeDirectoryString(ber, offset, Math.max(128, 500));
                break;
            }
            case 4: {
                this.decodeDirectoryString(ber, offset, Math.max(64, 500));
                break;
            }
            case 5: {
                this.decodeDirectoryString(ber, offset, Math.max(128, 500));
                break;
            }
            case 6: {
                this.decodeDirectoryString(ber, offset, Math.max(32, 500));
                this.valueType = 4864;
                break;
            }
            case 7: {
                this.decodeDirectoryString(ber, offset, Math.max(64, 500));
                break;
            }
            case 8: {
                this.decodeDirectoryString(ber, offset, Math.max(64, 500));
                break;
            }
            case 9: {
                this.decodeDirectoryString(ber, offset, Math.max(128, 500));
                break;
            }
            case 10: {
                this.decodeDirectoryString(ber, offset, Math.max(128, 500));
                break;
            }
            case 11: {
                this.decodeDirectoryString(ber, offset, Math.max(40, 500));
                break;
            }
            case 12: {
                this.decodeDirectoryString(ber, offset, Math.max(32768, 500));
                break;
            }
            case 13: {
                this.decodeDirectoryString(ber, offset, Math.max(32768, 500));
                break;
            }
            case 14: {
                this.decodePrintableString(ber, offset, 1, Math.max(64, 500));
                break;
            }
            case 15: {
                this.decodeDirectoryString(ber, offset, Math.max(32768, 500));
                break;
            }
            case 16: {
                this.decodeDirectoryString(ber, offset, Math.max(32768, 500));
                break;
            }
            case 17: {
                this.decodeDirectoryString(ber, offset, Math.max(32768, 500));
                break;
            }
            case 30: {
                this.decodeDirectoryString(ber, offset, Math.max(128, 500));
                break;
            }
            case 18: {
                this.decodeDirectoryString(ber, offset, -1);
                this.valueType = 4864;
                break;
            }
            case 19: {
                this.decodeIA5String(ber, offset, 1, Math.max(64, 500));
                break;
            }
            case 20: {
                this.decodeSeqDirectoryString(ber, offset, -1);
                break;
            }
            case 21: {
                this.decodeDirectoryString(ber, offset, -1);
                break;
            }
            case 22: {
                this.decodeTime(ber, offset);
                break;
            }
            case 23: {
                this.decodeDirectoryString(ber, offset, Math.max(32768, 500));
                break;
            }
            case 24: {
                this.decodeDirectoryString(ber, offset, Math.max(1, 500));
                this.valueType = 4864;
                break;
            }
            case 25: {
                this.decodeDirectoryString(ber, offset, Math.max(2, 500));
                this.valueType = 4864;
                break;
            }
            case 26: {
                this.decodeDirectoryString(ber, offset, Math.max(2, 500));
                this.valueType = 4864;
                break;
            }
        }
    }

    private void decodeStringStrict(byte[] ber, int offset) throws NameException {
        switch (this.attributeType) {
            case 0: {
                this.decodeDirectoryString(ber, offset, 64);
                break;
            }
            case 1: {
                this.decodePrintableString(ber, offset, 2, 2);
                break;
            }
            case 29: {
                this.decodePrintableString(ber, offset, 2, 2);
                break;
            }
            case 2: {
                this.decodeDirectoryString(ber, offset, 128);
                break;
            }
            case 27: {
                this.decodeDirectoryString(ber, offset, 128);
                break;
            }
            case 3: {
                this.decodeDirectoryString(ber, offset, 128);
                break;
            }
            case 28: {
                this.decodeDirectoryString(ber, offset, 128);
                break;
            }
            case 4: {
                this.decodeDirectoryString(ber, offset, 64);
                break;
            }
            case 5: {
                this.decodeDirectoryString(ber, offset, 128);
                break;
            }
            case 6: {
                this.decodePrintableString(ber, offset, 1, 32);
                break;
            }
            case 7: {
                this.decodeDirectoryString(ber, offset, 64);
                break;
            }
            case 8: {
                this.decodeDirectoryString(ber, offset, 64);
                break;
            }
            case 9: {
                this.decodeDirectoryString(ber, offset, 128);
                break;
            }
            case 10: {
                this.decodeDirectoryString(ber, offset, 128);
                break;
            }
            case 11: {
                this.decodeDirectoryString(ber, offset, 40);
                break;
            }
            case 12: {
                this.decodeDirectoryString(ber, offset, 32768);
                break;
            }
            case 13: {
                this.decodeDirectoryString(ber, offset, 32768);
                break;
            }
            case 14: {
                this.decodePrintableString(ber, offset, 1, 64);
                break;
            }
            case 15: {
                this.decodeDirectoryString(ber, offset, 32768);
                break;
            }
            case 16: {
                this.decodeDirectoryString(ber, offset, 32768);
                break;
            }
            case 17: {
                this.decodeDirectoryString(ber, offset, 32768);
                break;
            }
            case 30: {
                this.decodeDirectoryString(ber, offset, 128);
                break;
            }
            case 18: {
                this.decodePrintableString(ber, offset, 1, -1);
                break;
            }
            case 19: {
                this.decodeIA5String(ber, offset, 1, 64);
                break;
            }
            case 20: {
                this.decodeSeqDirectoryString(ber, offset, -1);
                break;
            }
            case 21: {
                this.decodeDirectoryString(ber, offset, -1);
                break;
            }
            case 22: {
                this.decodeTime(ber, offset);
                break;
            }
            case 23: {
                this.decodeDirectoryString(ber, offset, 32768);
                break;
            }
            case 24: {
                this.decodePrintableString(ber, offset, 1, 1);
                break;
            }
            case 25: {
                this.decodePrintableString(ber, offset, 2, 2);
                break;
            }
            case 26: {
                this.decodePrintableString(ber, offset, 2, 2);
                break;
            }
        }
    }

    public String getStringAttribute() throws NameException {
        return this.getStringAttribute(true);
    }

    public String getStringAttribute(boolean unicode) throws NameException {
        boolean lengthOfNonSpaceEscapedStringIsOne;
        if (this.valueString == null) {
            if (this.valueDER == null) {
                throw new NameException("Cannot form the attribute's value as a String.");
            }
            return this.valueString();
        }
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(this.valueString, ",+\"\\<>;", true);
        while (tok.hasMoreElements()) {
            String token = tok.nextToken();
            if (token.length() == 1) {
                char possibleDelimiter = token.charAt(0);
                switch (possibleDelimiter) {
                    case '\"': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        buffer.append('\\');
                        buffer.append(possibleDelimiter);
                        break;
                    }
                    default: {
                        buffer.append(possibleDelimiter);
                        break;
                    }
                }
                continue;
            }
            buffer.append(token);
        }
        String tempStr = buffer.toString();
        buffer = new StringBuffer();
        tok = new StringTokenizer(tempStr, "#", true);
        while (tok.hasMoreElements()) {
            String token = tok.nextToken();
            if (token.equals("#")) {
                if (buffer.length() == 0) {
                    buffer.append("\\#");
                    continue;
                }
                buffer.append("\\23");
                continue;
            }
            buffer.append(token);
        }
        String tempStr1 = buffer.toString();
        boolean bl = lengthOfNonSpaceEscapedStringIsOne = tempStr1.length() == 1;
        if (tempStr1.startsWith(" ")) {
            buffer = new StringBuffer();
            buffer.append("\\");
            buffer.append(tempStr1);
            tempStr1 = buffer.toString();
        }
        if (tempStr1.endsWith(" ") && !lengthOfNonSpaceEscapedStringIsOne) {
            buffer = new StringBuffer();
            buffer.append(tempStr1);
            buffer.insert(tempStr1.length() - 1, "\\");
            tempStr1 = buffer.toString();
        }
        StringBuffer translatedStr = new StringBuffer();
        if (unicode) {
            return tempStr1;
        }
        for (int i = 0; i < tempStr1.length(); ++i) {
            char chr = tempStr1.charAt(i);
            if (chr > '\u0080' || chr < ' ') {
                byte[] utf8;
                String strUnicode = tempStr1.substring(i, i + 1);
                try {
                    utf8 = strUnicode.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new NameException(e);
                }
                for (int j = 0; j < utf8.length; ++j) {
                    translatedStr.append('\\');
                    String newByte = Integer.toHexString(utf8[j] & 0xFF).toUpperCase();
                    if (newByte.length() == 1) {
                        translatedStr.append('0');
                    }
                    translatedStr.append(newByte);
                }
                continue;
            }
            translatedStr.append(chr);
        }
        return translatedStr.toString();
    }

    public String getStringAttributeNoEscapeSequences() throws NameException {
        if (this.valueString == null && this.valueDER == null) {
            throw new NameException("Cannot form the attribute's value as a String.");
        }
        if (this.valueString == null) {
            return this.valueString();
        }
        return this.valueString;
    }

    protected Object clone() throws CloneNotSupportedException {
        AttributeValueAssertion otherSelf = new AttributeValueAssertion();
        otherSelf.attributeType = this.attributeType;
        if (this.attributeOID == null) {
            otherSelf.attributeOID = null;
        } else {
            otherSelf.attributeOID = new byte[this.attributeOID.length];
            System.arraycopy(this.attributeOID, 0, otherSelf.attributeOID, 0, this.attributeOID.length);
        }
        if (this.valueDER == null) {
            otherSelf.valueDER = null;
        } else {
            otherSelf.valueDER = new byte[this.valueDER.length];
            System.arraycopy(this.valueDER, 0, otherSelf.valueDER, 0, this.valueDER.length);
        }
        otherSelf.valueOffset = this.valueOffset;
        otherSelf.valueLen = this.valueLen;
        otherSelf.valueType = this.valueType;
        otherSelf.valueString = this.valueString;
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AttributeValueAssertion)) {
            return false;
        }
        AttributeValueAssertion other = (AttributeValueAssertion)obj;
        if (!this.oidEquals(other)) {
            return false;
        }
        return this.valueEquals(other);
    }

    public int hashCode() {
        StringBuffer data = new StringBuffer();
        if (this.attributeOID != null) {
            data.append(new String(this.attributeOID));
        }
        if (this.valueString != null) {
            data.append(NameMatcher.compressWhiteSpaces(this.valueString));
        } else if (this.valueDER != null) {
            data.append(new String(this.valueDER));
        }
        return data.toString().hashCode();
    }

    private boolean oidEquals(AttributeValueAssertion other) {
        if (this.attributeOID == null) {
            if (other.attributeOID == null) {
                return this.attributeType == other.attributeType;
            }
            byte[] thisOID = AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[this.attributeType].oid;
            return CertJUtils.byteArraysEqual(thisOID, other.attributeOID);
        }
        if (other.attributeOID == null) {
            byte[] otherOID = AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[other.attributeType].oid;
            return CertJUtils.byteArraysEqual(this.attributeOID, otherOID);
        }
        return CertJUtils.byteArraysEqual(this.attributeOID, other.attributeOID);
    }

    public boolean valueEquals(AttributeValueAssertion other) {
        if (this.valueString != null) {
            if (other.valueString == null) {
                return false;
            }
            if (this.valueType == 4864) {
                String compressedValueStr = NameMatcher.compressWhiteSpaces(this.valueString);
                String otherCompressedValueStr = NameMatcher.compressWhiteSpaces(other.valueString);
                return compressedValueStr.equalsIgnoreCase(otherCompressedValueStr);
            }
            return this.valueString.equals(other.valueString);
        }
        if (other.valueString != null) {
            return false;
        }
        if (this.valueDER != null) {
            if (other.valueDER == null) {
                return false;
            }
            return CertJUtils.byteArraysEqual(this.valueDER, this.valueOffset, this.valueLen, other.valueDER, other.valueOffset, other.valueLen);
        }
        return false;
    }

    static int findOID(byte[] theOID, int offset, int len) {
        if (theOID == null || len == 0) {
            return -1;
        }
        for (int index = 0; index < ALL_NAME_ATTRIBUTE_IDS.length; ++index) {
            int oidIndex;
            if (len != AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[index].oid.length) continue;
            for (oidIndex = 0; oidIndex < len && (theOID[oidIndex + offset] & 0xFF) == (AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[index].oid[oidIndex] & 0xFF); ++oidIndex) {
            }
            if (oidIndex < len) continue;
            return index;
        }
        return -1;
    }

    public static int findAttributeType(String attributeName) {
        int i;
        if (attributeName == null) {
            return -1;
        }
        for (i = 0; i < ALL_NAME_ATTRIBUTE_IDS.length; ++i) {
            if (!attributeName.equalsIgnoreCase(AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[i].printName)) continue;
            return i;
        }
        for (i = 0; i < alternativeAttributeNames.length; ++i) {
            if (!attributeName.equalsIgnoreCase(AttributeValueAssertion.alternativeAttributeNames[i].alternativeName)) continue;
            return AttributeValueAssertion.alternativeAttributeNames[i].attributeType;
        }
        return -1;
    }

    protected static byte[] getAttributeOID(int attributeType) {
        if (attributeType < 0 || attributeType >= ALL_NAME_ATTRIBUTE_IDS.length) {
            return null;
        }
        return AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[attributeType].oid;
    }

    private void verifyAttribute(int attributeType, int valueType, String valueString) throws NameException {
        if (valueString == null) {
            throw new NameException("AVA value is null.");
        }
        if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT)) {
            this.verifyAttributeStrict(attributeType, valueType, valueString);
        } else {
            this.verifyAttributeInternal(attributeType, valueType, valueString);
        }
    }

    private void verifyAttributeStrict(int attributeType, int valueType, String valueString) throws NameException {
        switch (attributeType) {
            case 0: {
                this.verifyDirectoryString(valueType, valueString, 64);
                break;
            }
            case 1: {
                this.verifyPrintableString(valueType, valueString, 2, 2);
                break;
            }
            case 29: {
                this.verifyPrintableString(valueType, valueString, 2, 2);
                break;
            }
            case 2: {
                this.verifyDirectoryString(valueType, valueString, 128);
                break;
            }
            case 27: {
                this.verifyDirectoryString(valueType, valueString, 128);
                break;
            }
            case 3: {
                this.verifyDirectoryString(valueType, valueString, 128);
            }
            case 28: {
                this.verifyDirectoryString(valueType, valueString, 128);
                break;
            }
            case 4: {
                this.verifyDirectoryString(valueType, valueString, 64);
                break;
            }
            case 5: {
                this.verifyDirectoryString(valueType, valueString, 128);
                break;
            }
            case 6: {
                this.verifyPrintableString(valueType, valueString, 1, 32);
                break;
            }
            case 7: {
                this.verifyIA5String(valueType, valueString, 1, 64);
                break;
            }
            case 8: {
                this.verifyDirectoryString(valueType, valueString, 64);
                break;
            }
            case 9: {
                this.verifyDirectoryString(valueType, valueString, 128);
                break;
            }
            case 10: {
                this.verifyDirectoryString(valueType, valueString, 128);
                break;
            }
            case 11: {
                this.verifyDirectoryString(valueType, valueString, 40);
                break;
            }
            case 12: {
                this.verifyDirectoryString(valueType, valueString, 32768);
                break;
            }
            case 13: {
                this.verifyDirectoryString(valueType, valueString, 32768);
                break;
            }
            case 14: {
                this.verifyPrintableString(valueType, valueString, 1, 64);
                break;
            }
            case 15: {
                this.verifyDirectoryString(valueType, valueString, 32768);
                break;
            }
            case 16: {
                this.verifyDirectoryString(valueType, valueString, 32768);
                break;
            }
            case 17: {
                this.verifyDirectoryString(valueType, valueString, 32768);
                break;
            }
            case 30: {
                this.verifyDirectoryString(valueType, valueString, 128);
                break;
            }
            case 18: {
                this.verifyPrintableString(valueType, valueString, 1, -1);
                break;
            }
            case 19: {
                this.verifyIA5String(valueType, valueString, 1, 64);
                break;
            }
            case 20: {
                this.verifyDirectoryString(valueType, valueString, -1);
                break;
            }
            case 21: {
                this.verifyDirectoryString(valueType, valueString, -1);
                break;
            }
            case 22: {
                this.verifyTimeString(valueType);
                break;
            }
            case 23: {
                this.verifyDirectoryString(valueType, valueString, 32768);
                break;
            }
            case 24: {
                this.verifyPrintableString(valueType, valueString, 1, 1);
                break;
            }
            case 25: {
                this.verifyPrintableString(valueType, valueString, 2, 2);
                break;
            }
            case 26: {
                this.verifyPrintableString(valueType, valueString, 2, 2);
                break;
            }
        }
    }

    private void verifyAttributeInternal(int attributeType, int valueType, String valueString) throws NameException {
        switch (attributeType) {
            case 0: {
                this.verifyDirectoryString(valueType, valueString, Math.max(64, 500));
                break;
            }
            case 1: {
                this.verifyDirectoryString(valueType, valueString, 500);
                this.valueType = 4864;
                break;
            }
            case 29: {
                this.verifyDirectoryString(valueType, valueString, 500);
                this.valueType = 4864;
                break;
            }
            case 2: {
                this.verifyDirectoryString(valueType, valueString, Math.max(128, 500));
                break;
            }
            case 27: {
                this.verifyDirectoryString(valueType, valueString, Math.max(128, 500));
                break;
            }
            case 3: {
                this.verifyDirectoryString(valueType, valueString, Math.max(128, 500));
                break;
            }
            case 28: {
                this.verifyDirectoryString(valueType, valueString, Math.max(128, 500));
                break;
            }
            case 4: {
                this.verifyDirectoryString(valueType, valueString, Math.max(64, 500));
                break;
            }
            case 5: {
                this.verifyDirectoryString(valueType, valueString, Math.max(128, 500));
                break;
            }
            case 6: {
                this.verifyPrintableString(valueType, valueString, 1, Math.max(32, 500));
                break;
            }
            case 7: {
                this.verifyIA5String(valueType, valueString, 1, Math.max(64, 500));
                break;
            }
            case 8: {
                this.verifyDirectoryString(valueType, valueString, Math.max(64, 500));
                break;
            }
            case 9: {
                this.verifyDirectoryString(valueType, valueString, Math.max(128, 500));
                break;
            }
            case 10: {
                this.verifyDirectoryString(valueType, valueString, Math.max(128, 500));
                break;
            }
            case 11: {
                this.verifyDirectoryString(valueType, valueString, Math.max(40, 500));
                break;
            }
            case 12: {
                this.verifyDirectoryString(valueType, valueString, Math.max(32768, 500));
                break;
            }
            case 13: {
                this.verifyDirectoryString(valueType, valueString, Math.max(32768, 500));
                break;
            }
            case 14: {
                this.verifyPrintableString(valueType, valueString, 1, Math.max(64, 500));
                break;
            }
            case 15: {
                this.verifyDirectoryString(valueType, valueString, Math.max(32768, 500));
                break;
            }
            case 16: {
                this.verifyDirectoryString(valueType, valueString, Math.max(32768, 500));
                break;
            }
            case 17: {
                this.verifyDirectoryString(valueType, valueString, Math.max(32768, 500));
                break;
            }
            case 30: {
                this.verifyDirectoryString(valueType, valueString, Math.max(128, 500));
                break;
            }
            case 18: {
                this.verifyPrintableString(valueType, valueString, 1, -1);
                break;
            }
            case 19: {
                this.verifyIA5String(valueType, valueString, 1, Math.max(64, 500));
                break;
            }
            case 20: {
                this.verifyDirectoryString(valueType, valueString, -1);
                break;
            }
            case 21: {
                this.verifyDirectoryString(valueType, valueString, -1);
                break;
            }
            case 22: {
                this.verifyTimeString(valueType);
                break;
            }
            case 23: {
                this.verifyDirectoryString(valueType, valueString, Math.max(32768, 500));
                break;
            }
            case 24: {
                this.verifyPrintableString(valueType, valueString, 1, Math.max(1, 500));
                break;
            }
            case 25: {
                this.verifyDirectoryString(valueType, valueString, 500);
                this.valueType = 4864;
                break;
            }
            case 26: {
                this.verifyDirectoryString(valueType, valueString, 500);
                this.valueType = 4864;
                break;
            }
        }
    }

    private void verifyDirectoryString(int valueType, String valueString, int upperBound) throws NameException {
        if (valueType != 4864 && valueType != 5120 && valueType != 7168 && valueType != 3072 && valueType != 7680 && valueType != 5632) {
            throw new NameException("DirectoryString expected.");
        }
        if (valueString.length() < 1) {
            throw new NameException("DirectoryString too small.");
        }
        if (upperBound != -1 && valueString.length() > upperBound) {
            throw new NameException("DirectoryString too large.");
        }
    }

    private void verifyPrintableString(int valueType, String valueString, int lowerBound, int upperBound) throws NameException {
        if (valueType != 4864) {
            throw new NameException("PrintableString expected.");
        }
        if (lowerBound != -1 && valueString.length() < lowerBound) {
            throw new NameException("PrintableString too small.");
        }
        if (upperBound != -1 && valueString.length() > upperBound) {
            throw new NameException("PrintableString too large.");
        }
    }

    private void verifyTimeString(int valueType) throws NameException {
        if (valueType != 6144) {
            throw new NameException("GenTime is expected.");
        }
    }

    private void verifyIA5String(int valueType, String valueString, int lowerBound, int upperBound) throws NameException {
        if (valueType != 5632) {
            throw new NameException("IA5String expected.");
        }
        if (lowerBound != -1 && valueString.length() < lowerBound) {
            throw new NameException("IA5String too small.");
        }
        if (upperBound != -1 && valueString.length() > upperBound) {
            throw new NameException("IA5String too large.");
        }
    }

    private boolean supportedASN1Type(int asn1Type) {
        if (asn1Type == 4864) {
            return true;
        }
        if (asn1Type == 5120) {
            return true;
        }
        if (asn1Type == 7168) {
            return true;
        }
        if (asn1Type == 5632) {
            return true;
        }
        if (asn1Type == 7680) {
            return true;
        }
        if (asn1Type == 3072) {
            return true;
        }
        return asn1Type == 6144;
    }

    void decodeDirectoryString(byte[] encoding, int offset, int upperBound) throws NameException {
        IA5StringContainer ia5StringContainer;
        UTF8StringContainer utf8StringContainer;
        BMPStringContainer bmpStringContainer;
        UniversalStringContainer universalStringContainer;
        TeletexStringContainer teletexStringContainer;
        PrintStringContainer printStringContainer;
        if (encoding == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(0);
            printStringContainer = new PrintStringContainer(0, 1, upperBound);
            teletexStringContainer = new TeletexStringContainer(0, 1, upperBound);
            universalStringContainer = new UniversalStringContainer(0, 1, upperBound);
            bmpStringContainer = new BMPStringContainer(0, 1, upperBound);
            utf8StringContainer = new UTF8StringContainer(0);
            ia5StringContainer = new IA5StringContainer(0, 1, upperBound);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] directoryStringDef = new ASN1Container[]{choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, utf8StringContainer, bmpStringContainer, ia5StringContainer, endContainer};
            ASN1.berDecode((byte[])encoding, (int)offset, (ASN1Container[])directoryStringDef);
        }
        catch (ASN_Exception asnException) {
            throw new NameException("DirectoryString expected.");
        }
        if (printStringContainer.dataPresent) {
            this.valueType = 4864;
            this.valueString = printStringContainer.getValueAsString();
        } else if (teletexStringContainer.dataPresent) {
            this.valueType = 5120;
            this.valueString = teletexStringContainer.getValueAsString();
        } else if (universalStringContainer.dataPresent) {
            this.valueType = 7168;
            this.valueString = universalStringContainer.getValueAsString();
        } else if (bmpStringContainer.dataPresent) {
            this.valueType = 7680;
            this.valueString = bmpStringContainer.getValueAsString();
        } else if (utf8StringContainer.dataPresent) {
            this.valueType = 3072;
            this.valueString = this.utf8Decode(utf8StringContainer.data, utf8StringContainer.dataOffset, utf8StringContainer.dataLen);
            this.verifyAttribute(this.attributeType, this.valueType, this.valueString);
        } else if (ia5StringContainer.dataPresent) {
            this.valueType = 5632;
            this.valueString = ia5StringContainer.getValueAsString();
        } else {
            throw new NameException("DirectoryString expected.");
        }
    }

    void decodeSeqDirectoryString(byte[] encoding, int offset, int upperBound) throws NameException {
        if (encoding == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(65280));
            ASN1Container[] asn1Def = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])encoding, (int)offset, (ASN1Container[])asn1Def);
            StringBuffer buffer = new StringBuffer();
            for (int index = 0; index < seqOf.getContainerCount(); ++index) {
                EncodedContainer value = (EncodedContainer)seqOf.containerAt(index);
                this.decodeDirectoryString(value.data, value.dataOffset, upperBound);
                if (index != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.valueString);
            }
            this.valueString = buffer.toString();
            this.valueType = 3072;
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Invalid encoding. ", (Exception)((Object)asnException));
        }
    }

    void decodePrintableString(byte[] encoding, int offset, int lowerBound, int upperBound) throws NameException {
        PrintStringContainer printStringContainer;
        if (encoding == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            printStringContainer = new PrintStringContainer(0, lowerBound, upperBound);
            ASN1Container[] printableStringDef = new ASN1Container[]{printStringContainer};
            ASN1.berDecode((byte[])encoding, (int)offset, (ASN1Container[])printableStringDef);
        }
        catch (ASN_Exception asnException) {
            throw new NameException("PrintableString expected.");
        }
        this.valueType = 4864;
        this.valueString = printStringContainer.getValueAsString();
    }

    void decodeTime(byte[] encoding, int offset) throws NameException {
        GenTimeContainer timeContainer;
        if (encoding == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            timeContainer = new GenTimeContainer(0);
            ASN1Container[] timeDef = new ASN1Container[]{timeContainer};
            ASN1.berDecode((byte[])encoding, (int)offset, (ASN1Container[])timeDef);
        }
        catch (ASN_Exception asnException) {
            throw new NameException("GenTime expected.", (Exception)((Object)asnException));
        }
        this.valueType = 6144;
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, MMM d, yyyy hh:mm:ss z");
        this.valueString = formatter.format(timeContainer.theTime);
    }

    void decodeIA5String(byte[] encoding, int offset, int lowerBound, int upperBound) throws NameException {
        IA5StringContainer ia5StringContainer;
        if (encoding == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ia5StringContainer = new IA5StringContainer(0, lowerBound, upperBound);
            ASN1Container[] ia5StringDef = new ASN1Container[]{ia5StringContainer};
            ASN1.berDecode((byte[])encoding, (int)offset, (ASN1Container[])ia5StringDef);
        }
        catch (ASN_Exception asnException) {
            throw new NameException("IA5String expected.");
        }
        this.valueType = 5632;
        this.valueString = ia5StringContainer.getValueAsString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean unicode) {
        String avaString = null;
        StringBuffer buffer = new StringBuffer();
        try {
            if (this.valueString != null) {
                avaString = this.getStringAttribute(unicode);
            }
        }
        catch (NameException nameExc) {
            // empty catch block
        }
        if (this.attributeType == -1) {
            buffer.append(this.oidString());
            buffer.append("=");
            if (avaString != null) {
                buffer.append(avaString);
            } else if (this.valueDER != null) {
                buffer.append(this.valueString());
            }
        } else {
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_EMAIL_AVA_EA) && this.attributeType == 7) {
                buffer.append("Ea");
            } else {
                buffer.append(AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[this.attributeType].printName);
            }
            buffer.append("=");
            buffer.append(avaString);
        }
        return buffer.toString();
    }

    private String oidString() {
        if (this.attributeOID == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int value = 0;
        buffer = buffer.append((this.attributeOID[i] & 0xFF) / 40);
        buffer = buffer.append('.');
        buffer = buffer.append((this.attributeOID[i] & 0xFF) % 40);
        ++i;
        while (i < this.attributeOID.length) {
            buffer = buffer.append('.');
            do {
                value = (value << 7) + (this.attributeOID[i] & 0x7F & 0xFF);
            } while ((this.attributeOID[i++] & 0x80) != 0 && i < this.attributeOID.length);
            buffer = buffer.append(value);
            value = 0;
        }
        return buffer.toString();
    }

    private String valueString() {
        if (this.valueDER == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer = buffer.append("#");
        for (int index = this.valueOffset; index < this.valueLen + this.valueOffset; ++index) {
            int temp = this.valueDER[index] & 0xFF;
            String hexVal = Integer.toHexString(temp);
            if (hexVal.length() == 1) {
                buffer = buffer.append("0");
            }
            buffer = buffer.append(hexVal);
        }
        return buffer.toString();
    }

    private ASN1Container createTimeContainer() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, MMM d, yyyy hh:mm:ss z");
        ParsePosition pos = new ParsePosition(0);
        Date value = formatter.parse(this.valueString, pos);
        return new GenTimeContainer(0, true, 0, value);
    }

    private ASN1Container createSeqContainer(int lowerBound, int upperBound) throws NameException {
        try {
            ASN1Container value = this.createStringContainer(lowerBound, upperBound);
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{seq, value, endContainer};
            this.asn1Template = new ASN1Template(asn1Def);
            int len = this.asn1Template.derEncodeInit();
            byte[] encoding = new byte[len];
            len = this.asn1Template.derEncode(encoding, 0);
            return new EncodedContainer(12288, true, 0, encoding, 0, len);
        }
        catch (ASN_Exception asn1Exception) {
            throw new NameException("Invalid String.", (Exception)((Object)asn1Exception));
        }
    }

    private ASN1Container createStringContainer(int lowerBound, int upperBound) throws NameException {
        try {
            switch (this.valueType) {
                case 4864: {
                    boolean isStrict = CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT);
                    int special = isStrict ? 0 : 0x8000000;
                    return new PrintStringContainer(special, true, 0, this.valueString, lowerBound, upperBound);
                }
                case 5120: {
                    return new TeletexStringContainer(0, true, 0, this.valueString, lowerBound, upperBound);
                }
                case 7168: {
                    return new UniversalStringContainer(0, true, 0, this.valueString, lowerBound, upperBound);
                }
                case 5632: {
                    return new IA5StringContainer(0, true, 0, this.valueString, lowerBound, upperBound);
                }
                case 3072: {
                    byte[] utf8Bytes = this.utf8Encode(this.valueString);
                    if (utf8Bytes.length < 2) {
                        throw new NameException("AttributeValueAssertion.createStringContainer: DataOutputStream.writeUTF() did not contain necessary 2 bytes specifying the encoding length.");
                    }
                    return new UTF8StringContainer(0, true, 0, utf8Bytes, 2, utf8Bytes.length - 2);
                }
                case 7680: {
                    return new BMPStringContainer(0, true, 0, this.valueString, lowerBound, upperBound);
                }
            }
            return null;
        }
        catch (ASN_Exception asn1Exception) {
            throw new NameException("Invalid String.", (Exception)((Object)asn1Exception));
        }
    }

    private byte[] utf8Encode(String string) throws NameException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        try {
            out.writeUTF(string);
            out.flush();
        }
        catch (IOException e) {
            throw new NameException("AttributeValueAssertion.utf8Encode: unable to utf8-encode " + string + ".", e);
        }
        return byteOut.toByteArray();
    }

    private String utf8Decode(byte[] data, int offset, int len) throws NameException {
        byte[] buffer = new byte[len + 2];
        buffer[0] = (byte)(len >> 8 & 0xFF);
        buffer[1] = (byte)(len & 0xFF);
        System.arraycopy(data, offset, buffer, 2, len);
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(buffer, 0, buffer.length);
            DataInputStream in = new DataInputStream(byteIn);
            return in.readUTF();
        }
        catch (IOException ioException) {
            throw new NameException("AttributeValueAssertion.utf8Decode.", ioException);
        }
    }

    public int getDERLen() {
        try {
            OIDContainer oidContainer;
            SequenceContainer seqContainer = new SequenceContainer(0, true, 0);
            if (this.attributeType != -1) {
                byte[] oid = AttributeValueAssertion.ALL_NAME_ATTRIBUTE_IDS[this.attributeType].oid;
                oidContainer = new OIDContainer(0x1000000, true, 0, oid, 0, oid.length);
            } else {
                oidContainer = new OIDContainer(0x1000000, true, 0, this.attributeOID, 0, this.attributeOID.length);
            }
            Object container = this.valueType == -1 ? new EncodedContainer(65280, true, 0, this.valueDER, this.valueOffset, this.valueLen) : (this.valueType == 20 ? this.createSeqContainer(this.getLowerBound(this.attributeType), this.getUpperBound(this.attributeType)) : (this.valueType == 22 ? this.createTimeContainer() : this.createStringContainer(this.getLowerBound(this.attributeType), this.getUpperBound(this.attributeType))));
            EndContainer endContainer = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{seqContainer, oidContainer, container, endContainer};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (NameException e) {
            return 0;
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private int getLowerBound(int attributeType) {
        boolean isStrict = CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT);
        switch (attributeType) {
            case 1: 
            case 25: 
            case 26: 
            case 29: {
                return isStrict ? 2 : 1;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                return 1;
            }
        }
        return -1;
    }

    private int getUpperBound(int attributeType) {
        boolean isStrict = CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_STRICT_CERT);
        switch (attributeType) {
            case 0: {
                return isStrict ? 64 : Math.max(64, 500);
            }
            case 1: {
                return isStrict ? 2 : Math.max(2, 500);
            }
            case 2: {
                return isStrict ? 128 : Math.max(128, 500);
            }
            case 3: {
                return isStrict ? 128 : Math.max(128, 500);
            }
            case 4: {
                return isStrict ? 64 : Math.max(64, 500);
            }
            case 5: {
                return isStrict ? 128 : Math.max(128, 500);
            }
            case 6: {
                return isStrict ? 32 : Math.max(32, 500);
            }
            case 7: {
                return isStrict ? 64 : Math.max(64, 500);
            }
            case 8: {
                return isStrict ? 64 : Math.max(64, 500);
            }
            case 9: {
                return isStrict ? 128 : Math.max(128, 500);
            }
            case 10: {
                return isStrict ? 128 : Math.max(128, 500);
            }
            case 11: {
                return isStrict ? 40 : Math.max(40, 500);
            }
            case 12: {
                return isStrict ? 32768 : Math.max(32768, 500);
            }
            case 13: {
                return isStrict ? 32768 : Math.max(32768, 500);
            }
            case 14: {
                return isStrict ? 64 : Math.max(64, 500);
            }
            case 15: {
                return isStrict ? 32768 : Math.max(32768, 500);
            }
            case 16: {
                return isStrict ? 32768 : Math.max(32768, 500);
            }
            case 17: {
                return isStrict ? 32768 : Math.max(32768, 500);
            }
            case 30: {
                return isStrict ? 128 : Math.max(128, 500);
            }
            case 18: {
                return -1;
            }
            case 19: {
                return isStrict ? 64 : Math.max(64, 500);
            }
            case 20: {
                return -1;
            }
            case 21: {
                return -1;
            }
            case 22: {
                return -1;
            }
            case 23: {
                return isStrict ? 32768 : Math.max(32768, 500);
            }
            case 24: {
                return isStrict ? 1 : Math.max(1, 500);
            }
            case 25: {
                return isStrict ? 2 : Math.max(2, 500);
            }
            case 26: {
                return isStrict ? 2 : Math.max(2, 500);
            }
            case 27: {
                return isStrict ? 128 : Math.max(128, 500);
            }
            case 28: {
                return isStrict ? 128 : Math.max(128, 500);
            }
            case 29: {
                return isStrict ? 128 : Math.max(128, 500);
            }
        }
        return -1;
    }

    public int getDEREncoding(byte[] encoding, int offset) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if (this.asn1Template == null && (len = this.getDERLen()) == 0) {
                throw new NameException("Could not encode AVA. ");
            }
            return this.asn1Template.derEncode(encoding, offset);
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Could not encode: ", (Exception)((Object)asnException));
        }
    }
}

