/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.OIDList;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class CertRequest
implements Cloneable,
Serializable {
    private static final String DEFAULT_DEVICE = "Java";
    public static final int RSA_WITH_SHA1_PKCS = 0;
    public static final int RSA_WITH_SHA1_ISO_OIW = 1;
    public static final int DSA_WITH_SHA1_X930 = 2;
    public static final int DSA_WITH_SHA1_X957 = 3;
    protected byte[] subjectPublicKeyInfo;
    protected byte[] signatureAlgorithmBER;
    protected int signatureAlgorithmFormat = -1;
    protected byte[] signature;
    protected boolean signedByUs;
    private CertJ theCertJ;

    public final void setCertJ(CertJ certJContext) {
        this.theCertJ = certJContext;
    }

    public final CertJ getCertJ() {
        return this.theCertJ;
    }

    public String getSignatureAlgorithm() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return OIDList.getTrans((byte[])this.signatureAlgorithmBER, (int)0, (int)this.signatureAlgorithmBER.length, (int)1);
    }

    public byte[] getSignatureAlgorithmDER() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return (byte[])this.signatureAlgorithmBER.clone();
    }

    public abstract byte[] getSignature() throws CertificateException;

    public String getDevice() throws CertificateException {
        return DEFAULT_DEVICE;
    }

    public String[] getDeviceList() throws CertificateException {
        return new String[]{DEFAULT_DEVICE};
    }

    public void setSignatureStandard(int standardFlag) {
        this.signatureAlgorithmFormat = standardFlag;
    }

    public int getSignatureStandard() {
        return this.signatureAlgorithmFormat;
    }

    public String getSignatureFormat() {
        switch (this.signatureAlgorithmFormat) {
            case 0: {
                return "RSAWithSHA1PKCS";
            }
            case 1: {
                return "RSAWithSHA1ISO_OIW";
            }
            case 2: {
                return "DSAWithSHA1X930";
            }
            case 3: {
                return "DSAWithSHA1X957";
            }
        }
        return null;
    }

    public void setSubjectPublicKey(JSAFE_PublicKey publicKey) throws CertificateException {
        this.clearSignature();
        if (publicKey == null) {
            throw new CertificateException("Public key is null.");
        }
        try {
            String format = this.signatureAlgorithmFormat == 3 && publicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : publicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] keyData = publicKey.getKeyData(format);
            this.subjectPublicKeyInfo = keyData[0];
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not read the public key.");
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey(String device) throws CertificateException {
        if (this.subjectPublicKeyInfo == null) {
            throw new CertificateException("Object not set with public key.");
        }
        if (device == null) {
            throw new CertificateException("Device is null.");
        }
        try {
            return JSAFEFactory.getPublicKey(this.subjectPublicKeyInfo, 0, device, this.theCertJ);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Cannot retrieve the public key: ", (Exception)((Object)jsafeException));
        }
    }

    public void setSubjectPublicKey(byte[] publicKeyBER, int offset) throws CertificateException {
        this.clearSignature();
        if (publicKeyBER == null) {
            throw new CertificateException("Public key encoding is null.");
        }
        JSAFE_PublicKey publicKey = null;
        try {
            publicKey = JSAFEFactory.getPublicKey(publicKeyBER, offset, DEFAULT_DEVICE, this.theCertJ);
            this.setSubjectPublicKey(publicKey);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not read the public key.");
        }
        finally {
            if (publicKey != null) {
                publicKey.clearSensitiveData();
            }
        }
    }

    public abstract void signCertRequest(String var1, String var2, JSAFE_PrivateKey var3, SecureRandom var4) throws CertificateException;

    public abstract boolean verifyCertRequestSignature(String var1, SecureRandom var2) throws CertificateException;

    protected byte[] performSignature(String transformation, String device, JSAFE_PrivateKey signingKey, SecureRandom random, byte[] dataToSign, int offset, int len) throws CertificateException {
        if (transformation == null || device == null || signingKey == null || random == null || dataToSign == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature signer = null;
        try {
            this.signedByUs = true;
            signer = JSAFEFactory.getSignature(transformation, device, this.theCertJ);
            if (this.theCertJ == null) {
                signer.signInit(signingKey, null, random, null);
            } else {
                signer.signInit(signingKey, null, random, this.theCertJ.getPKCS11Sessions());
            }
            this.signatureAlgorithmBER = signer.getDERAlgorithmID(this.getSignatureFormat(), false);
            signer.signUpdate(dataToSign, offset, len);
            byte[] byArray = signer.signFinal();
            return byArray;
        }
        catch (JSAFE_Exception jsafeException) {
            this.signedByUs = false;
            throw new CertificateException("Could not sign the request: ", (Exception)((Object)jsafeException));
        }
        finally {
            if (signer != null) {
                signer.clearSensitiveData();
            }
        }
    }

    protected boolean performSignatureVerification(String device, SecureRandom random, byte[] dataToVerify, int dataOffset, int dataLen, byte[] signatureData, int sigOffset, int sigLen) throws CertificateException {
        if (device == null || random == null || dataToVerify == null || signatureData == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_PublicKey publicKey = null;
        JSAFE_Signature verifier = null;
        try {
            publicKey = JSAFEFactory.getPublicKey(this.subjectPublicKeyInfo, 0, device, this.theCertJ);
            verifier = JSAFEFactory.getSignature(this.signatureAlgorithmBER, 0, device, this.theCertJ);
            if (this.theCertJ == null) {
                verifier.verifyInit(publicKey, null, random, null);
            } else {
                verifier.verifyInit(publicKey, null, random, this.theCertJ.getPKCS11Sessions());
            }
            verifier.verifyUpdate(dataToVerify, dataOffset, dataLen);
            boolean bl = verifier.verifyFinal(signatureData, sigOffset, sigLen);
            return bl;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not verify the request: ", (Exception)((Object)jsafeException));
        }
        finally {
            if (publicKey != null) {
                publicKey.clearSensitiveData();
            }
            if (verifier != null) {
                verifier.clearSensitiveData();
            }
        }
    }

    protected void clearSignature() {
        this.signature = null;
        this.signatureAlgorithmBER = null;
        this.signedByUs = false;
    }

    protected void clearComponents() {
        this.clearSignature();
        this.subjectPublicKeyInfo = null;
    }
}

