/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.OIDList;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class Certificate
implements Cloneable,
Serializable {
    private static final String DEFAULT_DEVICE = "Java";
    public static final int RSA_WITH_SHA1_PKCS = 0;
    public static final int RSA_WITH_SHA1_ISO_OIW = 1;
    public static final int DSA_WITH_SHA1_X930 = 2;
    public static final int DSA_WITH_SHA1_X957 = 3;
    protected byte[] subjectPublicKeyInfo;
    protected JSAFE_PublicKey subjectPublicKey;
    protected byte[] signatureAlgorithmBER;
    protected int signatureAlgorithmFormat = -1;
    protected byte[] signature;
    protected String theDevice;
    protected String[] theDeviceList;
    private CertJ theCertJ;

    public final void setCertJ(CertJ certJContext) {
        this.theCertJ = certJContext;
    }

    public final CertJ getCertJ() {
        return this.theCertJ;
    }

    public String getSignatureAlgorithm() throws CertificateException {
        try {
            if (this.signatureAlgorithmBER == null) {
                throw new CertificateException("Object not set with signature algorithm.");
            }
            return AlgorithmID.berDecodeAlgID((byte[])this.signatureAlgorithmBER, (int)0, (int)1, null);
        }
        catch (ASN_Exception e) {
            throw new CertificateException("Invalid Signature Algorithm.", (Exception)((Object)e));
        }
    }

    public byte[] getSignatureAlgorithmDER() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return (byte[])this.signatureAlgorithmBER.clone();
    }

    public abstract byte[] getSignature() throws CertificateException;

    public String getDevice() throws CertificateException {
        return DEFAULT_DEVICE;
    }

    public String[] getDeviceList() throws CertificateException {
        return new String[]{DEFAULT_DEVICE};
    }

    public void setSignatureStandard(int standardFlag) {
        this.signatureAlgorithmFormat = standardFlag;
    }

    public int getSignatureStandard() {
        return this.signatureAlgorithmFormat;
    }

    public String getSignatureFormat(String transformation) {
        if (transformation == null) {
            return null;
        }
        switch (this.signatureAlgorithmFormat) {
            case 0: {
                if (transformation.equals("SHA1/RSA/PKCS1Block01Pad")) {
                    return "RSAWithSHA1PKCS";
                }
                return null;
            }
            case 1: {
                if (transformation.equals("SHA1/RSA/PKCS1Block01Pad")) {
                    return "RSAWithSHA1ISO_OIW";
                }
                return null;
            }
            case 2: {
                if (transformation.equals("SHA1/DSA") || transformation.equals("SHA1/DSA/NoPad")) {
                    return "DSAWithSHA1X930";
                }
                return null;
            }
            case 3: {
                if (transformation.equals("SHA1/DSA") || transformation.equals("SHA1/DSA/NoPad")) {
                    return "DSAWithSHA1X957";
                }
                return null;
            }
        }
        if (transformation.equals("SHA1/DSA")) {
            return "SHA1/DSA/NoPad";
        }
        return null;
    }

    public void setSubjectPublicKey(JSAFE_PublicKey publicKey) throws CertificateException {
        if (publicKey == null) {
            throw new CertificateException("Public key is null.");
        }
        this.clearSignature();
        try {
            this.subjectPublicKey = (JSAFE_PublicKey)publicKey.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CertificateException(e);
        }
        try {
            byte[] pubKeyData = this.signatureAlgorithmFormat == 3 && publicKey.getAlgorithm().compareTo("DSA") == 0 ? publicKey.getKeyData("DSAPublicKeyX957BER")[0] : publicKey.getKeyData(publicKey.getAlgorithm() + "PublicKeyBER")[0];
            this.subjectPublicKeyInfo = pubKeyData;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not read the public key.");
        }
    }

    public void setSubjectPublicKey(byte[] publicKeyBER, int offset) throws CertificateException {
        if (publicKeyBER == null) {
            throw new CertificateException("Public key encoding is null.");
        }
        try {
            String device = this.theCertJ != null ? this.theCertJ.getDevice() : DEFAULT_DEVICE;
            this.setSubjectPublicKey(JSAFEFactory.getPublicKey(publicKeyBER, offset, device, this.theCertJ));
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not read the public key.");
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey(String device) throws CertificateException {
        if (this.subjectPublicKey == null) {
            throw new CertificateException("Object not set with public key.");
        }
        try {
            return (JSAFE_PublicKey)this.subjectPublicKey.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CertificateException(e);
        }
    }

    public byte[] getSubjectPublicKeyBER() throws CertificateException {
        if (this.subjectPublicKeyInfo == null) {
            throw new CertificateException("Object not set with public key.");
        }
        return (byte[])this.subjectPublicKeyInfo.clone();
    }

    public byte[] getUniqueID() {
        try {
            JSAFE_PublicKey pubKey = this.getSubjectPublicKey(DEFAULT_DEVICE);
            byte[][] keyData = pubKey.getKeyData();
            JSAFE_MessageDigest digest = JSAFEFactory.getDigest("MD5", DEFAULT_DEVICE, this.theCertJ);
            digest.digestInit();
            for (int i = 0; i < keyData.length; ++i) {
                digest.digestUpdate(keyData[i], 0, keyData[i].length);
            }
            return digest.digestFinal();
        }
        catch (JSAFE_Exception jsafeExc) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public abstract void signCertificate(String var1, String var2, JSAFE_PrivateKey var3, SecureRandom var4) throws CertificateException;

    public void signCertificate(byte[] signatureAlgorithmBER, int offset, String device, JSAFE_PrivateKey signingKey, SecureRandom random) throws CertificateException {
        if (signatureAlgorithmBER == null || device == null || signingKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            int len = 1 + ASN1Lengths.determineLengthLen((byte[])signatureAlgorithmBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])signatureAlgorithmBER, (int)(offset + 1));
            String transformation = OIDList.getTrans((byte[])signatureAlgorithmBER, (int)offset, (int)len, (int)1);
            this.signCertificate(transformation, device, signingKey, random);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot sign cert:", (Exception)((Object)asnException));
        }
    }

    public abstract boolean verifyCertificateSignature(String var1, JSAFE_PublicKey var2, SecureRandom var3) throws CertificateException;

    public boolean verifyCertificateSignature(String device, byte[] verifyingKeyBER, int offset, SecureRandom random) throws CertificateException {
        if (device == null || verifyingKeyBER == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            JSAFE_PublicKey verifyingKey = JSAFEFactory.getPublicKey(verifyingKeyBER, offset, device, this.theCertJ);
            return this.verifyCertificateSignature(device, verifyingKey, random);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Cannot verify: ", (Exception)((Object)jsafeException));
        }
    }

    public boolean verifyCertificateSignature(String device, Certificate signerCert, SecureRandom random) throws CertificateException {
        if (device == null || signerCert == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_PublicKey verifyingKey = signerCert.getSubjectPublicKey(device);
        return this.verifyCertificateSignature(device, verifyingKey, random);
    }

    protected byte[] performSignature(String transformation, String device, JSAFE_PrivateKey signingKey, SecureRandom random, byte[] dataToSign, int offset, int len) throws CertificateException {
        if (transformation == null || device == null || signingKey == null || dataToSign == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature signer = null;
        try {
            signer = JSAFEFactory.getSignature(transformation, device, this.theCertJ);
            if (this.theCertJ == null) {
                signer.signInit(signingKey, null, random, null);
            } else {
                signer.signInit(signingKey, null, random, this.theCertJ.getPKCS11Sessions());
            }
            signer.signUpdate(dataToSign, offset, len);
            byte[] byArray = signer.signFinal();
            return byArray;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not sign the certificate: ", (Exception)((Object)jsafeException));
        }
        finally {
            if (signer != null) {
                signer.clearSensitiveData();
            }
        }
    }

    protected boolean performSignatureVerification(String device, JSAFE_PublicKey verifyingKey, SecureRandom random, byte[] dataToVerify, int dataOffset, int dataLen, byte[] signatureData, int sigOffset, int sigLen) throws CertificateException {
        if (device == null || verifyingKey == null || dataToVerify == null || signatureData == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature verifier = null;
        try {
            verifier = JSAFEFactory.getSignature(this.signatureAlgorithmBER, 0, device, this.theCertJ);
            if (this.theCertJ == null) {
                verifier.verifyInit(verifyingKey, null, random, null);
            } else {
                verifier.verifyInit(verifyingKey, null, random, this.theCertJ.getPKCS11Sessions());
            }
            verifier.verifyUpdate(dataToVerify, dataOffset, dataLen);
            boolean bl = verifier.verifyFinal(signatureData, sigOffset, sigLen);
            return bl;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not verify the certificate: ", (Exception)((Object)jsafeException));
        }
        finally {
            if (verifier != null) {
                verifier.clearSensitiveData();
            }
        }
    }

    protected void clearSignature() {
        this.signature = null;
    }

    protected void clearComponents() {
        this.clearSignature();
        this.signatureAlgorithmBER = null;
        this.subjectPublicKeyInfo = null;
        if (this.subjectPublicKey != null) {
            this.subjectPublicKey.clearSensitiveData();
        }
        this.subjectPublicKey = null;
    }
}

