/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class X500Name
implements Cloneable,
Serializable {
    private Vector<RDN> rdnList = new Vector();
    protected int special;
    protected ASN1Template asn1Template;

    public X500Name(byte[] nameBER, int offset, int special) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer sequenceOfContainer = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12544));
            ASN1Container[] nameDef = new ASN1Container[]{sequenceOfContainer};
            ASN1.berDecode((byte[])nameBER, (int)offset, (ASN1Container[])nameDef);
            int rdnCount = sequenceOfContainer.getContainerCount();
            for (int rdnIndex = 0; rdnIndex < rdnCount; ++rdnIndex) {
                ASN1Container encodedRDNcontainer = sequenceOfContainer.containerAt(rdnIndex);
                RDN newRdn = new RDN(encodedRDNcontainer.data, encodedRDNcontainer.dataOffset, 0);
                this.rdnList.addElement(newRdn);
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the name.", (Exception)((Object)asnException));
        }
    }

    public X500Name() {
    }

    public X500Name(String nameString) throws NameException {
        this.createX500Name(nameString, 0);
    }

    public X500Name(String nameString, int encoding) throws NameException {
        this.createX500Name(nameString, encoding);
    }

    private void createX500Name(String nameString, int encoding) throws NameException {
        String rdnToken;
        int i;
        if (nameString == null) {
            throw new NameException("The string is null.");
        }
        if (encoding != 0 && encoding != 3072 && encoding != 4864 && encoding != 5120 && encoding != 5632 && encoding != 7168 && encoding != 7680) {
            throw new NameException("The ASN.1 string encoding type is invalid.");
        }
        StringTokenizer parser = new StringTokenizer(nameString, "\\,;", true);
        int count = parser.countTokens();
        StringBuffer rdnBuffer = new StringBuffer();
        ArrayList<String> rdnString = new ArrayList<String>();
        for (i = 0; i < count; ++i) {
            rdnToken = parser.nextToken();
            if (rdnToken.equals("\\")) {
                rdnBuffer.append(rdnToken);
                rdnBuffer.append(parser.nextToken());
                ++i;
                continue;
            }
            if (!rdnToken.equals(",") && !rdnToken.equals(";")) {
                rdnBuffer.append(rdnToken);
                continue;
            }
            String nextRdn = parser.nextToken();
            ++i;
            if (nextRdn.indexOf("=") == -1) {
                rdnBuffer.append(",");
                rdnBuffer.append(nextRdn);
                continue;
            }
            nextRdn = nextRdn.trim();
            rdnString.add(rdnBuffer.toString());
            rdnBuffer = new StringBuffer(nextRdn);
        }
        if (rdnBuffer.length() != 0) {
            rdnString.add(rdnBuffer.toString());
        }
        for (i = rdnString.size() - 1; i >= 0; --i) {
            rdnToken = (String)rdnString.get(i);
            this.rdnList.addElement(new RDN(rdnToken, encoding));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        X500Name otherSelf = new X500Name();
        for (int rdnIndex = 0; rdnIndex < this.rdnList.size(); ++rdnIndex) {
            RDN rdn = this.rdnList.elementAt(rdnIndex);
            otherSelf.rdnList.addElement((RDN)rdn.clone());
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }

    private String toString(boolean reverse, boolean unicode) {
        StringBuffer buffer = new StringBuffer();
        if (this.rdnList.isEmpty()) {
            return "";
        }
        if (reverse) {
            for (int rdnIndex = this.rdnList.size() - 1; rdnIndex >= 1; --rdnIndex) {
                RDN rdn = this.rdnList.elementAt(rdnIndex);
                buffer.append(rdn.toString(unicode));
                buffer.append(",");
            }
            RDN rdn1 = this.rdnList.elementAt(0);
            buffer.append(rdn1.toString(unicode));
        } else {
            for (int rdnIndex = 0; rdnIndex < this.rdnList.size() - 1; ++rdnIndex) {
                RDN rdn = this.rdnList.elementAt(rdnIndex);
                buffer.append(rdn.toString(unicode));
                buffer.append(",");
            }
            RDN rdn1 = this.rdnList.elementAt(this.rdnList.size() - 1);
            buffer.append(rdn1.toString(unicode));
        }
        return buffer.toString();
    }

    public String toString(boolean reverse) {
        return this.toString(reverse, false);
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toStringRFC2253() {
        return this.toString(true, false);
    }

    public int getRDNCount() {
        return this.rdnList.size();
    }

    public int getAttributeCount() {
        int rdnCount = 0;
        for (int rdnIndex = 0; rdnIndex < this.rdnList.size(); ++rdnIndex) {
            rdnCount += this.rdnList.elementAt(rdnIndex).getAttributeCount();
        }
        return rdnCount;
    }

    public RDN getRDN(int index) throws NameException {
        int rdnCount = this.rdnList.size();
        if (index >= 0 && rdnCount > index) {
            return this.rdnList.elementAt(index);
        }
        throw new NameException("Invalid Index.");
    }

    public void removeRDN(int index) throws NameException {
        if (index >= this.rdnList.size()) {
            throw new NameException("Invalid index.");
        }
        this.rdnList.removeElementAt(index);
    }

    public void addRDN(RDN name, int index) throws NameException {
        if (name == null) {
            throw new NameException("Specified RDN is null.");
        }
        if (index >= this.rdnList.size()) {
            throw new NameException("Invalid index.");
        }
        this.rdnList.setElementAt(name, index);
    }

    public AttributeValueAssertion getAttribute(int attributeType) {
        int rdnCount = this.rdnList.size();
        for (int index = 0; index < rdnCount; ++index) {
            RDN rdn = this.rdnList.elementAt(index);
            AttributeValueAssertion returnAVA = rdn.getAttribute(attributeType);
            if (returnAVA == null) continue;
            return returnAVA;
        }
        return null;
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || special != this.special) {
                this.getDERLen(special);
                if (this.asn1Template == null) {
                    throw new NameException("Unable to encode X500Name.");
                }
            }
            int totalLen = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode X500Name.", (Exception)((Object)asnException));
        }
    }

    private int derEncodeInit() {
        try {
            OfContainer sequenceOf;
            int rdnCount = this.rdnList.size();
            if (rdnCount == 0) {
                sequenceOf = new OfContainer(this.special, false, 0, 12288, (ASN1Container)new EncodedContainer(12544));
            } else {
                sequenceOf = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12544));
                for (int rdnIndex = 0; rdnIndex < rdnCount; ++rdnIndex) {
                    RDN nextRDN = this.rdnList.elementAt(rdnIndex);
                    byte[] rdnBER = new byte[nextRDN.getDERLen(0)];
                    int rdnLen = nextRDN.getDEREncoding(rdnBER, 0, 0);
                    EncodedContainer setOfEncoded = new EncodedContainer(12544, true, 0, rdnBER, 0, rdnLen);
                    sequenceOf.addContainer((ASN1Container)setOfEncoded);
                }
            }
            ASN1Container[] asn1Def = new ASN1Container[]{sequenceOf};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public void addRDN(RDN rdn) throws NameException {
        if (rdn == null) {
            throw new NameException("Specified RDN is null.");
        }
        this.rdnList.addElement(rdn);
    }

    public void addRDN(byte[] rdnBER, int offset) throws NameException {
        if (rdnBER == null) {
            throw new NameException("Encoding is null.");
        }
        RDN rdn = new RDN(rdnBER, offset, 0);
        this.rdnList.addElement(rdn);
    }

    public boolean equals(Object obj) {
        int otherRDNs;
        if (obj == null || !(obj instanceof X500Name)) {
            return false;
        }
        X500Name other = (X500Name)obj;
        int thisRDNs = this.getRDNCount();
        if (thisRDNs != (otherRDNs = other.getRDNCount())) {
            return false;
        }
        for (int rdnIndex = 0; rdnIndex < thisRDNs; ++rdnIndex) {
            if (this.rdnList.elementAt(rdnIndex).equals(other.rdnList.elementAt(rdnIndex))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int rdnIndex = 0; rdnIndex < this.getRDNCount(); ++rdnIndex) {
            result ^= this.rdnList.elementAt(rdnIndex).hashCode();
            result *= 17;
        }
        return result;
    }

    public boolean contains(X500Name name) {
        if (name == null) {
            return false;
        }
        int thisRDNs = this.getRDNCount();
        int otherRDNs = name.getRDNCount();
        for (int otherIndex = 0; otherIndex < otherRDNs; ++otherIndex) {
            int thisIndex;
            RDN foundRDN = name.rdnList.elementAt(otherIndex);
            for (thisIndex = 0; thisIndex < thisRDNs && !foundRDN.equals(this.rdnList.elementAt(thisIndex)); ++thisIndex) {
            }
            if (thisIndex >= thisRDNs) {
                return false;
            }
            if (foundRDN.equals(this.rdnList.elementAt(thisIndex))) continue;
            return false;
        }
        return true;
    }
}

