/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Arrays;

public class ContentType
extends X501Attribute {
    private byte[] type;
    ASN1Template asn1TemplateValue;

    public ContentType() {
        super(14, "ContentType");
    }

    public ContentType(byte[] type, int offset, int len) {
        this();
        this.setContentType(type, offset, len);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            OIDContainer typeValue = new OIDContainer(0x1000000);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, typeValue, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.type = new byte[typeValue.dataLen];
            System.arraycopy(typeValue.data, typeValue.dataOffset, this.type, 0, typeValue.dataLen);
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode ContentType.");
        }
    }

    public void setContentType(byte[] theType, int offset, int len) {
        if (theType != null && len != 0) {
            this.type = new byte[len];
            System.arraycopy(theType, offset, this.type, 0, len);
        }
    }

    public byte[] getContentType() {
        if (this.type == null) {
            return null;
        }
        byte[] returnType = new byte[this.type.length];
        System.arraycopy(this.type, 0, returnType, 0, this.type.length);
        return returnType;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        int typeLen = 0;
        if (this.type != null) {
            typeLen = this.type.length;
        }
        try {
            SetContainer aSet = new SetContainer(0, true, 0);
            OIDContainer typeValue = new OIDContainer(0x1000000, true, 0, this.type, 0, typeLen);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, typeValue, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ContentType otherSelf = new ContentType();
        if (this.type != null) {
            otherSelf.type = new byte[this.type.length];
            System.arraycopy(this.type, 0, otherSelf.type, 0, this.type.length);
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ContentType)) {
            return false;
        }
        ContentType other = (ContentType)obj;
        return CertJUtils.byteArraysEqual(other.type, this.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + Arrays.hashCode(this.type);
        return result;
    }

    protected void reset() {
        super.reset();
        this.type = null;
        this.asn1TemplateValue = null;
    }
}

