/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Date;

public class DateOfBirth
extends X501Attribute {
    private Date theDate;
    ASN1Template asn1TemplateValue;

    public DateOfBirth() {
        super(18, "dateOfBirth");
    }

    public DateOfBirth(Date theDate) {
        this();
        this.setDateOfBirth(theDate);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        SetContainer aSet = new SetContainer(0);
        EndContainer anEnd = new EndContainer();
        GenTimeContainer localDate = new GenTimeContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSet, localDate, anEnd};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode DateOfBirth.", (Exception)((Object)asnException));
        }
        this.theDate = new Date(localDate.theTime.getTime());
    }

    public void setDateOfBirth(Date theDate) {
        if (theDate != null) {
            this.reset();
            this.theDate = new Date(theDate.getTime());
        }
    }

    public Date getDateOfBirth() {
        if (this.theDate == null) {
            return null;
        }
        return new Date(this.theDate.getTime());
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.theDate == null) {
            return 0;
        }
        SetContainer aSet = new SetContainer(0, true, 0);
        GenTimeContainer theTime = new GenTimeContainer(0, true, 0, this.theDate);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[]{aSet, theTime, anEnd};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DateOfBirth otherSelf = new DateOfBirth();
        if (this.theDate != null) {
            otherSelf.theDate = new Date(this.theDate.getTime());
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DateOfBirth)) {
            return false;
        }
        DateOfBirth other = (DateOfBirth)obj;
        if (this.theDate == null) {
            return other.theDate == null;
        }
        if (other.theDate == null) {
            return false;
        }
        return this.theDate.equals(other.theDate);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.theDate);
        return result;
    }

    protected void reset() {
        super.reset();
        this.theDate = null;
        this.asn1TemplateValue = null;
    }
}

