/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;

public class FriendlyName
extends X501Attribute {
    private String friendlyName = "";
    ASN1Template asn1TemplateValue;

    public FriendlyName() {
        super(3, "FriendlyName");
    }

    public FriendlyName(String name) {
        this();
        this.setFriendlyName(name);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            BMPStringContainer theName = new BMPStringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, theName, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.friendlyName = theName.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode FriendlyName.");
        }
    }

    public void setFriendlyName(String theName) {
        if (theName != null) {
            this.reset();
            this.friendlyName = theName;
        }
    }

    public String getFriendlyName() {
        if (this.friendlyName == null) {
            return null;
        }
        return this.friendlyName;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.friendlyName == null) {
            return 0;
        }
        try {
            SetContainer aSet = new SetContainer(0, true, 0);
            BMPStringContainer bmp = new BMPStringContainer(0, true, 0, this.friendlyName);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, bmp, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FriendlyName otherSelf = new FriendlyName();
        if (this.friendlyName != null) {
            otherSelf.friendlyName = this.friendlyName;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FriendlyName)) {
            return false;
        }
        FriendlyName other = (FriendlyName)obj;
        return this.friendlyName.equals(other.friendlyName);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.friendlyName);
        return result;
    }

    protected void reset() {
        super.reset();
        this.friendlyName = null;
        this.asn1TemplateValue = null;
    }
}

