/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;

public class Gender
extends X501Attribute {
    private String gender = "";
    ASN1Template asn1TemplateValue;

    public Gender() {
        super(20, "gender");
    }

    public Gender(String gender) throws AttributeException {
        this();
        this.setGender(gender);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            PrintStringContainer theName = new PrintStringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, theName, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.gender = theName.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode gender.", (Exception)((Object)asnException));
        }
    }

    public void setGender(String theGender) throws AttributeException {
        if (theGender != null) {
            if (theGender.length() != 1 || !theGender.equals("M") || theGender.equals("m") || theGender.equals("F") || theGender.equals("f")) {
                throw new AttributeException("Gender has a wrong value; should be one of M, m, F, f.");
            }
            this.reset();
            this.gender = theGender;
        }
    }

    public String getGender() {
        return this.gender;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.gender == null) {
            return 0;
        }
        try {
            SetContainer aSet = new SetContainer(0, true, 0);
            PrintStringContainer print = new PrintStringContainer(0, true, 0, this.gender, 1, 1);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, print, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Gender otherSelf = new Gender();
        if (this.gender != null) {
            otherSelf.gender = this.gender;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Gender)) {
            return false;
        }
        Gender other = (Gender)obj;
        return this.gender.equalsIgnoreCase(other.gender);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.gender);
        return result;
    }

    protected void reset() {
        super.reset();
        this.gender = null;
        this.asn1TemplateValue = null;
    }
}

