/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Arrays;

public class LocalKeyID
extends X501Attribute {
    private byte[] localKeyID;
    ASN1Template asn1TemplateValue;

    public LocalKeyID() {
        super(4, "LocalKeyID");
    }

    public LocalKeyID(byte[] keyID, int offset, int len) {
        this();
        this.setLocalKeyID(keyID, offset, len);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        SetContainer aSet = new SetContainer(0);
        EndContainer anEnd = new EndContainer();
        OctetStringContainer theKeyID = new OctetStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSet, theKeyID, anEnd};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode LocalKeyID.");
        }
        this.localKeyID = new byte[theKeyID.dataLen];
        System.arraycopy(theKeyID.data, theKeyID.dataOffset, this.localKeyID, 0, theKeyID.dataLen);
    }

    public byte[] getLocalKeyID() {
        if (this.localKeyID == null) {
            return null;
        }
        byte[] returnValue = new byte[this.localKeyID.length];
        System.arraycopy(this.localKeyID, 0, returnValue, 0, this.localKeyID.length);
        return returnValue;
    }

    public void setLocalKeyID(byte[] keyID, int offset, int len) {
        if (keyID != null && len != 0) {
            this.localKeyID = new byte[len];
            System.arraycopy(keyID, offset, this.localKeyID, 0, len);
        }
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.localKeyID == null) {
            return 0;
        }
        try {
            EndContainer anEnd = new EndContainer();
            SetContainer aSet = new SetContainer(0, true, 0);
            OctetStringContainer octet = new OctetStringContainer(0, true, 0, this.localKeyID, 0, this.localKeyID.length);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, octet, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LocalKeyID otherSelf = new LocalKeyID();
        if (this.localKeyID != null) {
            otherSelf.localKeyID = (byte[])this.localKeyID.clone();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalKeyID)) {
            return false;
        }
        LocalKeyID other = (LocalKeyID)obj;
        return CertJUtils.byteArraysEqual(other.localKeyID, this.localKeyID);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + Arrays.hashCode(this.localKeyID);
        return result;
    }

    protected void reset() {
        super.reset();
        this.asn1TemplateValue = null;
        if (this.localKeyID != null) {
            for (int index = 0; index < this.localKeyID.length; ++index) {
                this.localKeyID[index] = 0;
            }
            this.localKeyID = null;
        }
    }
}

