/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Date;

public class SigningTime
extends X501Attribute {
    private Date signingTime;
    ASN1Template asn1TemplateValue;

    public SigningTime() {
        super(0, "SigningTime");
    }

    public SigningTime(Date theTime) {
        this();
        this.setSigningTime(theTime);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        SetContainer aSet = new SetContainer(0);
        EndContainer anEnd = new EndContainer();
        UTCTimeContainer theTime = new UTCTimeContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSet, theTime, anEnd};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode SigningTime.");
        }
        this.signingTime = new Date(theTime.theTime.getTime());
    }

    public void setSigningTime(Date theTime) {
        if (theTime != null) {
            this.reset();
            this.signingTime = new Date(theTime.getTime());
        }
    }

    public Date getSigningTime() {
        if (this.signingTime == null) {
            return null;
        }
        return new Date(this.signingTime.getTime());
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.signingTime == null) {
            return 0;
        }
        SetContainer aSet = new SetContainer(0, true, 0);
        UTCTimeContainer theTime = new UTCTimeContainer(0, true, 0, this.signingTime);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[]{aSet, theTime, anEnd};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SigningTime otherSelf = new SigningTime();
        if (this.signingTime != null) {
            otherSelf.signingTime = new Date(this.signingTime.getTime());
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SigningTime)) {
            return false;
        }
        SigningTime other = (SigningTime)obj;
        if (this.signingTime == null) {
            return other.signingTime == null;
        }
        if (other.signingTime == null) {
            return false;
        }
        return this.signingTime.equals(other.signingTime);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.signingTime);
        return result;
    }

    protected void reset() {
        super.reset();
        this.signingTime = null;
        this.asn1TemplateValue = null;
    }
}

