/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.attributes.X501Attribute;

public class V3ExtensionAttribute
extends X501Attribute {
    private X509V3Extensions theExtensions;
    ASN1Template asn1TemplateValue;

    public V3ExtensionAttribute() {
        super(2, "V3ExtensionAttribute");
    }

    public V3ExtensionAttribute(X509V3Extensions extensionsObject) {
        this();
        this.setV3ExtensionAttribute(extensionsObject);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer value = new EncodedContainer(12288);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, value, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.theExtensions = new X509V3Extensions(value.data, value.dataOffset, 0, 1);
        }
        catch (ASN_Exception asnException) {
            this.reset();
            throw new AttributeException("Could not BER decode V3ExtensionAttribute.");
        }
        catch (CertificateException extensionException) {
            this.reset();
            throw new AttributeException("Could not create the attribute object: ", extensionException);
        }
    }

    public void setV3ExtensionAttribute(X509V3Extensions extensionsObject) {
        try {
            if (extensionsObject != null) {
                this.theExtensions = (X509V3Extensions)extensionsObject.clone();
            }
        }
        catch (CloneNotSupportedException cloneException) {
            this.theExtensions = null;
        }
    }

    public X509V3Extensions getV3ExtensionAttribute() {
        if (this.theExtensions == null) {
            return null;
        }
        try {
            return (X509V3Extensions)this.theExtensions.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.theExtensions == null) {
            return 0;
        }
        int valueLen = this.theExtensions.getDERLen(0);
        try {
            EndContainer anEnd = new EndContainer();
            SetContainer aSet = new SetContainer(0, true, 0);
            EncodedContainer theValue = new EncodedContainer(12288, true, 0, null, 0, valueLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, theValue, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        int totalLen;
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
        totalLen += this.theExtensions.getDEREncoding(encoding, offset + totalLen, 0);
        return totalLen;
    }

    public Object clone() throws CloneNotSupportedException {
        V3ExtensionAttribute otherSelf = new V3ExtensionAttribute();
        try {
            if (this.theExtensions != null) {
                otherSelf.theExtensions = (X509V3Extensions)this.theExtensions.clone();
            }
        }
        catch (CloneNotSupportedException cloneException) {
            otherSelf.theExtensions = null;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof V3ExtensionAttribute)) {
            return false;
        }
        V3ExtensionAttribute other = (V3ExtensionAttribute)obj;
        if (this.theExtensions != null) {
            int otherLen;
            if (other.theExtensions == null) return false;
            int thisLen = this.theExtensions.getDERLen(0);
            if (thisLen != (otherLen = other.theExtensions.getDERLen(0))) {
                return false;
            }
            byte[] thisData = new byte[thisLen];
            byte[] otherData = new byte[otherLen];
            thisLen = this.theExtensions.getDEREncoding(thisData, 0, 0);
            otherLen = other.theExtensions.getDEREncoding(otherData, 0, 0);
            if (CertJUtils.byteArraysEqual(thisData, otherData)) return true;
            return false;
        }
        if (other.theExtensions == null) return true;
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + CertJInternalHelper.hashCodeValue(this.theExtensions);
        return result;
    }

    protected void reset() {
        super.reset();
        this.theExtensions = null;
        this.asn1TemplateValue = null;
    }
}

