/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;

public class VeriSignCRSDualEnrollmentStatus
extends X501Attribute {
    private int status = -1;
    ASN1Template asn1TemplateValue;

    public VeriSignCRSDualEnrollmentStatus() {
        super(13, "VeriSignCRSDualEnrollmentStatus");
    }

    public VeriSignCRSDualEnrollmentStatus(int status) {
        this();
        this.setEnrollmentStatus(status);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            IntegerContainer crsStatus = new IntegerContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, crsStatus, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.status = crsStatus.getValueAsInt();
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode VeriSignCRSDualEnrollmentStatus.");
        }
    }

    public void setEnrollmentStatus(int status) {
        this.reset();
        if (status >= 0) {
            this.status = status;
        }
    }

    public int getEnrollmentStatus() {
        return this.status;
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        if (this.status == -1) {
            return 0;
        }
        SetContainer aSet = new SetContainer(0, true, 0);
        IntegerContainer crsStatus = new IntegerContainer(0, true, 0, this.status);
        EndContainer anEnd = new EndContainer();
        ASN1Container[] asn1Def = new ASN1Container[]{aSet, crsStatus, anEnd};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignCRSDualEnrollmentStatus otherSelf = new VeriSignCRSDualEnrollmentStatus();
        if (this.status != -1) {
            otherSelf.status = this.status;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VeriSignCRSDualEnrollmentStatus)) {
            return false;
        }
        VeriSignCRSDualEnrollmentStatus other = (VeriSignCRSDualEnrollmentStatus)obj;
        return other.status == this.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + this.status;
        return result;
    }

    protected void reset() {
        super.reset();
        this.status = -1;
        this.asn1TemplateValue = null;
    }
}

