/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.util.Arrays;

public class VeriSignCRSSenderNonce
extends X501Attribute {
    private byte[] nonce;
    ASN1Template asn1TemplateValue;

    public VeriSignCRSSenderNonce() {
        super(9, "VeriSignCRSSenderNonce");
    }

    public VeriSignCRSSenderNonce(byte[] nonce, int offset, int len) {
        this();
        this.setSenderNonce(nonce, offset, len);
    }

    protected void decodeValue(byte[] valueBER, int offset) throws AttributeException {
        if (valueBER == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer aSet = new SetContainer(0);
            EndContainer anEnd = new EndContainer();
            OctetStringContainer octet = new OctetStringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, octet, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (octet.dataLen > 0) {
                this.nonce = new byte[octet.dataLen];
                System.arraycopy(octet.data, octet.dataOffset, this.nonce, 0, octet.dataLen);
            }
        }
        catch (ASN_Exception asnException) {
            throw new AttributeException("Could not BER decode VeriSignCRSSenderNonce.");
        }
    }

    public void setSenderNonce(byte[] nonce, int offset, int len) {
        this.reset();
        if (nonce != null && len != 0) {
            this.nonce = new byte[len];
            System.arraycopy(nonce, offset, this.nonce, 0, len);
        }
    }

    public byte[] getSenderNonce() {
        if (this.nonce == null) {
            return null;
        }
        return (byte[])this.nonce.clone();
    }

    protected int derEncodeValueInit() {
        this.asn1TemplateValue = null;
        int nonceLen = 0;
        if (this.nonce != null) {
            nonceLen = this.nonce.length;
        }
        try {
            SetContainer aSet = new SetContainer(0, true, 0);
            OctetStringContainer octet = new OctetStringContainer(0, true, 0, this.nonce, 0, nonceLen);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{aSet, octet, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignCRSSenderNonce otherSelf = new VeriSignCRSSenderNonce();
        if (this.nonce != null) {
            otherSelf.nonce = (byte[])this.nonce.clone();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VeriSignCRSSenderNonce)) {
            return false;
        }
        VeriSignCRSSenderNonce other = (VeriSignCRSSenderNonce)obj;
        return CertJUtils.byteArraysEqual(other.nonce, this.nonce);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + Arrays.hashCode(this.nonce);
        return result;
    }

    protected void reset() {
        super.reset();
        this.nonce = null;
        this.asn1TemplateValue = null;
    }
}

