/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Date;

public class ArchiveCutoff
extends X509V3Extension
implements OCSPSingleExtension {
    private Date archiveCutoffTime;
    ASN1Template asn1TemplateValue;

    public ArchiveCutoff() {
        this.extensionTypeFlag = 118;
        this.criticality = false;
        this.setSpecialOID(ARCHIVE_CUTOFF_OID);
        this.extensionTypeString = "ArchiveCutoff";
    }

    public ArchiveCutoff(Date archiveCutoffDate) {
        this.extensionTypeFlag = 118;
        this.criticality = false;
        this.setSpecialOID(ARCHIVE_CUTOFF_OID);
        this.extensionTypeString = "ArchiveCutoff";
        if (archiveCutoffDate != null) {
            this.archiveCutoffTime = new Date(archiveCutoffDate.getTime());
        }
    }

    public int derEncodeValueInit() {
        GenTimeContainer dateValue = new GenTimeContainer(0, true, 0, this.archiveCutoffTime);
        ASN1Container[] asn1Def = new ASN1Container[]{dateValue};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        GenTimeContainer dateValue = new GenTimeContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{dateValue};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode ArchiveCutoff extension.");
        }
        this.archiveCutoffTime = dateValue.theTime;
    }

    public Date getArchiveCutoffDate() {
        return this.archiveCutoffTime;
    }

    public void setArchiveCutoffDate(Date archiveCutoffDate) {
        if (archiveCutoffDate != null) {
            this.archiveCutoffTime = new Date(archiveCutoffDate.getTime());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ArchiveCutoff otherSelf = new ArchiveCutoff();
        if (this.archiveCutoffTime != null) {
            otherSelf.archiveCutoffTime = new Date(this.archiveCutoffTime.getTime());
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }
}

