/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class AuthorityKeyID
extends X509V3Extension
implements CertExtension,
CRLExtension {
    ASN1Template asn1TemplateValue;
    private byte[] keyID;
    private static final int KEY_SPECIAL = 0x810000;
    private GeneralNames authorityCertIssuer;
    private static final int ISSUER_SPECIAL = 0x810001;
    private byte[] serialNumber;
    private static final int NUMBER_SPECIAL = 8454146;

    public AuthorityKeyID() {
        this.extensionTypeFlag = 35;
        this.criticality = false;
        this.authorityCertIssuer = new GeneralNames();
        this.setStandardOID(35);
        this.extensionTypeString = "AuthorityKeyID";
    }

    public AuthorityKeyID(GeneralNames authorityCertIssuer, byte[] serialNumber, int numberOffset, int numberLen, byte[] keyID, int keyOffset, int keyLen, boolean criticality) {
        this.extensionTypeFlag = 35;
        this.criticality = criticality;
        this.setStandardOID(35);
        this.extensionTypeString = "AuthorityKeyID";
        if (keyID != null && keyLen != 0) {
            this.keyID = new byte[keyLen];
            System.arraycopy(keyID, keyOffset, this.keyID, 0, keyLen);
        }
        if (authorityCertIssuer != null) {
            this.authorityCertIssuer = authorityCertIssuer;
        }
        if (serialNumber != null && numberLen != 0) {
            this.serialNumber = new byte[numberLen];
            System.arraycopy(serialNumber, numberOffset, this.serialNumber, 0, numberLen);
        }
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        EncodedContainer issuer;
        IntegerContainer localSerialNumber;
        OctetStringContainer idValue;
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            idValue = new OctetStringContainer(0x810000);
            localSerialNumber = new IntegerContainer(8454146);
            issuer = new EncodedContainer(8466433);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, idValue, issuer, localSerialNumber, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode AuthorityKeyID extension.");
        }
        try {
            if (idValue.dataPresent && idValue.dataLen != 0 && idValue.data != null) {
                this.keyID = new byte[idValue.dataLen];
                System.arraycopy(idValue.data, idValue.dataOffset, this.keyID, 0, idValue.dataLen);
            }
            if (issuer.dataPresent && localSerialNumber.dataPresent) {
                this.authorityCertIssuer = new GeneralNames(issuer.data, issuer.dataOffset, 0x810001);
                this.serialNumber = new byte[localSerialNumber.dataLen];
                System.arraycopy(localSerialNumber.data, localSerialNumber.dataOffset, this.serialNumber, 0, localSerialNumber.dataLen);
            }
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode AuthorityKeyID extension!!!.");
        }
    }

    public void setKeyID(byte[] keyID, int offset, int len) {
        if (keyID != null && len != 0) {
            this.keyID = new byte[len];
            System.arraycopy(keyID, offset, this.keyID, 0, len);
        }
    }

    public void setAuthorityCertIssuer(GeneralNames issuer) {
        if (issuer != null) {
            this.authorityCertIssuer = issuer;
        }
    }

    public void setSerialNumber(byte[] number, int offset, int len) {
        if (number != null && len != 0) {
            this.serialNumber = new byte[len];
            System.arraycopy(number, offset, this.serialNumber, 0, len);
        }
    }

    public byte[] getKeyID() {
        if (this.keyID == null) {
            return null;
        }
        byte[] returnValue = new byte[this.keyID.length];
        System.arraycopy(this.keyID, 0, returnValue, 0, this.keyID.length);
        return returnValue;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.authorityCertIssuer;
    }

    public byte[] getSerialNumber() {
        if (this.serialNumber == null) {
            return null;
        }
        byte[] returnValue = new byte[this.serialNumber.length];
        System.arraycopy(this.serialNumber, 0, returnValue, 0, this.serialNumber.length);
        return returnValue;
    }

    public int derEncodeValueInit() {
        try {
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            OctetStringContainer idValue = null;
            IntegerContainer numberContainer = null;
            EncodedContainer issuer = null;
            int flag = 0;
            if (this.keyID != null) {
                idValue = new OctetStringContainer(0x810000, true, 0, this.keyID, 0, this.keyID.length);
                flag = 1;
            }
            if (this.authorityCertIssuer != null && this.serialNumber != null) {
                numberContainer = new IntegerContainer(8454146, true, 0, this.serialNumber, 0, this.serialNumber.length, true);
                try {
                    int nameDERLen = this.authorityCertIssuer.getDERLen(0x810001);
                    byte[] nameDER = new byte[nameDERLen];
                    int offset = 0;
                    int returnLen = this.authorityCertIssuer.getDEREncoding(nameDER, offset, 0x810001);
                    issuer = new EncodedContainer(8466433, true, 0, nameDER, offset, returnLen);
                }
                catch (NameException nameException) {
                    return 0;
                }
                flag = flag == 1 ? 3 : 2;
            }
            switch (flag) {
                case 0: {
                    ASN1Container[] asn1Def0 = new ASN1Container[]{seq, anEnd};
                    this.asn1TemplateValue = new ASN1Template(asn1Def0);
                    break;
                }
                case 1: {
                    ASN1Container[] asn1Def1 = new ASN1Container[]{seq, idValue, anEnd};
                    this.asn1TemplateValue = new ASN1Template(asn1Def1);
                    break;
                }
                case 2: {
                    ASN1Container[] asn1Def2 = new ASN1Container[]{seq, issuer, numberContainer, anEnd};
                    this.asn1TemplateValue = new ASN1Template(asn1Def2);
                    break;
                }
                case 3: {
                    ASN1Container[] asn1Def3 = new ASN1Container[]{seq, idValue, issuer, numberContainer, anEnd};
                    this.asn1TemplateValue = new ASN1Template(asn1Def3);
                    break;
                }
            }
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AuthorityKeyID otherSelf = new AuthorityKeyID();
        if (this.keyID != null) {
            otherSelf.keyID = (byte[])this.keyID.clone();
        }
        if (this.authorityCertIssuer != null) {
            otherSelf.authorityCertIssuer = (GeneralNames)this.authorityCertIssuer.clone();
        }
        if (this.serialNumber != null) {
            otherSelf.serialNumber = (byte[])this.serialNumber.clone();
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.keyID = null;
        this.authorityCertIssuer = null;
        this.serialNumber = null;
        this.asn1TemplateValue = null;
    }
}

