/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class BasicConstraints
extends X509V3Extension
implements CertExtension {
    private static final String EXT_NAME = "BasicConstraints";
    private boolean cA;
    private int pathLenConstraint = -1;
    private boolean setPathLen;
    ASN1Template asn1TemplateValue;

    public BasicConstraints() {
        this.extensionTypeString = EXT_NAME;
        this.extensionTypeFlag = 19;
        this.criticality = false;
        this.setPathLen = false;
        this.setStandardOID(19);
    }

    public BasicConstraints(boolean cA, int pathLenConstraint, boolean criticality) throws CertificateException {
        this.extensionTypeString = EXT_NAME;
        this.extensionTypeFlag = 19;
        this.criticality = criticality;
        this.setPathLen = cA;
        this.setStandardOID(19);
        this.cA = cA;
        if (!cA) {
            throw new CertificateException("The pathLenConstraint shall be present only if cA is set to true.");
        }
        this.pathLenConstraint = pathLenConstraint;
    }

    public BasicConstraints(boolean criticality) throws CertificateException {
        this.extensionTypeString = EXT_NAME;
        this.extensionTypeFlag = 19;
        this.criticality = criticality;
        this.setStandardOID(19);
        this.cA = true;
        this.setPathLen = false;
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer seq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        BooleanContainer boolContainer = new BooleanContainer(131072);
        IntegerContainer intContainer = new IntegerContainer(65536);
        ASN1Container[] asn1Def = new ASN1Container[]{seq, boolContainer, intContainer, anEnd};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.cA = boolContainer.dataPresent ? boolContainer.value : false;
            this.setPathLen = false;
            if (intContainer.dataPresent && this.cA) {
                this.pathLenConstraint = intContainer.getValueAsInt();
                this.setPathLen = true;
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode BasicConstraints extension.");
        }
    }

    public void setCA(boolean cA) throws CertificateException {
        this.cA = cA;
    }

    public boolean getCA() {
        return this.cA;
    }

    public void setPathLen(int pathLenConstraint) throws CertificateException {
        if (!this.cA) {
            throw new CertificateException("The pathLenConstraint shall be present only if cA is set to true.");
        }
        this.pathLenConstraint = pathLenConstraint;
        this.setPathLen = true;
    }

    public int getPathLen() {
        return this.pathLenConstraint;
    }

    public int derEncodeValueInit() {
        ASN1Container[] asn1Def;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        BooleanContainer boolContainer = new BooleanContainer(131072, this.cA, 0, this.cA);
        if (this.cA && this.setPathLen) {
            IntegerContainer intContainer = new IntegerContainer(65536, true, 0, this.pathLenConstraint);
            asn1Def = new ASN1Container[]{seq, boolContainer, intContainer, anEnd};
        } else {
            asn1Def = new ASN1Container[]{seq, boolContainer, anEnd};
        }
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BasicConstraints otherSelf = new BasicConstraints();
        otherSelf.cA = this.cA;
        otherSelf.pathLenConstraint = this.pathLenConstraint;
        otherSelf.setPathLen = this.setPathLen;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.cA = false;
        this.pathLenConstraint = -1;
        this.asn1TemplateValue = null;
    }
}

