/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Vector;

public class BuiltInDomainDefinedAttributes
implements Cloneable,
Serializable {
    private String[][] attrData = new String[4][2];
    int attrIndex;
    private int special;
    private ASN1Template asn1Template;

    public BuiltInDomainDefinedAttributes() {
    }

    public BuiltInDomainDefinedAttributes(byte[] valueBER, int offset, int special) throws NameException {
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] nameDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            int nameCount = seqOf.getContainerCount();
            if (nameCount > 4) {
                throw new NameException("Too many BuiltInDomainDefinedAttributes: MAX number is 4.");
            }
            for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
                ASN1Container encodedNameContainer = seqOf.containerAt(nameIndex);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                PrintStringContainer type = new PrintStringContainer(0, 1, 8);
                PrintStringContainer value = new PrintStringContainer(0, 1, 128);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, type, value, anEnd};
                ASN1.berDecode((byte[])encodedNameContainer.data, (int)encodedNameContainer.dataOffset, (ASN1Container[])asn1Def);
                if (type.data == null || type.dataLen == 0 || value.data == null || value.dataLen == 0) continue;
                this.attrData[this.attrIndex][0] = type.getValueAsString();
                this.attrData[this.attrIndex][1] = value.getValueAsString();
                ++this.attrIndex;
            }
        }
        catch (Exception certException) {
            throw new NameException("Cannot decode the BER of BuiltInDomainDefinedAttributes.");
        }
    }

    public void addAttribute(String type, String value) throws NameException {
        if (type == null || value == null) {
            throw new NameException("Specified values are null.");
        }
        if (type.length() > 8 || value.length() > 128) {
            throw new NameException("Specified values are too long.");
        }
        if (this.attrIndex < 3) {
            this.attrData[this.attrIndex][0] = type;
            this.attrData[this.attrIndex][1] = value;
            ++this.attrIndex;
        } else {
            throw new NameException("Cannot add Attribute: MAX attribute number is 4.");
        }
    }

    public String[] getAttribute(int index) throws NameException {
        if (index > 3) {
            throw new NameException("Specified index is invalid.");
        }
        String[] result = new String[]{this.attrData[index][0], this.attrData[index][1]};
        return result;
    }

    public int getAttributeCount() {
        return this.attrIndex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < this.attrIndex; ++index) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.attrData[index][0]);
            buffer.append(",");
            buffer.append(this.attrData[index][1]);
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode BuiltInDomainDefinedAttributes");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode BuiltInDomainDefinedAttributes");
        }
    }

    private int derEncodeInit() throws NameException {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            Vector<OfContainer> asn1Def = new Vector<OfContainer>();
            OfContainer sequenceOfContainer = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(sequenceOfContainer);
            for (int index = 0; index < this.attrIndex; ++index) {
                try {
                    EncodedContainer attrContainer = this.encodeAttribute(index);
                    sequenceOfContainer.addContainer((ASN1Container)attrContainer);
                    continue;
                }
                catch (ASN_Exception asnException) {
                    throw new NameException("Can't encode BuiltInDomainDefinedAttributes");
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new NameException((Exception)((Object)asnException));
        }
    }

    private EncodedContainer encodeAttribute(int index) throws NameException {
        EncodedContainer next;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer end = new EndContainer();
        try {
            PrintStringContainer typeContainer = new PrintStringContainer(0, true, 0, this.attrData[index][0], 1, 8);
            PrintStringContainer valueContainer = new PrintStringContainer(0, true, 0, this.attrData[index][1], 1, 128);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, typeContainer, valueContainer, end};
            ASN1Template templ = new ASN1Template(asn1Def);
            int encodingLen = templ.derEncodeInit();
            byte[] encoding = new byte[encodingLen];
            encodingLen = templ.derEncode(encoding, 0);
            next = new EncodedContainer(12288, true, 0, encoding, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new NameException(" Can't encode BuiltInDomainDefinedAttribute");
        }
        return next;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BuiltInDomainDefinedAttributes)) {
            return false;
        }
        BuiltInDomainDefinedAttributes other = (BuiltInDomainDefinedAttributes)obj;
        if (this.attrIndex != other.attrIndex) {
            return false;
        }
        for (int index = 0; index < this.attrIndex; ++index) {
            if (!this.attrData[index][0].equals(other.attrData[index][0])) {
                return false;
            }
            if (this.attrData[index][1].equals(other.attrData[index][1])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        for (int index = 0; index < this.attrIndex; ++index) {
            hashcode ^= this.attrData[index][0].hashCode();
            hashcode ^= 17 * this.attrData[index][1].hashCode();
            hashcode *= 33;
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        BuiltInDomainDefinedAttributes otherSelf = (BuiltInDomainDefinedAttributes)super.clone();
        for (int index = 0; index < this.attrIndex; ++index) {
            otherSelf.attrData[index][0] = this.attrData[index][0];
            otherSelf.attrData[index][1] = this.attrData[index][1];
        }
        try {
            if (this.asn1Template != null) {
                otherSelf.derEncodeInit();
            }
        }
        catch (NameException nameException) {
            throw new CloneNotSupportedException("Cannot get ASN1 Template");
        }
        return otherSelf;
    }
}

