/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.NumericStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.ORName;
import com.rsa.certj.cert.extensions.PersonalName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

public class BuiltInStandardAttributes
implements Cloneable,
Serializable {
    private ORName countryName;
    private ORName adminName;
    private String networkAddress;
    private String terminalId;
    private ORName privateDomainName;
    private String organizationName;
    private String numericUserId;
    private PersonalName personalName;
    private String[] organizationUnitNames = new String[4];
    private int orgUnitIndex;
    protected int special;
    protected ASN1Template asn1Template;

    public BuiltInStandardAttributes(byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            EncodedContainer country = new EncodedContainer(0x410001);
            EncodedContainer admin = new EncodedContainer(4259842);
            NumericStringContainer network = new NumericStringContainer(0x810000, 1, 16);
            PrintStringContainer terminal = new PrintStringContainer(0x810001, 1, 24);
            EncodedContainer domain = new EncodedContainer(8454146);
            PrintStringContainer orgName = new PrintStringContainer(8454147, 1, 64);
            NumericStringContainer userId = new NumericStringContainer(8454148, 1, 32);
            EncodedContainer personal = new EncodedContainer(8466693);
            EncodedContainer orgUnit = new EncodedContainer(8466438);
            ASN1Container[] nameDef = new ASN1Container[]{seq, country, admin, network, terminal, domain, orgName, userId, personal, orgUnit, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            if (country.dataPresent) {
                this.countryName = new ORName(0, country.data, country.dataOffset, 0);
            }
            if (admin.dataPresent) {
                this.adminName = new ORName(1, admin.data, admin.dataOffset, 0);
            }
            if (network.dataPresent) {
                this.networkAddress = network.getValueAsString();
            }
            if (terminal.dataPresent) {
                this.terminalId = terminal.getValueAsString();
            }
            if (domain.dataPresent) {
                this.privateDomainName = new ORName(2, domain.data, domain.dataOffset, 8454146);
            }
            if (orgName.dataPresent) {
                this.organizationName = orgName.getValueAsString();
            }
            if (userId.dataPresent) {
                this.numericUserId = userId.getValueAsString();
            }
            if (personal.dataPresent) {
                this.personalName = new PersonalName(personal.data, personal.dataOffset, 8454149);
            }
            if (orgUnit.dataPresent) {
                OfContainer sequenceOfContainer = new OfContainer(8454150, 12288, (ASN1Container)new EncodedContainer(4864));
                ASN1Container[] asnDef = new ASN1Container[]{sequenceOfContainer};
                ASN1.berDecode((byte[])orgUnit.data, (int)orgUnit.dataOffset, (ASN1Container[])asnDef);
                int nameCount = sequenceOfContainer.getContainerCount();
                if (nameCount > 4) {
                    throw new NameException("Too many entries in OrganizationalUnitNanes: MAX number is 4.");
                }
                for (int index = 0; index < nameCount; ++index) {
                    ASN1Container nameContainer = sequenceOfContainer.containerAt(index);
                    PrintStringContainer printContainer = new PrintStringContainer(0, 1, 32);
                    ASN1Container[] nameStringDef = new ASN1Container[]{printContainer};
                    ASN1.berDecode((byte[])nameContainer.data, (int)nameContainer.dataOffset, (ASN1Container[])nameStringDef);
                    this.organizationUnitNames[this.orgUnitIndex] = printContainer.getValueAsString();
                    ++this.orgUnitIndex;
                }
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the BuiltInStandardAttributes.");
        }
    }

    public BuiltInStandardAttributes() {
    }

    public void setCountryName(ORName name) throws NameException {
        if (name == null) {
            throw new NameException("Specified value is null.");
        }
        if (name.getNameType() != 0) {
            throw new NameException("Specified value is of wrong type.");
        }
        this.countryName = name;
    }

    public void setAdminDomainName(ORName name) throws NameException {
        if (name == null) {
            throw new NameException("Specified value is null.");
        }
        if (name.getNameType() != 1) {
            throw new NameException("Specified value is of wrong type.");
        }
        this.adminName = name;
    }

    public void setNetworkAddress(String name) throws NameException {
        if (name == null) {
            throw new NameException("Specified value is null.");
        }
        if (name.length() > 16) {
            throw new NameException("Specified value is too long.");
        }
        this.networkAddress = name;
    }

    public void setTerminalIdentifier(String name) throws NameException {
        if (name == null) {
            throw new NameException("Specified value is null.");
        }
        if (name.length() > 24) {
            throw new NameException("Specified value is too long.");
        }
        this.terminalId = name;
    }

    public void setPrivateDomainName(ORName name) throws NameException {
        if (name == null) {
            throw new NameException("Specified value is null.");
        }
        if (name.getNameType() != 2) {
            throw new NameException("Specified value is of wrong type.");
        }
        this.privateDomainName = name;
    }

    public void setOrganizationName(String name) throws NameException {
        if (name == null) {
            throw new NameException("Specified value is null.");
        }
        if (name.length() > 64) {
            throw new NameException("Specified value is too long.");
        }
        this.organizationName = name;
    }

    public void setNumericUserIdentifier(String name) throws NameException {
        if (name == null) {
            throw new NameException("Specified value is null.");
        }
        if (name.length() > 32) {
            throw new NameException("Specified value is too long.");
        }
        this.numericUserId = name;
    }

    public void setPersonalName(PersonalName name) {
        if (name != null) {
            this.personalName = name;
        }
    }

    public void setOrganizationalUnitNames(String name) throws NameException {
        if (name == null) {
            throw new NameException("Specified value is null.");
        }
        if (name.length() > 32) {
            throw new NameException("Specified value is too long.");
        }
        if (this.orgUnitIndex == 4) {
            throw new NameException("Cannot add Organizational Unit Names attribute: MAX number is 4");
        }
        this.organizationUnitNames[this.orgUnitIndex] = name;
        ++this.orgUnitIndex;
    }

    public ORName getCountryName() {
        return this.countryName;
    }

    public ORName getAdminDomainName() {
        return this.adminName;
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public String getTerminalIdentifier() {
        return this.terminalId;
    }

    public ORName getPrivateDomainName() {
        return this.privateDomainName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getNumericUserIdentifier() {
        return this.numericUserId;
    }

    public PersonalName getPersonalName() {
        return this.personalName;
    }

    public String[] getOrganizationalUnitNames() {
        return this.organizationUnitNames;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.countryName != null) {
            buffer.append(this.countryName.toString());
        }
        if (this.adminName != null) {
            buffer.append(",");
            buffer.append(this.adminName.toString());
        }
        if (this.networkAddress != null) {
            buffer.append(",");
            buffer.append(this.networkAddress);
        }
        if (this.terminalId != null) {
            buffer.append(",");
            buffer.append(this.terminalId);
        }
        if (this.privateDomainName != null) {
            buffer.append(",");
            buffer.append(this.privateDomainName.toString());
        }
        if (this.organizationName != null) {
            buffer.append(",");
            buffer.append(this.organizationName);
        }
        if (this.numericUserId != null) {
            buffer.append(",");
            buffer.append(this.numericUserId);
        }
        if (this.personalName != null) {
            buffer.append(",");
            buffer.append(this.personalName.toString());
        }
        for (int index = 0; index < this.orgUnitIndex; ++index) {
            buffer.append(",");
            buffer.append(this.organizationUnitNames[index]);
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode BuiltInStandardAttributes");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode BuiltInStandardAttributes");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            byte[] encodingBER;
            int encodingLen;
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            Vector<Object> asn1Def = new Vector<Object>();
            asn1Def.addElement(seq);
            if (this.countryName != null) {
                encodingLen = this.countryName.getDERLen(65536);
                encodingBER = new byte[encodingLen];
                encodingLen = this.countryName.getDEREncoding(encodingBER, 0, 65536);
                EncodedContainer country = new EncodedContainer(65536, true, 0, encodingBER, 0, encodingLen);
                asn1Def.addElement(country);
            }
            if (this.adminName != null) {
                encodingLen = this.adminName.getDERLen(65536);
                encodingBER = new byte[encodingLen];
                encodingLen = this.adminName.getDEREncoding(encodingBER, 0, 65536);
                EncodedContainer admin = new EncodedContainer(65536, true, 0, encodingBER, 0, encodingLen);
                asn1Def.addElement(admin);
            }
            if (this.networkAddress != null) {
                NumericStringContainer network = new NumericStringContainer(0x810000, true, 0, this.networkAddress, 1, 16);
                asn1Def.addElement(network);
            }
            if (this.terminalId != null) {
                PrintStringContainer terminal = new PrintStringContainer(0x810001, true, 0, this.terminalId, 1, 24);
                asn1Def.addElement(terminal);
            }
            if (this.privateDomainName != null) {
                encodingLen = this.privateDomainName.getDERLen(8454146);
                encodingBER = new byte[encodingLen];
                encodingLen = this.privateDomainName.getDEREncoding(encodingBER, 0, 8454146);
                EncodedContainer domain = new EncodedContainer(8454146, true, 0, encodingBER, 0, encodingLen);
                asn1Def.addElement(domain);
            }
            if (this.organizationName != null) {
                PrintStringContainer orgName = new PrintStringContainer(8454147, true, 0, this.organizationName, 1, 64);
                asn1Def.addElement(orgName);
            }
            if (this.numericUserId != null) {
                NumericStringContainer userId = new NumericStringContainer(8454148, true, 0, this.numericUserId, 1, 32);
                asn1Def.addElement(userId);
            }
            if (this.personalName != null) {
                encodingLen = this.personalName.getDERLen(8454149);
                encodingBER = new byte[encodingLen];
                encodingLen = this.personalName.getDEREncoding(encodingBER, 0, 8454149);
                EncodedContainer personal = new EncodedContainer(8454149, true, 0, encodingBER, 0, encodingLen);
                asn1Def.addElement(personal);
            }
            if (this.orgUnitIndex != 0) {
                asn1Def.addElement(this.encodeOrgUnitNames());
            }
            asn1Def.addElement(anEnd);
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    private EncodedContainer encodeOrgUnitNames() throws NameException {
        EncodedContainer next;
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer sequenceOfContainer = new OfContainer(8454150, true, 0, 12288, (ASN1Container)new EncodedContainer(4864));
            asn1Def.addElement(sequenceOfContainer);
            for (int index = 0; index < this.orgUnitIndex; ++index) {
                PrintStringContainer printContainer = new PrintStringContainer(0, true, 0, this.organizationUnitNames[index], 1, 32);
                ASN1Container[] asnDef = new ASN1Container[]{printContainer};
                ASN1Template templ = new ASN1Template(asnDef);
                int encodingLen = templ.derEncodeInit();
                byte[] encoding = new byte[encodingLen];
                encodingLen = templ.derEncode(encoding, 0);
                EncodedContainer address = new EncodedContainer(4864, true, 0, encoding, 0, encodingLen);
                sequenceOfContainer.addContainer((ASN1Container)address);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            ASN1Template asnTemplate = new ASN1Template((ASN1Container[])asn1DefArray);
            int encLen = asnTemplate.derEncodeInit();
            byte[] enc = new byte[encLen];
            encLen = asnTemplate.derEncode(enc, 0);
            next = new EncodedContainer(12288, true, 0, enc, 0, encLen);
        }
        catch (ASN_Exception asnException) {
            throw new NameException(" Can't encode Organizational Unit Names.");
        }
        return next;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BuiltInStandardAttributes)) {
            return false;
        }
        BuiltInStandardAttributes other = (BuiltInStandardAttributes)obj;
        if (this.orgUnitIndex != other.orgUnitIndex) {
            return false;
        }
        if (this.countryName != null ? !this.countryName.equals(other.countryName) : other.countryName != null) {
            return false;
        }
        if (this.adminName != null ? !this.adminName.equals(other.adminName) : other.adminName != null) {
            return false;
        }
        if (this.networkAddress != null ? !this.networkAddress.equals(other.networkAddress) : other.networkAddress != null) {
            return false;
        }
        if (this.terminalId != null ? !this.terminalId.equals(other.terminalId) : other.terminalId != null) {
            return false;
        }
        if (this.privateDomainName != null ? !this.privateDomainName.equals(other.privateDomainName) : other.privateDomainName != null) {
            return false;
        }
        if (this.organizationName != null ? !this.organizationName.equals(other.organizationName) : other.organizationName != null) {
            return false;
        }
        if (this.numericUserId != null ? !this.numericUserId.equals(other.numericUserId) : other.numericUserId != null) {
            return false;
        }
        if (this.personalName != null ? !this.personalName.equals(other.personalName) : other.personalName != null) {
            return false;
        }
        for (int index = 0; index < this.orgUnitIndex; ++index) {
            if (this.organizationUnitNames[index].equals(other.organizationUnitNames[index])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int len;
        try {
            len = this.getDERLen(0);
        }
        catch (NameException e) {
            return 0;
        }
        if (len == 0) {
            return 0;
        }
        byte[] enc = new byte[len];
        try {
            this.getDEREncoding(enc, 0, 0);
        }
        catch (NameException e) {
            return 0;
        }
        return Arrays.hashCode(enc);
    }

    public Object clone() throws CloneNotSupportedException {
        BuiltInStandardAttributes otherSelf = new BuiltInStandardAttributes();
        otherSelf.orgUnitIndex = this.orgUnitIndex;
        if (this.countryName != null) {
            otherSelf.countryName = (ORName)this.countryName.clone();
        }
        if (this.adminName != null) {
            otherSelf.adminName = (ORName)this.adminName.clone();
        }
        if (this.networkAddress != null) {
            otherSelf.networkAddress = this.networkAddress;
        }
        if (this.terminalId != null) {
            otherSelf.terminalId = this.terminalId;
        }
        if (this.privateDomainName != null) {
            otherSelf.privateDomainName = (ORName)this.privateDomainName.clone();
        }
        if (this.organizationName != null) {
            otherSelf.organizationName = this.organizationName;
        }
        if (this.numericUserId != null) {
            otherSelf.numericUserId = this.numericUserId;
        }
        if (this.personalName != null) {
            otherSelf.personalName = (PersonalName)this.personalName.clone();
        }
        System.arraycopy(this.organizationUnitNames, 0, otherSelf.organizationUnitNames, 0, this.orgUnitIndex);
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

