/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLDistributionPoints
extends X509V3Extension
implements CertExtension {
    public static final int REASON_FLAGS_BITS = 9;
    public static final int REASON_FLAGS_MASK = -8388608;
    public static final int UNUSED = Integer.MIN_VALUE;
    public static final int KEY_COMPROMISE = 0x40000000;
    public static final int CA_COMPROMISE = 0x20000000;
    public static final int AFFILIATION_CHANGED = 0x10000000;
    public static final int SUPERSEDED = 0x8000000;
    public static final int CESSATION_OF_OPERATION = 0x4000000;
    public static final int CERTIFICATE_HOLD = 0x2000000;
    public static final int PRIVILEGE_WITHDRAWN = 0x1000000;
    public static final int AA_COMPROMISE = 0x800000;
    private Vector<Object>[] crlVector = this.createVectorArray();
    private static final int DISTRIBUTION_POINT_SPECIAL = 0xA10000;
    private static final int REASONS_SPECIAL = 0x810001;
    private static final int CRL_ISSUER_SPECIAL = 8454146;
    private static final int FULL_NAME_SPECIAL = 0x800000;
    private static final int NAME_RELATIVE_SPECIAL = 0x800001;
    ASN1Template asn1TemplateValue;

    public CRLDistributionPoints() {
        this.extensionTypeFlag = 31;
        this.criticality = false;
        this.setStandardOID(31);
        this.extensionTypeString = "CRLDistributionPoints";
    }

    public CRLDistributionPoints(RDN distributionPoint, int reason, GeneralNames crlIssuer, boolean criticality) {
        this.extensionTypeFlag = 31;
        this.criticality = criticality;
        this.setStandardOID(31);
        this.crlVector[0].addElement(distributionPoint);
        this.crlVector[1].addElement(new Integer(reason));
        this.crlVector[2].addElement(crlIssuer);
        this.extensionTypeString = "CRLDistributionPoints";
    }

    public CRLDistributionPoints(GeneralNames distributionPoint, int reason, GeneralNames crlIssuer, boolean criticality) {
        this.extensionTypeFlag = 31;
        this.criticality = criticality;
        this.setStandardOID(31);
        this.crlVector[0].addElement(distributionPoint);
        this.crlVector[1].addElement(new Integer(reason));
        this.crlVector[2].addElement(crlIssuer);
        this.extensionTypeString = "CRLDistributionPoints";
    }

    private Vector<Object>[] createVectorArray() {
        Vector[] vectorArray = new Vector[3];
        for (int index = 0; index < 3; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    @Override
    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] nameDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            int nameCount = seqOf.getContainerCount();
            for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
                ASN1Container encodedNameContainer = seqOf.containerAt(nameIndex);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                ChoiceContainer pointContainer = new ChoiceContainer(0xA10000);
                EncodedContainer genName = new EncodedContainer(0x803000);
                EncodedContainer rdn = new EncodedContainer(8401153);
                BitStringContainer bits = new BitStringContainer(0x810001);
                EncodedContainer issuer = new EncodedContainer(8466434);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, pointContainer, genName, rdn, anEnd, bits, issuer, anEnd};
                ASN1.berDecode((byte[])encodedNameContainer.data, (int)encodedNameContainer.dataOffset, (ASN1Container[])asn1Def);
                if (genName.dataPresent) {
                    this.crlVector[0].addElement(new GeneralNames(genName.data, genName.dataOffset, 0x800000));
                } else if (rdn.dataPresent) {
                    this.crlVector[0].addElement(new RDN(rdn.data, rdn.dataOffset, 0x800001));
                } else {
                    this.crlVector[0].addElement(null);
                }
                if (bits.dataPresent) {
                    if (bits.dataLen > 4) {
                        throw new CertificateException("Could not decode CRLDistributionPoints extension.");
                    }
                    if (bits.dataLen == 0) {
                        this.crlVector[1].addElement(new Integer(0));
                    } else {
                        int keyUsage = 0;
                        int index = bits.dataOffset;
                        int shiftCount = 24;
                        while (index < bits.dataOffset + bits.dataLen) {
                            keyUsage |= (bits.data[index] & 0xFF) << shiftCount;
                            ++index;
                            shiftCount -= 8;
                        }
                        this.crlVector[1].addElement(new Integer(keyUsage &= 0xFF800000));
                    }
                } else {
                    this.crlVector[1].addElement(new Integer(-1));
                }
                if (issuer.dataPresent) {
                    this.crlVector[2].addElement(new GeneralNames(issuer.data, issuer.dataOffset, 8454146));
                    continue;
                }
                this.crlVector[2].addElement(null);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode CRLDistributionPoints extension.");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not create new GeneralNames object.");
        }
    }

    public void addDistributionPoints(RDN distributionPoint, int reason, GeneralNames crlIssuer) {
        this.crlVector[0].addElement(distributionPoint);
        if (reason == -1) {
            this.crlVector[1].addElement(new Integer(-1));
        } else {
            this.crlVector[1].addElement(new Integer(reason &= 0xFF800000));
        }
        this.crlVector[2].addElement(crlIssuer);
    }

    public void addDistributionPoints(GeneralNames distributionPoint, int reason, GeneralNames crlIssuer) {
        this.crlVector[0].addElement(distributionPoint);
        if (reason == -1) {
            this.crlVector[1].addElement(new Integer(-1));
        } else {
            this.crlVector[1].addElement(new Integer(reason &= 0xFF800000));
        }
        this.crlVector[2].addElement(crlIssuer);
    }

    public Object getDistributionPointName(int index) throws NameException {
        if (this.crlVector[0].size() <= index) {
            throw new NameException("Specified index is invalid.");
        }
        if (this.crlVector[0] == null) {
            return null;
        }
        return this.crlVector[0].elementAt(index);
    }

    public int getReasonFlags(int index) throws NameException {
        if (this.crlVector[1].size() <= index) {
            throw new NameException("Specified index is invalid.");
        }
        Integer result = (Integer)this.crlVector[1].elementAt(index);
        return result;
    }

    public GeneralNames getCRLIssuer(int index) throws NameException {
        if (this.crlVector[2].size() <= index) {
            throw new NameException("Specified index is invalid.");
        }
        return (GeneralNames)this.crlVector[2].elementAt(index);
    }

    public int getDistributionPointCount() {
        return this.crlVector[0].size();
    }

    @Override
    public int derEncodeValueInit() {
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            EndContainer aEnd = new EndContainer();
            asn1Def.addElement(seqOf);
            for (int index = 0; index < this.crlVector[0].size(); ++index) {
                try {
                    ASN1Template templ;
                    int reason;
                    int flag = 0;
                    SequenceContainer seq = new SequenceContainer(0, true, 0);
                    ChoiceContainer choice = null;
                    BitStringContainer reasonFlag = null;
                    EncodedContainer issuer = null;
                    EncodedContainer name = null;
                    if (this.crlVector[0].elementAt(index) != null) {
                        choice = new ChoiceContainer(0xA10000, 0);
                        name = this.encodeName(index);
                        flag = 1;
                    }
                    if ((reason = ((Integer)this.crlVector[1].elementAt(index)).intValue()) != -1) {
                        reasonFlag = new BitStringContainer(0x810001, true, 0, reason, 9, true);
                        flag = flag == 0 ? 2 : 3;
                    }
                    if (this.crlVector[2].elementAt(index) != null) {
                        issuer = this.encodeIssuer(index);
                        if (flag == 0) {
                            flag = 4;
                        } else if (flag == 1) {
                            flag = 5;
                        } else if (flag == 2) {
                            flag = 6;
                        } else if (flag == 3) {
                            flag = 7;
                        }
                    }
                    switch (flag) {
                        case 0: {
                            ASN1Container[] asnDef0 = new ASN1Container[]{seq, aEnd};
                            templ = new ASN1Template(asnDef0);
                            break;
                        }
                        case 1: {
                            ASN1Container[] asnDef1 = new ASN1Container[]{seq, choice, name, aEnd, aEnd};
                            templ = new ASN1Template(asnDef1);
                            break;
                        }
                        case 2: {
                            ASN1Container[] asnDef2 = new ASN1Container[]{seq, reasonFlag, aEnd};
                            templ = new ASN1Template(asnDef2);
                            break;
                        }
                        case 3: {
                            ASN1Container[] asnDef3 = new ASN1Container[]{seq, choice, name, aEnd, reasonFlag, aEnd};
                            templ = new ASN1Template(asnDef3);
                            break;
                        }
                        case 4: {
                            ASN1Container[] asnDef4 = new ASN1Container[]{seq, issuer, aEnd};
                            templ = new ASN1Template(asnDef4);
                            break;
                        }
                        case 5: {
                            ASN1Container[] asnDef5 = new ASN1Container[]{seq, choice, name, aEnd, issuer, aEnd};
                            templ = new ASN1Template(asnDef5);
                            break;
                        }
                        case 6: {
                            ASN1Container[] asnDef6 = new ASN1Container[]{seq, reasonFlag, issuer, aEnd};
                            templ = new ASN1Template(asnDef6);
                            break;
                        }
                        case 7: {
                            ASN1Container[] asnDef7 = new ASN1Container[]{seq, choice, name, aEnd, reasonFlag, issuer, aEnd};
                            templ = new ASN1Template(asnDef7);
                            break;
                        }
                        default: {
                            return 0;
                        }
                    }
                    int encodingLen = templ.derEncodeInit();
                    byte[] encoding = new byte[encodingLen];
                    encodingLen = templ.derEncode(encoding, 0);
                    EncodedContainer next = new EncodedContainer(12288, true, 0, encoding, 0, encodingLen);
                    seqOf.addContainer((ASN1Container)next);
                    continue;
                }
                catch (ASN_Exception asnException) {
                    return 0;
                }
                catch (CertificateException certException) {
                    return 0;
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private EncodedContainer encodeName(int index) throws CertificateException {
        EncodedContainer name = null;
        try {
            if (this.crlVector[0].elementAt(index) instanceof GeneralNames) {
                int nameDERLen = ((GeneralNames)this.crlVector[0].elementAt(index)).getDERLen(0x800000);
                byte[] nameDER = new byte[nameDERLen];
                nameDERLen = ((GeneralNames)this.crlVector[0].elementAt(index)).getDEREncoding(nameDER, 0, 0x800000);
                name = new EncodedContainer(12288, true, 0, nameDER, 0, nameDERLen);
            } else if (this.crlVector[0].elementAt(index) instanceof RDN) {
                int nameDERLen = ((RDN)this.crlVector[0].elementAt(index)).getDERLen(0x800001);
                byte[] nameDER = new byte[nameDERLen];
                nameDERLen = ((RDN)this.crlVector[0].elementAt(index)).getDEREncoding(nameDER, 0, 0x800001);
                name = new EncodedContainer(12544, true, 0, nameDER, 0, nameDERLen);
            }
            return name;
        }
        catch (ASN_Exception e) {
            throw new CertificateException("Can't encode DistributionPointNames", (Exception)((Object)e));
        }
        catch (NameException e) {
            throw new CertificateException("Can't encode DistributionPointNames", e);
        }
    }

    private EncodedContainer encodeIssuer(int index) throws CertificateException {
        try {
            int nameDERLen = ((GeneralNames)this.crlVector[2].elementAt(index)).getDERLen(8454146);
            byte[] nameDER = new byte[nameDERLen];
            nameDERLen = ((GeneralNames)this.crlVector[2].elementAt(index)).getDEREncoding(nameDER, 0, 8454146);
            return new EncodedContainer(12288, true, 0, nameDER, 0, nameDERLen);
        }
        catch (ASN_Exception e) {
            throw new CertificateException("Can't encode cRLIssuer", (Exception)((Object)e));
        }
        catch (NameException e) {
            throw new CertificateException("Can't encode cRLIssuer", e);
        }
    }

    @Override
    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CRLDistributionPoints otherSelf = new CRLDistributionPoints();
        this.copyValues(otherSelf);
        return otherSelf;
    }

    protected void copyValues(CRLDistributionPoints otherSelf) {
        for (int index = 0; index < this.crlVector[0].size(); ++index) {
            if (this.crlVector[0].elementAt(index) == null) {
                otherSelf.crlVector[0].addElement(null);
            }
            try {
                if (this.crlVector[0].elementAt(index) instanceof GeneralNames) {
                    otherSelf.crlVector[0].addElement(((GeneralNames)this.crlVector[0].elementAt(index)).clone());
                } else if (this.crlVector[0].elementAt(index) instanceof RDN) {
                    otherSelf.crlVector[0].addElement(((RDN)this.crlVector[0].elementAt(index)).clone());
                }
                otherSelf.crlVector[1].addElement(this.crlVector[1].elementAt(index));
                if (this.crlVector[2].elementAt(index) == null) {
                    otherSelf.crlVector[2].addElement(null);
                    continue;
                }
                otherSelf.crlVector[2].addElement(((GeneralNames)this.crlVector[2].elementAt(index)).clone());
                continue;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
    }

    @Override
    protected void reset() {
        super.reset();
        this.crlVector = null;
        this.asn1TemplateValue = null;
    }
}

