/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IntegerContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class CRLNumber
extends X509V3Extension
implements CRLExtension {
    private byte[] crlNumber;
    ASN1Template asn1TemplateValue;

    private CRLNumber(boolean criticality) {
        this.extensionTypeFlag = 20;
        this.criticality = criticality;
        this.setStandardOID(20);
        this.extensionTypeString = "CRLNumber";
    }

    public CRLNumber() {
        this(false);
        this.setCRLNumber(0);
    }

    public CRLNumber(int crlNumber, boolean criticality) {
        this(criticality);
        this.setCRLNumber(crlNumber);
    }

    public CRLNumber(byte[] crlNumber, int offset, int length, boolean criticality) {
        this(criticality);
        this.setCRLNumber(crlNumber, offset, length);
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        IntegerContainer number = new IntegerContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{number};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.crlNumber = new byte[number.dataLen];
            System.arraycopy(number.data, number.dataOffset, this.crlNumber, 0, number.dataLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode CRLNumber extension.");
        }
    }

    public void setCRLNumber(int number) {
        this.crlNumber = this.intToByteArray(number);
    }

    public void setCRLNumber(byte[] number, int offset, int length) {
        this.crlNumber = new byte[length];
        System.arraycopy(number, offset, this.crlNumber, 0, length);
    }

    public int getCRLNumber() throws CertificateException {
        if (this.crlNumber.length > 4) {
            throw new CertificateException("Can not represent integer in 32 bits.");
        }
        return this.byteArrayToInt(this.crlNumber);
    }

    public byte[] getCRLNumberAsByteArray() {
        return this.crlNumber;
    }

    public int derEncodeValueInit() {
        try {
            IntegerContainer number = new IntegerContainer(0, true, 0, this.crlNumber, 0, this.crlNumber.length, true);
            ASN1Container[] asn1Def = new ASN1Container[]{number};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CRLNumber otherSelf = new CRLNumber();
        if (this.crlNumber != null) {
            otherSelf.crlNumber = (byte[])this.crlNumber.clone();
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.setCRLNumber(0);
        this.asn1TemplateValue = null;
    }
}

