/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertPolicies
extends X509V3Extension
implements CertExtension {
    private Vector<Object>[] policy = this.createVectorArray(2);
    private ASN1Template asn1TemplateValue;

    public CertPolicies() {
        this.extensionTypeFlag = 32;
        this.criticality = false;
        this.setStandardOID(32);
        this.extensionTypeString = "CertPolicies";
    }

    public CertPolicies(byte[] oid, int oidOffset, int oidLen, PolicyQualifiers qualifier, boolean criticality) {
        this.extensionTypeFlag = 32;
        this.criticality = criticality;
        this.setStandardOID(32);
        if (oid != null && oidLen != 0) {
            byte[] id = new byte[oidLen];
            System.arraycopy(oid, oidOffset, id, 0, oidLen);
            this.policy[0].addElement(id);
            this.policy[1].addElement(qualifier);
        }
        this.extensionTypeString = "CertPolicies";
    }

    public void addCertPolicy(byte[] oid, int oidOffset, int oidLen, PolicyQualifiers qualifier) {
        if (oid != null && oidLen != 0) {
            byte[] id = new byte[oidLen];
            System.arraycopy(oid, oidOffset, id, 0, oidLen);
            this.policy[0].addElement(id);
            this.policy[1].addElement(qualifier);
        }
    }

    public byte[] getCertPolicyId(int index) throws CertificateException {
        if (this.policy[0].size() <= index) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (byte[])this.policy[0].elementAt(index);
    }

    public PolicyQualifiers getPolicyQualifiers(int index) throws CertificateException {
        if (this.policy[1].size() <= index) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (PolicyQualifiers)this.policy[1].elementAt(index);
    }

    public int getPoliciesCount() {
        return this.policy[0].size();
    }

    private Vector<Object>[] createVectorArray(int size) {
        Vector[] vectorArray = new Vector[size];
        for (int index = 0; index < size; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    @Override
    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] nameDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            int nameCount = seqOf.getContainerCount();
            for (int index = 0; index < nameCount; ++index) {
                ASN1Container encodedContainer = seqOf.containerAt(index);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                EncodedContainer qualifier = new EncodedContainer(77824);
                OIDContainer oid = new OIDContainer(0);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, oid, qualifier, anEnd};
                ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])asn1Def);
                byte[] id = new byte[oid.dataLen];
                System.arraycopy(oid.data, oid.dataOffset, id, 0, oid.dataLen);
                this.policy[0].addElement(id);
                if (qualifier.dataPresent) {
                    this.policy[1].addElement(new PolicyQualifiers(qualifier.data, qualifier.dataOffset, 65536));
                    continue;
                }
                this.policy[1].addElement(null);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode Certificate Policies extension.");
        }
        catch (CertificateException nameException) {
            throw new CertificateException("Could not decode Certificate Policies extension.");
        }
    }

    @Override
    public int derEncodeValueInit() {
        if (this.policy[0].isEmpty()) {
            return 0;
        }
        try {
            Vector<OfContainer> asn1Def = new Vector<OfContainer>();
            OfContainer seqOf = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(seqOf);
            for (int index = 0; index < this.policy[0].size(); ++index) {
                EncodedContainer qContainer = this.encodePolicy(index);
                seqOf.addContainer((ASN1Container)qContainer);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (Exception anyExc) {
            return 0;
        }
    }

    private EncodedContainer encodePolicy(int index) throws CertificateException {
        EncodedContainer next;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer end = new EndContainer();
        byte[] oid = (byte[])this.policy[0].elementAt(index);
        try {
            ASN1Template templ;
            OIDContainer id = new OIDContainer(0x1000000, true, 0, oid, 0, oid.length);
            PolicyQualifiers q = (PolicyQualifiers)this.policy[1].elementAt(index);
            if (q != null) {
                byte[] encoding = new byte[q.getDERLen(65536)];
                int len = q.getDEREncoding(encoding, 0, 65536);
                EncodedContainer qualifier = new EncodedContainer(77824, true, 0, encoding, 0, len);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, id, qualifier, end};
                templ = new ASN1Template(asn1Def);
            } else {
                ASN1Container[] asn1Def = new ASN1Container[]{seq, id, end};
                templ = new ASN1Template(asn1Def);
            }
            int encodingLen = templ.derEncodeInit();
            byte[] encoding = new byte[encodingLen];
            encodingLen = templ.derEncode(encoding, 0);
            next = new EncodedContainer(12288, true, 0, encoding, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException(" Can't encode Certificate Policy");
        }
        return next;
    }

    @Override
    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            return this.asn1TemplateValue.derEncode(encoding, offset);
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CertPolicies otherSelf = new CertPolicies();
        for (int index = 0; index < this.policy.length; ++index) {
            for (int vectorIndex = 0; vectorIndex < this.policy[index].size(); ++vectorIndex) {
                otherSelf.policy[index].addElement(this.policy[index].elementAt(vectorIndex));
            }
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    @Override
    protected void reset() {
        super.reset();
        this.policy = this.createVectorArray(2);
    }
}

