/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class CertificateIssuer
extends X509V3Extension
implements CRLEntryExtension,
OCSPSingleExtension {
    private GeneralNames generalNames;

    public CertificateIssuer() {
        this.extensionTypeFlag = 29;
        this.criticality = false;
        this.setStandardOID(29);
        this.extensionTypeString = "CertificateIssuer";
    }

    public CertificateIssuer(GeneralNames names, boolean criticality) {
        this.extensionTypeFlag = 29;
        this.criticality = criticality;
        if (names != null) {
            this.generalNames = names;
        }
        this.setStandardOID(29);
        this.extensionTypeString = "CertificateIssuer";
    }

    public void setGeneralNames(GeneralNames names) {
        try {
            if (names != null) {
                this.generalNames = (GeneralNames)names.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public GeneralNames getGeneralNames() {
        return this.generalNames;
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.generalNames = new GeneralNames(valueBER, offset, 0);
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not decode CertificateIssuer extension.");
        }
    }

    public int derEncodeValueInit() {
        if (this.generalNames == null) {
            return 0;
        }
        try {
            return this.generalNames.getDERLen(this.special);
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (this.generalNames == null) {
            return 0;
        }
        if (encoding == null) {
            return 0;
        }
        try {
            return this.generalNames.getDEREncoding(encoding, offset, 0);
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CertificateIssuer otherSelf = new CertificateIssuer();
        if (this.generalNames != null) {
            otherSelf.generalNames = (GeneralNames)this.generalNames.clone();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.generalNames = null;
    }
}

