/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class EDIPartyName
implements Cloneable,
Serializable {
    private static final int NAMEASSIGNER_SPECIAL = 0xA10000;
    private static final int PARTYNAME_SPECIAL = 0xA00001;
    private String nameAssigner;
    private int assignerType;
    private String partyName;
    private int partyType;
    protected int special;
    private ASN1Template asn1Template;

    public EDIPartyName(byte[] nameBER, int offset, int special) throws NameException {
        block18: {
            if (nameBER == null) {
                throw new NameException("Encoding is null.");
            }
            try {
                SequenceContainer seq = new SequenceContainer(special);
                EndContainer anEnd = new EndContainer();
                ChoiceContainer nameContainer = new ChoiceContainer(0xA10000);
                TeletexStringContainer telString1 = new TeletexStringContainer(0);
                PrintStringContainer printString1 = new PrintStringContainer(0);
                UniversalStringContainer univerString1 = new UniversalStringContainer(0);
                UTF8StringContainer utfString1 = new UTF8StringContainer(0);
                BMPStringContainer bmpString1 = new BMPStringContainer(0);
                ChoiceContainer partyContainer = new ChoiceContainer(0xA00001);
                TeletexStringContainer telString2 = new TeletexStringContainer(0);
                PrintStringContainer printString2 = new PrintStringContainer(0);
                UniversalStringContainer univerString2 = new UniversalStringContainer(0);
                UTF8StringContainer utfString2 = new UTF8StringContainer(0);
                BMPStringContainer bmpString2 = new BMPStringContainer(0);
                ASN1Container[] nameStringDef = new ASN1Container[]{seq, nameContainer, telString1, printString1, univerString1, utfString1, bmpString1, anEnd, partyContainer, telString2, printString2, univerString2, utfString2, bmpString2, anEnd, anEnd};
                ASN1.berDecode((byte[])nameBER, (int)offset, (ASN1Container[])nameStringDef);
                if (nameContainer.dataPresent) {
                    if (telString1.dataPresent) {
                        this.nameAssigner = telString1.getValueAsString();
                        this.assignerType = 5120;
                    } else if (printString1.dataPresent) {
                        this.nameAssigner = printString1.getValueAsString();
                        this.assignerType = 4864;
                    } else if (univerString1.dataPresent) {
                        this.nameAssigner = univerString1.getValueAsString();
                        this.assignerType = 7168;
                    } else if (utfString1.dataPresent) {
                        this.nameAssigner = new String(utfString1.data, utfString1.dataOffset, utfString1.dataLen);
                        this.assignerType = 3072;
                    } else if (bmpString1.dataPresent) {
                        this.nameAssigner = bmpString1.getValueAsString();
                        this.assignerType = 7680;
                    }
                }
                if (telString2.dataPresent) {
                    this.partyName = telString2.getValueAsString();
                    this.partyType = 5120;
                    break block18;
                }
                if (printString2.dataPresent) {
                    this.partyName = printString2.getValueAsString();
                    this.partyType = 4864;
                    break block18;
                }
                if (univerString2.dataPresent) {
                    this.partyName = univerString2.getValueAsString();
                    this.partyType = 7168;
                    break block18;
                }
                if (utfString2.dataPresent) {
                    this.partyName = new String(utfString2.data, utfString2.dataOffset, utfString2.dataLen);
                    this.partyType = 3072;
                    break block18;
                }
                if (bmpString2.dataPresent) {
                    this.partyName = bmpString2.getValueAsString();
                    this.partyType = 7680;
                    break block18;
                }
                throw new NameException("Party Name field must be set!");
            }
            catch (ASN_Exception asnException) {
                throw new NameException("Cannot decode the BER of the name.");
            }
        }
    }

    public EDIPartyName() {
    }

    public void addNameAssigner(String value, int type) {
        if (value != null) {
            this.nameAssigner = value;
            this.assignerType = type == 0 ? 7168 : type;
        }
    }

    public void addPartyName(String value, int type) {
        if (value != null) {
            this.partyName = value;
            this.partyType = type == 0 ? 7168 : type;
        }
    }

    public String getNameAssigner() {
        return this.nameAssigner;
    }

    public String getPartyName() {
        return this.partyName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.nameAssigner != null) {
            buffer.append(this.nameAssigner);
            buffer.append(", ");
        }
        buffer.append(this.partyName);
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode EDI Party Name.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode EDI Party Name.");
        }
    }

    private int derEncodeInit() throws NameException {
        ASN1Container[] asn1Def;
        TeletexStringContainer party;
        SequenceContainer seq = new SequenceContainer(this.special, true, 0);
        ChoiceContainer choiceContainer1 = new ChoiceContainer(0xA10000, 0);
        ChoiceContainer choiceContainer2 = new ChoiceContainer(0xA00001, 0);
        EndContainer anEnd = new EndContainer();
        TeletexStringContainer assigner = null;
        int maxLen = Short.MAX_VALUE;
        if (this.partyName == null) {
            throw new NameException("PartyName is not set.");
        }
        try {
            byte[] data;
            switch (this.assignerType) {
                case 5120: {
                    assigner = new TeletexStringContainer(0, true, 0, this.nameAssigner, 1, maxLen);
                    break;
                }
                case 4864: {
                    assigner = new PrintStringContainer(0, true, 0, this.nameAssigner, 1, maxLen);
                    break;
                }
                case 7168: {
                    assigner = new UniversalStringContainer(0, true, 0, this.nameAssigner, 1, maxLen);
                    break;
                }
                case 3072: {
                    if (this.nameAssigner != null) {
                        data = this.nameAssigner.getBytes();
                        if (data.length > maxLen) {
                            throw new NameException("Illegal name length");
                        }
                        assigner = new UTF8StringContainer(0, true, 0, data, 0, data.length);
                        break;
                    }
                    assigner = new UTF8StringContainer(0, false, 0, null, 0, 0);
                    break;
                }
                case 7680: {
                    assigner = new BMPStringContainer(0, true, 0, this.nameAssigner, 1, maxLen);
                    break;
                }
            }
            switch (this.partyType) {
                case 5120: {
                    party = new TeletexStringContainer(0, true, 0, this.partyName, 1, maxLen);
                    break;
                }
                case 4864: {
                    party = new PrintStringContainer(0, true, 0, this.partyName, 1, maxLen);
                    break;
                }
                case 7168: {
                    party = new UniversalStringContainer(0, true, 0, this.partyName, 1, maxLen);
                    break;
                }
                case 3072: {
                    data = this.partyName.getBytes();
                    if (data.length > maxLen) {
                        throw new NameException("Illegal name length");
                    }
                    party = new UTF8StringContainer(0, true, 0, data, 0, data.length);
                    break;
                }
                case 7680: {
                    party = new BMPStringContainer(0, true, 0, this.partyName, 1, maxLen);
                    break;
                }
                default: {
                    throw new NameException("Illegal empty partyName value");
                }
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException((Exception)((Object)asnException));
        }
        if (assigner == null) {
            asn1Def = new ASN1Container[]{seq, choiceContainer2, party, anEnd, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
        } else {
            asn1Def = new ASN1Container[]{seq, choiceContainer1, assigner, anEnd, choiceContainer2, party, anEnd, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
        }
        try {
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new NameException((Exception)((Object)asnException));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EDIPartyName)) {
            return false;
        }
        EDIPartyName other = (EDIPartyName)obj;
        if (this.nameAssigner != null ? !this.nameAssigner.equals(other.nameAssigner) : other.nameAssigner != null) {
            return false;
        }
        return !(this.partyName != null ? !this.partyName.equals(other.partyName) : other.partyName != null);
    }

    public int hashCode() {
        return (this.nameAssigner + this.partyName).hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        EDIPartyName otherSelf = new EDIPartyName();
        otherSelf.assignerType = this.assignerType;
        otherSelf.partyType = this.partyType;
        otherSelf.nameAssigner = this.nameAssigner;
        otherSelf.partyName = this.partyName;
        otherSelf.special = this.special;
        try {
            if (this.asn1Template != null) {
                otherSelf.derEncodeInit();
            }
        }
        catch (NameException nameException) {
            throw new CloneNotSupportedException("Cannot get ASN1 Template");
        }
        return otherSelf;
    }
}

