/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.NumericStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.PresentationAddress;
import java.io.Serializable;

public class ExtendedNetworkAddress
implements Cloneable,
Serializable {
    private String number;
    private String subAddress;
    private PresentationAddress psapAddress;
    protected int special;
    protected ASN1Template asn1Template;
    private static final int NUMBER_SPECIAL = 0x800000;
    private static final int SUBADDRESS_SPECIAL = 0x810001;
    private static final int PSAPADDRESS_SPECIAL = 0x800000;

    public ExtendedNetworkAddress(byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ChoiceContainer nameContainer = new ChoiceContainer(special);
            SequenceContainer seq = new SequenceContainer(0);
            NumericStringContainer numberContainer = new NumericStringContainer(0x800000, 1, 15);
            NumericStringContainer addressContainer = new NumericStringContainer(0x810001, 1, 40);
            EncodedContainer psapContainer = new EncodedContainer(0x803000);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] nameDef = new ASN1Container[]{nameContainer, seq, numberContainer, addressContainer, endContainer, psapContainer, endContainer};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            if (psapContainer.dataPresent) {
                byte[] psap = new byte[psapContainer.dataLen];
                System.arraycopy(psapContainer.data, psapContainer.dataOffset, psap, 0, psapContainer.dataLen);
                this.psapAddress = new PresentationAddress(psap, 0, 0x800000);
            } else {
                this.number = new String(numberContainer.data, numberContainer.dataOffset, numberContainer.dataLen);
                if (addressContainer.dataPresent) {
                    this.subAddress = new String(addressContainer.data, addressContainer.dataOffset, addressContainer.dataLen);
                }
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the ExtendedNetworkAddress.");
        }
    }

    public ExtendedNetworkAddress() {
    }

    public void setNumber(String number) throws NameException {
        if (number == null) {
            throw new NameException("Specified value is null.");
        }
        if (number.length() > 15) {
            throw new NameException("Specified value are too long.");
        }
        this.number = number;
    }

    public void setSubAddress(String subAddress) throws NameException {
        if (subAddress == null) {
            throw new NameException("Specified value is null.");
        }
        if (subAddress.length() > 40) {
            throw new NameException("Specified value are too long.");
        }
        this.subAddress = subAddress;
    }

    public void setPsapAddress(PresentationAddress psapAddress) throws NameException {
        if (psapAddress == null) {
            throw new NameException("Specified value is null.");
        }
        this.psapAddress = psapAddress;
    }

    public String getNumber() {
        return this.number;
    }

    public String getSubAddress() {
        return this.subAddress;
    }

    public PresentationAddress getPsapAddress() {
        return this.psapAddress;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.psapAddress != null) {
            buffer.append(this.psapAddress.toString());
        } else {
            if (this.number != null) {
                buffer.append(this.number);
            }
            if (this.subAddress != null) {
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                buffer.append(this.subAddress);
            }
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || special != this.special) {
                this.getDERLen(special);
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ExtendedNetworkAddress");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(this.special, 0);
            EndContainer endContainer = new EndContainer();
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            if (this.psapAddress != null) {
                int psapLen = this.psapAddress.getDERLen(0x800000);
                byte[] psapEncoding = new byte[psapLen];
                psapLen = this.psapAddress.getDEREncoding(psapEncoding, 0, 0x800000);
                EncodedContainer psap = new EncodedContainer(12288, true, 0, psapEncoding, 0, psapLen);
                ASN1Container[] asn1Def0 = new ASN1Container[]{choiceContainer, psap, endContainer};
                this.asn1Template = new ASN1Template(asn1Def0);
            } else {
                NumericStringContainer numberContainer = new NumericStringContainer(0x800000, true, 0, this.number, 1, 15);
                if (this.subAddress != null) {
                    NumericStringContainer addressContainer = new NumericStringContainer(0x810001, true, 0, this.subAddress, 1, 40);
                    ASN1Container[] asn1Def1 = new ASN1Container[]{choiceContainer, seq, numberContainer, addressContainer, endContainer, endContainer};
                    this.asn1Template = new ASN1Template(asn1Def1);
                } else {
                    ASN1Container[] asn1Def2 = new ASN1Container[]{choiceContainer, seq, numberContainer, endContainer, endContainer};
                    this.asn1Template = new ASN1Template(asn1Def2);
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ExtendedNetworkAddress)) {
            return false;
        }
        ExtendedNetworkAddress other = (ExtendedNetworkAddress)obj;
        if (this.number != null ? !this.number.equals(other.number) : other.number != null) {
            return false;
        }
        if (this.subAddress != null ? !this.subAddress.equals(other.subAddress) : other.subAddress != null) {
            return false;
        }
        return !(this.psapAddress != null ? !this.psapAddress.equals(other.psapAddress) : other.psapAddress != null);
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.number != null) {
            hashcode ^= this.number.hashCode();
        }
        if (this.subAddress != null) {
            hashcode ^= 17 * this.subAddress.hashCode();
        }
        if (this.psapAddress != null) {
            hashcode ^= 33 * this.psapAddress.hashCode();
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        ExtendedNetworkAddress otherSelf = new ExtendedNetworkAddress();
        if (this.psapAddress != null) {
            otherSelf.psapAddress = (PresentationAddress)this.psapAddress.clone();
        } else {
            if (this.number != null) {
                otherSelf.number = this.number;
            }
            if (this.subAddress != null) {
                otherSelf.subAddress = this.subAddress;
            }
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

