/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.ExtendedNetworkAddress;
import com.rsa.certj.cert.extensions.ORName;
import com.rsa.certj.cert.extensions.PDSParameter;
import com.rsa.certj.cert.extensions.TeletexDomainDefinedAttributes;
import com.rsa.certj.cert.extensions.TeletexPersonalName;
import com.rsa.certj.cert.extensions.UnformattedPostalAddress;
import java.io.Serializable;
import java.util.Vector;

public class ExtensionAttribute
implements Cloneable,
Serializable {
    public static final int COMMON_NAME = 1;
    public static final int TELETEX_COMMON_NAME = 2;
    public static final int TELETEX_ORGANIZATION_NAME = 3;
    public static final int TELETEX_PERSONAL_NAME = 4;
    public static final int TELETEX_ORGANIZATIONAL_UNIT_NAMES = 5;
    public static final int TELETEX_DOMAIN_DEFINED_ATTRIBUTES = 6;
    public static final int PDS_NAME = 7;
    public static final int PHYSICAL_DELIVERY_COUNTRY_NAME = 8;
    public static final int POSTAL_CODE = 9;
    public static final int PHYSICAL_DELIVERY_OFFICE_NAME = 10;
    public static final int PHYSICAL_DELIVERY_OFFICE_NUMBER = 11;
    public static final int EXTENSION_OR_ADDRESS_COMPONENTS = 12;
    public static final int PHYSICAL_DELIVERY_PERSONAL_NAME = 13;
    public static final int PHYSICAL_DELIVERY_ORGANIZATION_NAME = 14;
    public static final int EXTENSION_PHYSICAL_DELIVERY_ADDRESS_COMPONENTS = 15;
    public static final int UNFORMATTED_POSTAL_ADDRESS = 16;
    public static final int STREET_ADDRESS = 17;
    public static final int POST_OFFICE_BOX_ADDRESS = 18;
    public static final int POSTE_RESTANTE_ADDRESS = 19;
    public static final int UNIQUE_POSTAL_NAME = 20;
    public static final int LOCAL_POSTAL_ATTRIBUTES = 21;
    public static final int EXTENDED_NETWORK_ADDRESS = 22;
    public static final int TERMINAL_TYPE = 23;
    private int flag;
    private String stringValue;
    private TeletexPersonalName personalName;
    private String[] unitNames = new String[4];
    private int unitIndex;
    private ORName orName;
    private PDSParameter pdsParam;
    private UnformattedPostalAddress postalAddress;
    private ExtendedNetworkAddress networkAddress;
    private int terminalType;
    private TeletexDomainDefinedAttributes teletexAttr;
    protected int special;
    protected ASN1Template asn1Template;

    public ExtensionAttribute(byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            IntegerContainer type = new IntegerContainer(0x800000);
            EncodedContainer value = new EncodedContainer(8453889);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, type, value, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.flag = type.getValueAsInt();
            switch (this.flag) {
                case 1: {
                    PrintStringContainer common = new PrintStringContainer(0x800001, 1, 64);
                    ASN1Container[] nameDef = new ASN1Container[]{common};
                    ASN1.berDecode((byte[])value.data, (int)value.dataOffset, (ASN1Container[])nameDef);
                    this.stringValue = common.getValueAsString();
                    break;
                }
                case 7: {
                    PrintStringContainer pdsName = new PrintStringContainer(0x800001, 1, 16);
                    ASN1Container[] name1Def = new ASN1Container[]{pdsName};
                    ASN1.berDecode((byte[])value.data, (int)value.dataOffset, (ASN1Container[])name1Def);
                    this.stringValue = pdsName.getValueAsString();
                    break;
                }
                case 2: 
                case 3: {
                    TeletexStringContainer teletexName = new TeletexStringContainer(0x800001, 1, 64);
                    ASN1Container[] name2Def = new ASN1Container[]{teletexName};
                    ASN1.berDecode((byte[])value.data, (int)value.dataOffset, (ASN1Container[])name2Def);
                    this.stringValue = teletexName.getValueAsString();
                    break;
                }
                case 4: {
                    this.personalName = new TeletexPersonalName(value.data, value.dataOffset, 0x800001);
                    break;
                }
                case 5: {
                    OfContainer seqOf = new OfContainer(0x800001, 12288, (ASN1Container)new EncodedContainer(5120));
                    ASN1Container[] asnDef = new ASN1Container[]{seqOf};
                    ASN1.berDecode((byte[])value.data, (int)value.dataOffset, (ASN1Container[])asnDef);
                    int nameCount = seqOf.getContainerCount();
                    if (nameCount > 4) {
                        throw new NameException("Too many entries in TeletexOrganizationalUnitNames: MAX number is 4.");
                    }
                    for (int index = 0; index < nameCount; ++index) {
                        ASN1Container nameContainer = seqOf.containerAt(index);
                        TeletexStringContainer teletex = new TeletexStringContainer(0, 1, 32);
                        ASN1Container[] nameStringDef = new ASN1Container[]{teletex};
                        ASN1.berDecode((byte[])nameContainer.data, (int)nameContainer.dataOffset, (ASN1Container[])nameStringDef);
                        this.unitNames[this.unitIndex] = teletex.getValueAsString();
                        ++this.unitIndex;
                    }
                    break;
                }
                case 6: {
                    this.teletexAttr = new TeletexDomainDefinedAttributes(value.data, value.dataOffset, 0x800001);
                    break;
                }
                case 8: {
                    this.orName = new ORName(4, value.data, value.dataOffset, 0x800001);
                    break;
                }
                case 9: {
                    this.orName = new ORName(3, value.data, value.dataOffset, 0x800001);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    this.pdsParam = new PDSParameter(value.data, value.dataOffset, 0x800001);
                    break;
                }
                case 16: {
                    this.postalAddress = new UnformattedPostalAddress(value.data, value.dataOffset, 0x800001);
                    break;
                }
                case 22: {
                    this.networkAddress = new ExtendedNetworkAddress(value.data, value.dataOffset, 0x800001);
                    break;
                }
                case 23: {
                    IntegerContainer terminal = new IntegerContainer(0x800001);
                    ASN1Container[] name0Def = new ASN1Container[]{terminal};
                    ASN1.berDecode((byte[])value.data, (int)value.dataOffset, (ASN1Container[])name0Def);
                    this.terminalType = terminal.getValueAsInt();
                    if (this.terminalType >= 3 && this.terminalType <= 8) break;
                    throw new NameException("Wrong TerminalType value");
                }
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the ExtensionAttribute.");
        }
    }

    public ExtensionAttribute() {
    }

    public void setAttribute(int type, Object value) throws NameException {
        if (value == null) {
            throw new NameException("Value is null.");
        }
        if (type > 23 || type < 1) {
            throw new NameException("Wrong type.");
        }
        this.flag = type;
        switch (this.flag) {
            case 1: {
                if (value instanceof String && ((String)value).length() < 65) {
                    this.stringValue = (String)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 7: {
                if (value instanceof String && ((String)value).length() < 17) {
                    this.stringValue = (String)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 2: 
            case 3: {
                if (value instanceof String && ((String)value).length() < 65) {
                    this.stringValue = (String)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 4: {
                if (value instanceof TeletexPersonalName) {
                    this.personalName = (TeletexPersonalName)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 5: {
                if (value instanceof Vector && ((Vector)value).size() < 5) {
                    for (int index = 0; index < ((Vector)value).size(); ++index) {
                        if (((Vector)value).elementAt(index) instanceof String) {
                            this.unitNames[this.unitIndex] = (String)((Vector)value).elementAt(index);
                            ++this.unitIndex;
                            continue;
                        }
                        throw new NameException("Wrong value type");
                    }
                    break;
                }
                throw new NameException("Too many entries in TeletexOrganizationalUnitNames: MAX number is 4.");
            }
            case 6: {
                if (value instanceof TeletexDomainDefinedAttributes) {
                    this.teletexAttr = (TeletexDomainDefinedAttributes)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 8: {
                if (value instanceof ORName && ((ORName)value).getNameType() == 4) {
                    this.orName = (ORName)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 9: {
                if (value instanceof ORName && ((ORName)value).getNameType() == 3) {
                    this.orName = (ORName)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (value instanceof PDSParameter) {
                    this.pdsParam = (PDSParameter)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 16: {
                if (value instanceof UnformattedPostalAddress) {
                    this.postalAddress = (UnformattedPostalAddress)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 22: {
                if (value instanceof ExtendedNetworkAddress) {
                    this.networkAddress = (ExtendedNetworkAddress)value;
                    break;
                }
                throw new NameException("Wrong value type");
            }
            case 23: {
                if (!(value instanceof Integer)) {
                    throw new NameException("Wrong value type");
                }
                this.terminalType = (Integer)value;
                if (this.terminalType >= 3 && this.terminalType <= 8) break;
                throw new NameException("Wrong TerminalType value");
            }
        }
    }

    public int getAttributeType() {
        return this.flag;
    }

    public Object getAttribute() {
        switch (this.flag) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.stringValue;
            }
            case 4: {
                return this.personalName;
            }
            case 5: {
                Vector<String> result = new Vector<String>();
                for (int index = 0; index < this.unitIndex; ++index) {
                    result.addElement(this.unitNames[index]);
                }
                return result;
            }
            case 6: {
                return this.teletexAttr;
            }
            case 8: 
            case 9: {
                return this.orName;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return this.pdsParam;
            }
            case 16: {
                return this.postalAddress;
            }
            case 22: {
                return this.networkAddress;
            }
            case 23: {
                return new Integer(this.terminalType);
            }
        }
        return null;
    }

    public String toString() {
        switch (this.flag) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.stringValue;
            }
            case 4: {
                return this.personalName.toString();
            }
            case 5: {
                StringBuffer buffer = new StringBuffer();
                for (int index = 0; index < this.unitIndex - 1; ++index) {
                    buffer.append(this.unitNames[index]);
                    buffer.append(",");
                }
                buffer.append(this.unitNames[this.unitIndex - 1]);
                return buffer.toString();
            }
            case 6: {
                return this.teletexAttr.toString();
            }
            case 8: 
            case 9: {
                return this.orName.toString();
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return this.pdsParam.toString();
            }
            case 16: {
                return this.postalAddress.toString();
            }
            case 22: {
                return this.networkAddress.toString();
            }
            case 23: {
                return Integer.toString(this.terminalType);
            }
        }
        return null;
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode ExtensionAttribute");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ExtensionAttribute");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            SequenceContainer seq = new SequenceContainer(this.special, true, 0);
            EndContainer anEnd = new EndContainer();
            IntegerContainer type = new IntegerContainer(0x800000, true, 0, this.flag);
            switch (this.flag) {
                case 1: {
                    PrintStringContainer common = new PrintStringContainer(0x800001, true, 0, this.stringValue, 1, 64);
                    ASN1Container[] nameDef1 = new ASN1Container[]{seq, type, common, anEnd};
                    this.asn1Template = new ASN1Template(nameDef1);
                    break;
                }
                case 7: {
                    PrintStringContainer pdsName = new PrintStringContainer(0x800001, true, 0, this.stringValue, 1, 16);
                    ASN1Container[] nameDef2 = new ASN1Container[]{seq, type, pdsName, anEnd};
                    this.asn1Template = new ASN1Template(nameDef2);
                    break;
                }
                case 2: 
                case 3: {
                    TeletexStringContainer teletexName = new TeletexStringContainer(0x800001, true, 0, this.stringValue, 1, 64);
                    ASN1Container[] nameDef3 = new ASN1Container[]{seq, type, teletexName, anEnd};
                    this.asn1Template = new ASN1Template(nameDef3);
                    break;
                }
                case 4: {
                    int derLen = this.personalName.getDERLen(0x800001);
                    byte[] perBER = new byte[derLen];
                    int perLen = this.personalName.getDEREncoding(perBER, 0, 0x800001);
                    EncodedContainer personal = new EncodedContainer(8453889, true, 0, perBER, 0, perLen);
                    ASN1Container[] nameDef4 = new ASN1Container[]{seq, type, personal, anEnd};
                    this.asn1Template = new ASN1Template(nameDef4);
                    break;
                }
                case 5: {
                    OfContainer seqOf = new OfContainer(0x800001, true, 0, 12288, (ASN1Container)new EncodedContainer(5120));
                    Vector<OfContainer> asn1Def = new Vector<OfContainer>();
                    asn1Def.addElement(seqOf);
                    for (int index = 0; index < this.unitIndex; ++index) {
                        TeletexStringContainer teletex = new TeletexStringContainer(0, true, 0, this.unitNames[index], 1, 32);
                        ASN1Container[] asnDef = new ASN1Container[]{teletex};
                        ASN1Template templ = new ASN1Template(asnDef);
                        int encodingLen = templ.derEncodeInit();
                        byte[] encoding = new byte[encodingLen];
                        encodingLen = templ.derEncode(encoding, 0);
                        EncodedContainer unitName = new EncodedContainer(5120, true, 0, encoding, 0, encodingLen);
                        seqOf.addContainer((ASN1Container)unitName);
                    }
                    Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
                    asn1Def.copyInto(asn1DefArray);
                    ASN1Template asnTemplate = new ASN1Template((ASN1Container[])asn1DefArray);
                    int encLen = asnTemplate.derEncodeInit();
                    byte[] enc = new byte[encLen];
                    encLen = asnTemplate.derEncode(enc, 0);
                    EncodedContainer next = new EncodedContainer(12288, true, 0, enc, 0, encLen);
                    ASN1Container[] nameDef = new ASN1Container[]{seq, type, next, anEnd};
                    this.asn1Template = new ASN1Template(nameDef);
                    break;
                }
                case 6: {
                    int derLen = this.teletexAttr.getDERLen(0x800001);
                    byte[] attrBER = new byte[derLen];
                    int attrLen = this.teletexAttr.getDEREncoding(attrBER, 0, 0x800001);
                    EncodedContainer teletexDomain = new EncodedContainer(8453889, true, 0, attrBER, 0, attrLen);
                    ASN1Container[] nameDef5 = new ASN1Container[]{seq, type, teletexDomain, anEnd};
                    this.asn1Template = new ASN1Template(nameDef5);
                    break;
                }
                case 8: 
                case 9: {
                    int derLen = this.orName.getDERLen(0x800001);
                    byte[] orBER = new byte[derLen];
                    int orLen = this.orName.getDEREncoding(orBER, 0, 0x800001);
                    EncodedContainer orContainer = new EncodedContainer(8453889, true, 0, orBER, 0, orLen);
                    ASN1Container[] nameDef6 = new ASN1Container[]{seq, type, orContainer, anEnd};
                    this.asn1Template = new ASN1Template(nameDef6);
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    int derLen = this.pdsParam.getDERLen(0x800001);
                    byte[] pdsBER = new byte[derLen];
                    int pdsLen = this.pdsParam.getDEREncoding(pdsBER, 0, 0x800001);
                    EncodedContainer pds = new EncodedContainer(8453889, true, 0, pdsBER, 0, pdsLen);
                    ASN1Container[] nameDef7 = new ASN1Container[]{seq, type, pds, anEnd};
                    this.asn1Template = new ASN1Template(nameDef7);
                    break;
                }
                case 16: {
                    int derLen = this.postalAddress.getDERLen(0x800001);
                    byte[] postBER = new byte[derLen];
                    int postLen = this.postalAddress.getDEREncoding(postBER, 0, 0x800001);
                    EncodedContainer postal = new EncodedContainer(8453889, true, 0, postBER, 0, postLen);
                    ASN1Container[] nameDef8 = new ASN1Container[]{seq, type, postal, anEnd};
                    this.asn1Template = new ASN1Template(nameDef8);
                    break;
                }
                case 22: {
                    int derLen = this.networkAddress.getDERLen(0x800001);
                    byte[] netBER = new byte[derLen];
                    int netLen = this.networkAddress.getDEREncoding(netBER, 0, 0x800001);
                    EncodedContainer network = new EncodedContainer(8453889, true, 0, netBER, 0, netLen);
                    ASN1Container[] nameDef9 = new ASN1Container[]{seq, type, network, anEnd};
                    this.asn1Template = new ASN1Template(nameDef9);
                    break;
                }
                case 23: {
                    IntegerContainer terminal = new IntegerContainer(0x800001, true, 0, this.terminalType);
                    ASN1Container[] nameDef0 = new ASN1Container[]{seq, type, terminal, anEnd};
                    this.asn1Template = new ASN1Template(nameDef0);
                    break;
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ExtensionAttribute)) {
            return false;
        }
        ExtensionAttribute other = (ExtensionAttribute)obj;
        if (this.flag != other.flag) {
            return false;
        }
        switch (this.flag) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                if (this.stringValue.equals(other.stringValue)) break;
                return false;
            }
            case 4: {
                if (this.personalName.equals(other.personalName)) break;
                return false;
            }
            case 5: {
                if (this.unitIndex != other.unitIndex) {
                    return false;
                }
                for (int index = 0; index < this.unitIndex; ++index) {
                    if (this.unitNames[index].equals(other.unitNames[index])) continue;
                    return false;
                }
                break;
            }
            case 6: {
                if (this.teletexAttr.equals(other.teletexAttr)) break;
                return false;
            }
            case 8: 
            case 9: {
                if (this.orName.equals(other.orName)) break;
                return false;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (this.pdsParam.equals(other.pdsParam)) break;
                return false;
            }
            case 16: {
                if (this.postalAddress.equals(other.postalAddress)) break;
                return false;
            }
            case 22: {
                if (this.networkAddress.equals(other.networkAddress)) break;
                return false;
            }
            case 23: {
                if (this.terminalType == other.terminalType) break;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashcode = this.flag;
        switch (this.flag) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                hashcode ^= this.stringValue.hashCode();
                break;
            }
            case 4: {
                hashcode ^= this.personalName.hashCode();
                break;
            }
            case 5: {
                for (int index = 0; index < this.unitIndex; ++index) {
                    hashcode ^= this.unitNames[index].hashCode();
                }
                break;
            }
            case 6: {
                hashcode ^= this.teletexAttr.hashCode();
                break;
            }
            case 8: 
            case 9: {
                hashcode ^= this.orName.hashCode();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                hashcode ^= this.pdsParam.hashCode();
                break;
            }
            case 16: {
                hashcode ^= this.postalAddress.hashCode();
                break;
            }
            case 22: {
                hashcode ^= this.networkAddress.hashCode();
                break;
            }
            case 23: {
                hashcode ^= this.terminalType;
                break;
            }
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        ExtensionAttribute otherSelf = new ExtensionAttribute();
        otherSelf.flag = this.flag;
        switch (this.flag) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                otherSelf.stringValue = this.stringValue;
                break;
            }
            case 4: {
                otherSelf.personalName = (TeletexPersonalName)this.personalName.clone();
                break;
            }
            case 5: {
                otherSelf.unitIndex = this.unitIndex;
                System.arraycopy(this.unitNames, 0, otherSelf.unitNames, 0, this.unitIndex);
                break;
            }
            case 6: {
                otherSelf.teletexAttr = (TeletexDomainDefinedAttributes)this.teletexAttr.clone();
                break;
            }
            case 8: 
            case 9: {
                otherSelf.orName = (ORName)this.orName.clone();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                otherSelf.pdsParam = (PDSParameter)this.pdsParam.clone();
                break;
            }
            case 16: {
                otherSelf.postalAddress = (UnformattedPostalAddress)this.postalAddress.clone();
                break;
            }
            case 22: {
                otherSelf.networkAddress = (ExtendedNetworkAddress)this.networkAddress.clone();
                break;
            }
            case 23: {
                otherSelf.terminalType = this.terminalType;
                break;
            }
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

