/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.extensions.EDIPartyName;
import com.rsa.certj.cert.extensions.NameUtils;
import com.rsa.certj.cert.extensions.ORAddress;
import com.rsa.certj.cert.extensions.OtherName;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.util.Arrays;

public class GeneralName
implements Cloneable,
Serializable {
    private static final int OTHERNAME_SPECIAL = 0x800000;
    private static final int RFC822NAME_SPECIAL = 0x800001;
    private static final int DNSNAME_SPECIAL = 0x800002;
    private static final int ORADDRESS_SPECIAL = 0x800003;
    private static final int DIRNAME_SPECIAL = 0xA00004;
    private static final int EDINAME_SPECIAL = 0x800005;
    private static final int URL_SPECIAL = 0x800006;
    private static final int IPADDRESS_SPECIAL = 0x800007;
    private static final int REGISTEREDID_SPECIAL = 0x800008;
    private String stringValue;
    private ORAddress orAddressValue;
    private EDIPartyName ediValue;
    private OtherName otherValue;
    private X500Name x500Value;
    private byte[] byteValue;
    private int type;
    public static final int OTHER_NAME_TYPE = 1;
    public static final int RFC822_NAME_TYPE = 2;
    public static final int DNS_NAME_TYPE = 3;
    public static final int X400ADDRESS_NAME_TYPE = 4;
    public static final int DIRECTORY_NAME_TYPE = 5;
    public static final int EDIPARTY_NAME_TYPE = 6;
    public static final int URL_NAME_TYPE = 7;
    public static final int IPADDRESS_NAME_TYPE = 8;
    public static final int REGISTERID_NAME_TYPE = 9;
    protected int special;
    private ASN1Template asn1Template;

    public GeneralName(byte[] nameBER, int offset, int special) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ChoiceContainer nameContainer = new ChoiceContainer(special);
            EncodedContainer otherString = new EncodedContainer(0x803000);
            IA5StringContainer rfc822String = new IA5StringContainer(0x800001);
            IA5StringContainer dnsString = new IA5StringContainer(0x800002);
            EncodedContainer orString = new EncodedContainer(0x803003);
            EncodedContainer dirString = new EncodedContainer(10498052);
            EncodedContainer ediString = new EncodedContainer(8400901);
            IA5StringContainer urlString = new IA5StringContainer(0x800006);
            OctetStringContainer octetString = new OctetStringContainer(0x800007);
            OIDContainer oidString = new OIDContainer(0x1800008);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] nameStringDef = new ASN1Container[]{nameContainer, otherString, rfc822String, dnsString, orString, dirString, ediString, urlString, octetString, oidString, endContainer};
            ASN1.berDecode((byte[])nameBER, (int)offset, (ASN1Container[])nameStringDef);
            if (otherString.dataPresent) {
                byte[] other = new byte[otherString.dataLen];
                System.arraycopy(otherString.data, otherString.dataOffset, other, 0, otherString.dataLen);
                this.otherValue = new OtherName();
                this.otherValue.decodeValue(other, 0, 0x800000);
                this.type = 1;
            } else if (rfc822String.dataPresent) {
                this.stringValue = rfc822String.getValueAsString();
                this.type = 2;
            } else if (dnsString.dataPresent) {
                this.stringValue = dnsString.getValueAsString();
                this.type = 3;
            } else if (orString.dataPresent) {
                byte[] orAddress = new byte[orString.dataLen];
                System.arraycopy(orString.data, orString.dataOffset, orAddress, 0, orString.dataLen);
                this.orAddressValue = new ORAddress(orAddress, 0, 0x800003);
                this.type = 4;
            } else if (dirString.dataPresent) {
                byte[] directory = new byte[dirString.dataLen];
                System.arraycopy(dirString.data, dirString.dataOffset, directory, 0, dirString.dataLen);
                this.x500Value = new X500Name(directory, 0, 0xA00004);
                this.type = 5;
            } else if (ediString.dataPresent) {
                byte[] edi = new byte[ediString.dataLen];
                System.arraycopy(ediString.data, ediString.dataOffset, edi, 0, ediString.dataLen);
                this.ediValue = new EDIPartyName(edi, 0, 0x800005);
                this.type = 6;
            } else if (urlString.dataPresent) {
                this.stringValue = urlString.getValueAsString();
                this.type = 7;
            } else if (octetString.dataPresent) {
                this.byteValue = new byte[octetString.dataLen];
                System.arraycopy(octetString.data, octetString.dataOffset, this.byteValue, 0, octetString.dataLen);
                this.type = 8;
            } else if (oidString.dataPresent) {
                this.byteValue = new byte[oidString.dataLen];
                System.arraycopy(oidString.data, oidString.dataOffset, this.byteValue, 0, oidString.dataLen);
                this.type = 9;
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the name.");
        }
    }

    public GeneralName() {
    }

    public void setGeneralName(Object name, int type) throws NameException {
        this.setGeneralName(name, type, false);
    }

    public void setGeneralName(Object name, int type, boolean validateName) throws NameException {
        if (name == null) {
            throw new NameException("Name is null.");
        }
        this.type = type;
        switch (type) {
            case 2: {
                if (name instanceof String) {
                    if (validateName) {
                        NameUtils.validateRFC822Name((String)name);
                    }
                    this.stringValue = (String)name;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be a String for type(" + type + ").");
            }
            case 3: {
                if (name instanceof String) {
                    if (validateName) {
                        NameUtils.validateDnsName((String)name);
                    }
                    this.stringValue = (String)name;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be a String for type(" + type + ").");
            }
            case 7: {
                if (name instanceof String) {
                    if (validateName) {
                        NameUtils.validateURLName((String)name);
                    }
                    this.stringValue = (String)name;
                    break;
                }
                if (name instanceof URL) {
                    this.stringValue = name.toString();
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be either a String or a URL for the URL_NAME_TYPE type.");
            }
            case 1: {
                if (name instanceof OtherName) {
                    this.otherValue = (OtherName)name;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be an OtherName for the OTHER_NAME_TYPE type.");
            }
            case 4: {
                if (name instanceof ORAddress) {
                    this.orAddressValue = (ORAddress)name;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be an ORAddress for the X400ADDRESS_NAME_TYPE type.");
            }
            case 5: {
                if (name instanceof X500Name) {
                    this.x500Value = (X500Name)name;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be an X500Name for the DIRECTORY_NAME_TYPE type.");
            }
            case 6: {
                if (name instanceof EDIPartyName) {
                    this.ediValue = (EDIPartyName)name;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be an EDIPartyName for the EDIPARTY_NAME_TYPE type.");
            }
            case 8: {
                if (name instanceof byte[]) {
                    this.byteValue = (byte[])name;
                    break;
                }
                if (name instanceof InetAddress) {
                    this.byteValue = ((InetAddress)name).getAddress();
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be either a byte array or an InetAddress for the IPADDRESS_NAME_TYPE type.");
            }
            case 9: {
                if (name instanceof byte[]) {
                    this.byteValue = (byte[])name;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be a byte array for the REGISTERID_NAME_TYPE type.");
            }
            default: {
                throw new NameException("GeneralName.setGeneralName: unrecoginized type value(" + type + ").");
            }
        }
    }

    public Object getGeneralName() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 7: {
                return this.stringValue;
            }
            case 8: 
            case 9: {
                return this.byteValue;
            }
            case 1: {
                return this.otherValue;
            }
            case 4: {
                return this.orAddressValue;
            }
            case 5: {
                return this.x500Value;
            }
            case 6: {
                return this.ediValue;
            }
        }
        return null;
    }

    public int getGeneralNameType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 7: {
                return this.stringValue;
            }
            case 8: 
            case 9: {
                StringBuffer buffer = new StringBuffer();
                buffer.append("0x");
                for (int i = 0; i < this.byteValue.length; ++i) {
                    String string = Integer.toHexString(this.byteValue[i]);
                    int len = string.length();
                    if (len < 2) {
                        buffer.append('0');
                        buffer.append(string.charAt(0));
                        continue;
                    }
                    if (len > 2) {
                        buffer.append(string.charAt(len - 2));
                        buffer.append(string.charAt(len - 1));
                        continue;
                    }
                    buffer.append(string);
                }
                return buffer.toString();
            }
            case 1: {
                return this.otherValue.toString();
            }
            case 4: {
                return this.orAddressValue.toString();
            }
            case 5: {
                return this.x500Value.toString();
            }
            case 6: {
                return this.ediValue.toString();
            }
        }
        return null;
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode GeneralName.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode GeneralName.");
        }
    }

    private int derEncodeInit() {
        try {
            IA5StringContainer container;
            ChoiceContainer choiceContainer = new ChoiceContainer(this.special, 0);
            EndContainer endContainer = new EndContainer();
            switch (this.type) {
                case 2: {
                    container = new IA5StringContainer(0x800001, true, 0, this.stringValue);
                    break;
                }
                case 3: {
                    container = new IA5StringContainer(0x800002, true, 0, this.stringValue);
                    break;
                }
                case 7: {
                    container = new IA5StringContainer(0x800006, true, 0, this.stringValue);
                    break;
                }
                case 8: {
                    if (this.byteValue != null) {
                        container = new OctetStringContainer(0x800007, true, 0, this.byteValue, 0, this.byteValue.length);
                        break;
                    }
                    container = new OctetStringContainer(0x800007, false, 0, this.byteValue, 0, 0);
                    break;
                }
                case 9: {
                    if (this.byteValue != null) {
                        container = new OIDContainer(0x1800008, true, 0, this.byteValue, 0, this.byteValue.length);
                        break;
                    }
                    container = new OIDContainer(0x1800008, true, 0, this.byteValue, 0, 0);
                    break;
                }
                case 1: {
                    if (this.otherValue != null) {
                        int otherLen = this.otherValue.getDERLen(0x800000);
                        byte[] otherDER = new byte[otherLen];
                        otherLen = this.otherValue.getDEREncoding(otherDER, 0, 0x800000);
                        container = new EncodedContainer(0x803000, true, 0, otherDER, 0, otherLen);
                        break;
                    }
                    container = new EncodedContainer(0x803000, false, 0, null, 0, 0);
                    break;
                }
                case 4: {
                    if (this.orAddressValue != null) {
                        int oraLen = this.orAddressValue.getDERLen(0x800003);
                        byte[] oraDER = new byte[oraLen];
                        oraLen = this.orAddressValue.getDEREncoding(oraDER, 0, 0x800003);
                        container = new EncodedContainer(0x803003, true, 0, oraDER, 0, oraLen);
                        break;
                    }
                    container = new EncodedContainer(0x803003, false, 0, null, 0, 0);
                    break;
                }
                case 5: {
                    if (this.x500Value != null) {
                        int nameLen = this.x500Value.getDERLen(0xA00004);
                        byte[] nameDER = new byte[nameLen];
                        int returnLen = this.x500Value.getDEREncoding(nameDER, 0, 0xA00004);
                        container = new EncodedContainer(10498052, true, 0, nameDER, 0, returnLen);
                        break;
                    }
                    container = new EncodedContainer(10498052, false, 0, null, 0, 0);
                    break;
                }
                case 6: {
                    if (this.ediValue != null) {
                        int ediLen = this.ediValue.getDERLen(0x800005);
                        byte[] ediDER = new byte[ediLen];
                        ediLen = this.ediValue.getDEREncoding(ediDER, 0, 0x800005);
                        container = new EncodedContainer(8400901, true, 0, ediDER, 0, ediLen);
                        break;
                    }
                    container = new EncodedContainer(8400901, false, 0, null, 0, 0);
                    break;
                }
                default: {
                    return 0;
                }
            }
            ASN1Container[] asn1Def = new ASN1Container[]{choiceContainer, container, endContainer};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GeneralName)) {
            return false;
        }
        GeneralName other = (GeneralName)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.stringValue != null ? !this.stringValue.equals(other.stringValue) : other.stringValue != null) {
            return false;
        }
        if (this.byteValue != null ? !CertJUtils.byteArraysEqual(this.byteValue, other.byteValue) : other.byteValue != null) {
            return false;
        }
        if (this.orAddressValue != null ? !this.orAddressValue.equals(other.orAddressValue) : other.orAddressValue != null) {
            return false;
        }
        if (this.ediValue != null ? !this.ediValue.equals(other.ediValue) : other.ediValue != null) {
            return false;
        }
        if (this.otherValue != null ? !this.otherValue.equals(other.otherValue) : other.otherValue != null) {
            return false;
        }
        return !(this.x500Value != null ? !this.x500Value.equals(other.x500Value) : other.x500Value != null);
    }

    public int hashCode() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 7: {
                return this.stringValue.hashCode();
            }
            case 8: 
            case 9: {
                return Arrays.hashCode(this.byteValue);
            }
            case 1: {
                return this.otherValue.hashCode();
            }
            case 4: {
                return this.orAddressValue.hashCode();
            }
            case 5: {
                return this.x500Value.hashCode();
            }
            case 6: {
                return this.ediValue.hashCode();
            }
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralName otherSelf = new GeneralName();
        otherSelf.type = this.type;
        if (this.stringValue != null) {
            otherSelf.stringValue = this.stringValue;
        }
        otherSelf.byteValue = this.byteValue;
        otherSelf.orAddressValue = this.orAddressValue;
        otherSelf.ediValue = this.ediValue;
        otherSelf.otherValue = this.otherValue;
        otherSelf.x500Value = this.x500Value;
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

