/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IntegerContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class InhibitAnyPolicy
extends X509V3Extension
implements CertExtension {
    private int skipCerts;
    ASN1Template asn1TemplateValue;

    public InhibitAnyPolicy() {
        this.extensionTypeFlag = 54;
        this.criticality = false;
        this.setStandardOID(54);
        this.extensionTypeString = "InhibitAnyPolicy";
    }

    public InhibitAnyPolicy(int skipCerts, boolean criticality) {
        this.extensionTypeFlag = 54;
        this.criticality = criticality;
        this.skipCerts = skipCerts;
        this.setStandardOID(54);
        this.extensionTypeString = "InhibitAnyPolicy";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.skipCerts = 0;
        IntegerContainer number = new IntegerContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{number};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (number.dataLen == 0) {
                return;
            }
            if (number.dataLen > 4) {
                throw new CertificateException("Could not decode InhibitAnyPolicy extension.");
            }
            this.skipCerts = number.getValueAsInt();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode InhibitAnyPolicy extension.");
        }
    }

    public void setSkipCerts(int number) {
        this.skipCerts = number;
    }

    public int getSkipCerts() {
        return this.skipCerts;
    }

    public int derEncodeValueInit() {
        IntegerContainer number = new IntegerContainer(0, true, 0, this.skipCerts);
        ASN1Container[] asn1Def = new ASN1Container[]{number};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        InhibitAnyPolicy otherSelf = new InhibitAnyPolicy();
        otherSelf.skipCerts = this.skipCerts;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.skipCerts = 0;
        this.asn1TemplateValue = null;
    }
}

