/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class IssuingDistributionPoint
extends X509V3Extension
implements CRLExtension {
    public static final int REASON_FLAGS_BITS = 9;
    public static final int REASON_FLAGS_MASK = -8388608;
    public static final int UNUSED = Integer.MIN_VALUE;
    public static final int KEY_COMPROMISE = 0x40000000;
    public static final int CA_COMPROMISE = 0x20000000;
    public static final int AFFILIATION_CHANGED = 0x10000000;
    public static final int SUPERSEDED = 0x8000000;
    public static final int CESSATION_OF_OPERATION = 0x4000000;
    public static final int CERTIFICATE_HOLD = 0x2000000;
    public static final int PRIVILEGE_WITHDRAWN = 0x1000000;
    public static final int AA_COMPROMISE = 0x800000;
    private static final int DISTRIBUTION_POINT_SPECIAL = 0x810000;
    private static final int USER_CERTS_SPECIAL = 8519681;
    private static final int CA_CERTS_SPECIAL = 0x820002;
    private static final int REASONS_SPECIAL = 8454147;
    private static final int INDIRECT_CRL_SPECIAL = 8519684;
    private static final int ATTRIBUTE_CERTS_SPECIAL = 8519685;
    private static final int FULL_NAME_SPECIAL = 0x800000;
    private static final int NAME_RELATIVE_SPECIAL = 0x800001;
    ASN1Template asn1TemplateValue;
    private GeneralNames genDistributionPoint;
    private RDN rdnDistributionPoint;
    private int reasonFlags = -1;
    private boolean userCerts;
    private boolean caCerts;
    private boolean indirectCRL;
    private boolean attributeCerts;

    public IssuingDistributionPoint() {
        this.extensionTypeFlag = 28;
        this.criticality = false;
        this.setStandardOID(28);
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public IssuingDistributionPoint(RDN distributionPoint, boolean userCerts, boolean caCerts, int reason, boolean indirectCRL, boolean attributeCerts, boolean criticality) {
        this.extensionTypeFlag = 28;
        this.criticality = criticality;
        this.setStandardOID(28);
        this.rdnDistributionPoint = distributionPoint;
        this.userCerts = userCerts;
        this.caCerts = caCerts;
        this.reasonFlags = reason;
        this.indirectCRL = indirectCRL;
        this.attributeCerts = attributeCerts;
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public IssuingDistributionPoint(GeneralNames distributionPoint, boolean userCerts, boolean caCerts, int reason, boolean indirectCRL, boolean attributeCerts, boolean criticality) {
        this.extensionTypeFlag = 28;
        this.criticality = criticality;
        this.setStandardOID(28);
        this.genDistributionPoint = distributionPoint;
        this.userCerts = userCerts;
        this.caCerts = caCerts;
        this.reasonFlags = reason;
        this.indirectCRL = indirectCRL;
        this.attributeCerts = attributeCerts;
        this.extensionTypeString = "IssuingDistributionPoint";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            ChoiceContainer pointContainer = new ChoiceContainer(0x810000);
            EncodedContainer genName = new EncodedContainer(0x803000);
            EncodedContainer rdn = new EncodedContainer(8401153);
            BooleanContainer user = new BooleanContainer(8519681);
            BooleanContainer ca = new BooleanContainer(0x820002);
            BitStringContainer bits = new BitStringContainer(8454147);
            BooleanContainer indirect = new BooleanContainer(8519684);
            BooleanContainer attribute = new BooleanContainer(8519685);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, pointContainer, genName, rdn, anEnd, user, ca, bits, indirect, attribute, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (genName.dataPresent) {
                this.genDistributionPoint = new GeneralNames(genName.data, genName.dataOffset, 0x800000);
            } else if (rdn.dataPresent) {
                this.rdnDistributionPoint = new RDN(rdn.data, rdn.dataOffset, 0x800001);
            } else {
                this.genDistributionPoint = null;
                this.rdnDistributionPoint = null;
            }
            this.userCerts = user.dataPresent && user.value;
            boolean bl = this.caCerts = ca.dataPresent && ca.value;
            if (bits.dataPresent) {
                if (bits.dataLen > 4) {
                    throw new CertificateException("Could not decode IssuingDistributionPoint extension.");
                }
                if (bits.dataLen == 0) {
                    this.reasonFlags = 0;
                } else {
                    int keyUsage = 0;
                    int index = bits.dataOffset;
                    int shiftCount = 24;
                    while (index < bits.dataOffset + bits.dataLen) {
                        keyUsage |= (bits.data[index] & 0xFF) << shiftCount;
                        ++index;
                        shiftCount -= 8;
                    }
                    this.reasonFlags = keyUsage &= 0xFF800000;
                }
            } else {
                this.reasonFlags = -1;
            }
            this.indirectCRL = indirect.dataPresent && indirect.value;
            this.attributeCerts = attribute.dataPresent && attribute.value;
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode IssuingDistributionPoint extension.");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not create new GeneralNames object.");
        }
    }

    public void setIssuingDistributionPointName(GeneralNames distributionPoint) {
        this.genDistributionPoint = distributionPoint;
        this.rdnDistributionPoint = null;
    }

    public void setIssuingDistributionPointName(RDN distributionPoint) {
        this.rdnDistributionPoint = distributionPoint;
        this.genDistributionPoint = null;
    }

    public void setUserCerts(boolean userCerts) {
        this.userCerts = userCerts;
    }

    public void setCACerts(boolean caCerts) {
        this.caCerts = caCerts;
    }

    public void setReasonFlags(int reason) {
        this.reasonFlags = reason;
    }

    public void setIndirectCRL(boolean indirectCRL) {
        this.indirectCRL = indirectCRL;
    }

    public void setAttributeCerts(boolean attributeCerts) {
        this.attributeCerts = attributeCerts;
    }

    public Object getDistributionPointName() {
        if (this.rdnDistributionPoint != null) {
            return this.rdnDistributionPoint;
        }
        return this.genDistributionPoint;
    }

    public boolean getUserCerts() {
        return this.userCerts;
    }

    public boolean getCACerts() {
        return this.caCerts;
    }

    public int getReasonFlags() {
        return this.reasonFlags;
    }

    public boolean getIndirectCRL() {
        return this.indirectCRL;
    }

    public boolean getAttributeCerts() {
        return this.attributeCerts;
    }

    public int derEncodeValueInit() {
        int flag = 0;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        ChoiceContainer choice = null;
        BitStringContainer reasonFlag = null;
        EncodedContainer name = null;
        EndContainer aEnd = new EndContainer();
        if (this.genDistributionPoint != null || this.rdnDistributionPoint != null) {
            choice = new ChoiceContainer(0x810000, 0);
            try {
                name = this.encodeName();
            }
            catch (CertificateException certException) {
                return 0;
            }
            flag = 1;
        }
        if (this.reasonFlags != -1) {
            reasonFlag = new BitStringContainer(8454147, true, 0, this.reasonFlags, 9, true);
            flag = flag == 0 ? 2 : 3;
        }
        BooleanContainer user = this.createBooleanContainer(8519681, this.userCerts);
        BooleanContainer ca = this.createBooleanContainer(0x820002, this.caCerts);
        BooleanContainer indirect = this.createBooleanContainer(8519684, this.indirectCRL);
        BooleanContainer attribute = this.createBooleanContainer(8519685, this.attributeCerts);
        switch (flag) {
            case 0: {
                ASN1Container[] asnDef0 = new ASN1Container[]{seq, user, ca, indirect, attribute, aEnd};
                this.asn1TemplateValue = new ASN1Template(asnDef0);
                break;
            }
            case 1: {
                ASN1Container[] asnDef1 = new ASN1Container[]{seq, choice, name, aEnd, user, ca, indirect, attribute, aEnd};
                this.asn1TemplateValue = new ASN1Template(asnDef1);
                break;
            }
            case 2: {
                ASN1Container[] asnDef2 = new ASN1Container[]{seq, user, ca, reasonFlag, indirect, attribute, aEnd};
                this.asn1TemplateValue = new ASN1Template(asnDef2);
                break;
            }
            case 3: {
                ASN1Container[] asnDef3 = new ASN1Container[]{seq, choice, name, aEnd, user, ca, reasonFlag, indirect, attribute, aEnd};
                this.asn1TemplateValue = new ASN1Template(asnDef3);
                break;
            }
        }
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private BooleanContainer createBooleanContainer(int special, boolean data) {
        return new BooleanContainer(special, data, 0, data);
    }

    private EncodedContainer encodeName() throws CertificateException {
        EncodedContainer name = null;
        try {
            if (this.genDistributionPoint != null) {
                int nameDERLen = this.genDistributionPoint.getDERLen(0x800000);
                byte[] nameDER = new byte[nameDERLen];
                nameDERLen = this.genDistributionPoint.getDEREncoding(nameDER, 0, 0x800000);
                name = new EncodedContainer(12288, true, 0, nameDER, 0, nameDERLen);
            } else if (this.rdnDistributionPoint != null) {
                int nameDERLen = this.rdnDistributionPoint.getDERLen(0x800001);
                byte[] nameDER = new byte[nameDERLen];
                nameDERLen = this.rdnDistributionPoint.getDEREncoding(nameDER, 0, 0x800001);
                name = new EncodedContainer(12544, true, 0, nameDER, 0, nameDERLen);
            }
            return name;
        }
        catch (ASN_Exception e) {
            throw new CertificateException("Can't encode DistributionPointNames", (Exception)((Object)e));
        }
        catch (NameException e) {
            throw new CertificateException("Can't encode DistributionPointNames", e);
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IssuingDistributionPoint otherSelf = new IssuingDistributionPoint();
        if (this.genDistributionPoint != null) {
            otherSelf.genDistributionPoint = (GeneralNames)this.genDistributionPoint.clone();
        }
        if (this.rdnDistributionPoint != null) {
            otherSelf.rdnDistributionPoint = (RDN)this.rdnDistributionPoint.clone();
        }
        otherSelf.reasonFlags = this.reasonFlags;
        otherSelf.userCerts = this.userCerts;
        otherSelf.caCerts = this.caCerts;
        otherSelf.indirectCRL = this.indirectCRL;
        otherSelf.attributeCerts = this.attributeCerts;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.genDistributionPoint = null;
        this.rdnDistributionPoint = null;
        this.reasonFlags = 0;
        this.userCerts = false;
        this.caCerts = false;
        this.indirectCRL = false;
        this.attributeCerts = false;
        this.asn1TemplateValue = null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IssuingDistributionPoint)) {
            return false;
        }
        IssuingDistributionPoint otherIDP = (IssuingDistributionPoint)other;
        if (this.genDistributionPoint == null && otherIDP.genDistributionPoint != null || this.genDistributionPoint != null && otherIDP.genDistributionPoint == null) {
            return false;
        }
        if (this.genDistributionPoint != null && !this.genDistributionPoint.equals(otherIDP.genDistributionPoint)) {
            return false;
        }
        if (this.rdnDistributionPoint == null && otherIDP.rdnDistributionPoint != null || this.rdnDistributionPoint != null && otherIDP.rdnDistributionPoint == null) {
            return false;
        }
        if (this.rdnDistributionPoint != null && !this.rdnDistributionPoint.equals(otherIDP.rdnDistributionPoint)) {
            return false;
        }
        return this.reasonFlags == otherIDP.reasonFlags && this.userCerts == otherIDP.userCerts && this.caCerts == otherIDP.caCerts && this.indirectCRL == otherIDP.indirectCRL && this.attributeCerts == otherIDP.attributeCerts;
    }

    public int hashCode() {
        int result = 0;
        if (this.genDistributionPoint != null) {
            result = this.genDistributionPoint.hashCode();
        }
        if (this.rdnDistributionPoint != null) {
            result ^= this.rdnDistributionPoint.hashCode();
        }
        String booleanValues = String.valueOf(this.userCerts) + String.valueOf(this.caCerts) + String.valueOf(this.indirectCRL) + String.valueOf(this.attributeCerts);
        return result ^= booleanValues.hashCode();
    }
}

