/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class KeyUsage
extends X509V3Extension
implements CertExtension {
    public static final int KEY_USAGE_BITS = 9;
    public static final int KEY_USAGE_MASK = -8388608;
    public static final int DIGITAL_SIGNATURE = Integer.MIN_VALUE;
    public static final int NON_REPUDIATION = 0x40000000;
    public static final int KEY_ENCIPHERMENT = 0x20000000;
    public static final int DATA_ENCIPHERMENT = 0x10000000;
    public static final int KEY_AGREEMENT = 0x8000000;
    public static final int KEY_CERT_SIGN = 0x4000000;
    public static final int CRL_SIGN = 0x2000000;
    public static final int ENCIPHER_ONLY = 0x1000000;
    public static final int DECIPHER_ONLY = 0x800000;
    private int keyUsage;
    ASN1Template asn1TemplateValue;

    public KeyUsage() {
        this.extensionTypeFlag = 15;
        this.criticality = false;
        this.setStandardOID(15);
        this.extensionTypeString = "KeyUsage";
    }

    public KeyUsage(int keyUsage, boolean criticality) {
        this.extensionTypeFlag = 15;
        this.criticality = criticality;
        this.keyUsage = keyUsage & 0xFF800000;
        this.setStandardOID(15);
        this.extensionTypeString = "KeyUsage";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.keyUsage = 0;
        BitStringContainer bits = new BitStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{bits};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode KeyUsage extension.");
        }
        if (bits.dataLen == 0) {
            return;
        }
        if (bits.dataLen > 4) {
            throw new CertificateException("Could not decode KeyUsage extension.");
        }
        int index = bits.dataOffset;
        int shiftCount = 24;
        while (index < bits.dataOffset + bits.dataLen) {
            this.keyUsage |= (bits.data[index] & 0xFF) << shiftCount;
            ++index;
            shiftCount -= 8;
        }
        this.keyUsage &= 0xFF800000;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public boolean verifyKeyUsage(int usageToVerify) {
        int keyUsageMask = usageToVerify & this.keyUsage & 0xFF800000;
        return keyUsageMask == usageToVerify;
    }

    public int derEncodeValueInit() {
        BitStringContainer bits = new BitStringContainer(0, true, 0, this.keyUsage, 9, true);
        ASN1Container[] asn1Def = new ASN1Container[]{bits};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        KeyUsage otherSelf = new KeyUsage();
        otherSelf.keyUsage = this.keyUsage;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.keyUsage = 0;
        this.asn1TemplateValue = null;
    }
}

