/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class NetscapeBaseURL
extends X509V3Extension
implements CertExtension {
    private String baseURL;
    ASN1Template asn1TemplateValue;

    public NetscapeBaseURL() {
        this.extensionTypeFlag = 102;
        this.criticality = false;
        this.setSpecialOID(NETSCAPE_BASE_URL_OID);
        this.extensionTypeString = "NetscapeBaseURL";
    }

    public NetscapeBaseURL(String baseURL, boolean criticality) {
        this.extensionTypeFlag = 102;
        this.criticality = criticality;
        this.setSpecialOID(NETSCAPE_BASE_URL_OID);
        if (baseURL != null) {
            this.baseURL = baseURL;
        }
        this.extensionTypeString = "NetscapeBaseURL";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            IA5StringContainer urlString = new IA5StringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{urlString};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.baseURL = urlString.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode NetscapeBaseURL extension.");
        }
    }

    public void setBaseURL(String baseURL) {
        if (baseURL != null) {
            this.baseURL = baseURL;
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public int derEncodeValueInit() {
        try {
            IA5StringContainer urlString = new IA5StringContainer(0, true, 0, this.baseURL);
            ASN1Container[] asn1Def = new ASN1Container[]{urlString};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NetscapeBaseURL otherSelf = new NetscapeBaseURL();
        otherSelf.baseURL = this.baseURL;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.baseURL = null;
        this.asn1TemplateValue = null;
    }
}

