/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class NetscapeCertType
extends X509V3Extension
implements CertExtension {
    public static final int CERT_TYPE_BITS = 8;
    public static final int CERT_TYPE_MASK = -16777216;
    public static final int SSL_CLIENT = Integer.MIN_VALUE;
    public static final int SSL_SERVER = 0x40000000;
    public static final int SMIME_CLIENT = 0x20000000;
    public static final int OBJECT_SIGNING = 0x10000000;
    public static final int RESERVED = 0x8000000;
    public static final int SSL_CA = 0x4000000;
    public static final int SMIME_CA = 0x2000000;
    public static final int OBJECT_SIGNING_CA = 0x1000000;
    private int certType;
    ASN1Template asn1TemplateValue;

    public NetscapeCertType() {
        this.extensionTypeFlag = 101;
        this.criticality = false;
        this.setSpecialOID(NETSCAPE_CERT_TYPE_OID);
        this.extensionTypeString = "NetscapeCertType";
    }

    public NetscapeCertType(int certType, boolean criticality) {
        this.extensionTypeFlag = 101;
        this.criticality = criticality;
        this.setSpecialOID(NETSCAPE_CERT_TYPE_OID);
        this.certType = certType & 0xFF000000;
        this.extensionTypeString = "NetscapeCertType";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.certType = 0;
        BitStringContainer bits = new BitStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{bits};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode NetscapeCertType extension.");
        }
        if (bits.dataLen == 0) {
            return;
        }
        if (bits.dataLen > 4) {
            throw new CertificateException("Could not decode NetscapeCertType extension.");
        }
        int index = bits.dataOffset;
        int shiftCount = 24;
        while (index < bits.dataOffset + bits.dataLen) {
            this.certType |= (bits.data[index] & 0xFF) << shiftCount;
            ++index;
            shiftCount -= 8;
        }
        this.certType &= 0xFF000000;
    }

    public void setCertType(int certType) {
        this.certType = certType & 0xFF000000;
    }

    public int getCertType() {
        return this.certType;
    }

    public boolean verifyCertType(int typeToVerify) {
        int certTypeMask = typeToVerify & this.certType & 0xFF000000;
        return certTypeMask == typeToVerify;
    }

    public int derEncodeValueInit() {
        BitStringContainer bits = new BitStringContainer(0, true, 0, this.certType, 8, true);
        ASN1Container[] asn1Def = new ASN1Container[]{bits};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NetscapeCertType otherSelf = new NetscapeCertType();
        otherSelf.certType = this.certType;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.certType = 0;
        this.asn1TemplateValue = null;
    }
}

