/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class NetscapeComment
extends X509V3Extension
implements CertExtension {
    private String comment;
    ASN1Template asn1TemplateValue;

    public NetscapeComment() {
        this.extensionTypeFlag = 108;
        this.criticality = false;
        this.setSpecialOID(NETSCAPE_COMMENT_OID);
        this.extensionTypeString = "NetscapeComment";
    }

    public NetscapeComment(String comment, boolean criticality) {
        this.extensionTypeFlag = 108;
        this.criticality = criticality;
        this.setSpecialOID(NETSCAPE_COMMENT_OID);
        if (comment != null) {
            this.comment = comment;
        }
        this.extensionTypeString = "NetscapeComment";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            IA5StringContainer urlString = new IA5StringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{urlString};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.comment = urlString.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode NetscapeComment extension.");
        }
    }

    public void setComment(String comment) {
        if (comment != null) {
            this.comment = comment;
        }
    }

    public String getComment() {
        return this.comment;
    }

    public int derEncodeValueInit() {
        try {
            IA5StringContainer urlString = new IA5StringContainer(0, true, 0, this.comment);
            ASN1Container[] asn1Def = new ASN1Container[]{urlString};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NetscapeComment otherSelf = new NetscapeComment();
        otherSelf.comment = this.comment;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.comment = null;
        this.asn1TemplateValue = null;
    }
}

