/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPRequestExtension;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class NonStandardExtension
extends X509V3Extension
implements CertExtension,
CRLExtension,
CRLEntryExtension,
OCSPRequestExtension,
OCSPSingleExtension {
    private byte[] valueBER;

    public NonStandardExtension() {
        this.criticality = false;
        this.extensionTypeFlag = -1;
        this.extensionTypeString = "NonStandardExtension";
    }

    public NonStandardExtension(byte[] oid, boolean criticality, byte[] valueBER) {
        if (oid != null) {
            this.theOID = (byte[])oid.clone();
            this.theOIDLen = oid.length;
        }
        if (valueBER != null) {
            this.valueBER = (byte[])valueBER.clone();
        }
        this.criticality = criticality;
        this.extensionTypeFlag = -1;
        this.extensionTypeString = "NonStandardExtension";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            int berLen = 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
            this.valueBER = new byte[berLen];
            System.arraycopy(valueBER, offset, this.valueBER, 0, berLen);
        }
        catch (ASN_Exception aSN_Exception) {
            // empty catch block
        }
    }

    public void setOID(byte[] oid, int offset, int len) {
        if (oid != null && len != 0) {
            this.theOID = new byte[len];
            this.theOIDLen = len;
            System.arraycopy(oid, offset, this.theOID, 0, len);
        }
    }

    public void setValueBER(byte[] value, int offset, int len) {
        if (value != null && len != 0) {
            this.valueBER = new byte[len];
            System.arraycopy(value, offset, this.valueBER, 0, len);
        }
    }

    public byte[] getValueBER() {
        if (this.valueBER == null) {
            return null;
        }
        byte[] returnValue = new byte[this.valueBER.length];
        System.arraycopy(this.valueBER, 0, returnValue, 0, this.valueBER.length);
        return returnValue;
    }

    public int derEncodeValueInit() {
        if (this.valueBER != null) {
            return this.valueBER.length;
        }
        return 0;
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (this.valueBER == null) {
            return 0;
        }
        System.arraycopy(this.valueBER, 0, encoding, offset, this.valueBER.length);
        return this.valueBER.length;
    }

    public Object clone() throws CloneNotSupportedException {
        NonStandardExtension otherSelf = new NonStandardExtension();
        if (this.valueBER != null) {
            otherSelf.valueBER = (byte[])this.valueBER.clone();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.valueBER = null;
    }
}

