/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1Template;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class OCSPNoCheck
extends X509V3Extension
implements CertExtension {
    ASN1Template asn1TemplateValue;

    public OCSPNoCheck() {
        this.extensionTypeFlag = 117;
        this.criticality = false;
        this.setSpecialOID(OCSP_NOCHECK_OID);
        this.extensionTypeString = "OCSPNoCheck";
    }

    public OCSPNoCheck(boolean criticality) {
        this.extensionTypeFlag = 117;
        this.setSpecialOID(OCSP_NOCHECK_OID);
        this.extensionTypeString = "OCSPNoCheck";
        this.criticality = criticality;
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        if (valueBER.length < 2 + offset) {
            throw new CertificateException("Invalid  encoding of OCSP NoCheck extension.");
        }
        if (valueBER[offset] != 5 || valueBER[offset + 1] != 0) {
            throw new CertificateException("Invalid  encoding of OCSP NoCheck extension.");
        }
    }

    public int derEncodeValueInit() {
        return 2;
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        encoding[offset] = 5;
        encoding[offset + 1] = 0;
        return 2;
    }

    public Object clone() throws CloneNotSupportedException {
        OCSPNoCheck otherSelf = new OCSPNoCheck();
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.asn1TemplateValue = null;
    }
}

